/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewType;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EUserRole;
import org.eclipse.mylyn.reviews.r4e.core.model.RModelFactory;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.IFindUserDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.IParticipantInputDialog;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EInputValidator;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EUIDialogFactory;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIParticipant;
import org.eclipse.mylyn.reviews.r4e.ui.internal.preferences.R4EPreferencePage;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.CommandUtils;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.IEditableListListener;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.mylyn.reviews.userSearch.query.IQueryUser;
import org.eclipse.mylyn.reviews.userSearch.query.QueryUserFactory;
import org.eclipse.mylyn.reviews.userSearch.userInfo.IUserInfo;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParticipantInputDialog
extends FormDialog
implements IParticipantInputDialog,
IEditableListListener {
    private static final String ADD_PARTICIPANT_DIALOG_TITLE = "Enter Participants Details";
    private static final String PARTICIPANTS_GROUP_LABEL = "Participants";
    private static final String PARTICIPANT_LABEL = "participant";
    private static final String ADD_BUTTON_LABEL = "Add";
    private static final String REMOVE_BUTTON_LABEL = "Erase";
    private static final String FIND_BUTTON_LABEL = "Find...";
    private static final String CLEAR_BUTTON_LABEL = "Clear";
    private static final String LDAP_NOT_CONFIGURED = "LDAP Server not present or not configured";
    private static final String LDAP_NOT_CONFIGURED_DETAILED = "No LDAP Server is currently configured to accept queries.  You can add the Server configuration in the R4E LDAP Preferences";
    protected Text fParticipantIdInputTextField;
    protected Text fParticipantEmailInputTextField;
    protected Text fParticipantDetailsInputTextField;
    private final List<String> fParticipantsDetailsValues = new ArrayList<String>();
    private final IInputValidator fValidator;
    private Table fAddedParticipantsTable;
    private Scrollable fUserToAddCombo;
    private List<R4EParticipant> fParticipants = new ArrayList<R4EParticipant>();
    protected int fSelectedParticipantIndex = -1;
    private Button fAddUserButton;
    private Button fRemoveUserButton;
    private Button fFindUserButton;
    private Button fClearParticipantsButton;
    private final boolean fReviewSource;

    public ParticipantInputDialog(IShellProvider aShellProvider, boolean aReviewSource) {
        super(aShellProvider);
        this.setBlockOnOpen(true);
        this.fValidator = new R4EInputValidator();
        this.fReviewSource = aReviewSource;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            ArrayList<R4EParticipant> validatedParticipants = new ArrayList<R4EParticipant>();
            for (R4EParticipant newParticipant : this.fParticipants) {
                ErrorDialog dialog;
                String validateResult = this.validateEmptyInput(newParticipant.getId());
                if (validateResult != null) {
                    dialog = new ErrorDialog(null, "R4E Error", "No input given for Participant Id", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, validateResult, null), 4);
                    dialog.open();
                    return;
                }
                validateResult = this.validateEmptyInput(newParticipant.getEmail());
                if (validateResult != null) {
                    dialog = new ErrorDialog(null, "R4E Error", "No Email given for Participant " + newParticipant.getId(), (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, validateResult, null), 4);
                    dialog.open();
                    return;
                }
                if (!CommandUtils.isEmailValid(newParticipant.getEmail())) {
                    return;
                }
                R4EParticipant currentParticipant = null;
                if (R4EUIModelController.getActiveReview() != null) {
                    try {
                        currentParticipant = R4EUIModelController.getActiveReview().getParticipant(newParticipant.getId(), false);
                    }
                    catch (ResourceHandlingException resourceHandlingException) {}
                    if (this.fReviewSource && R4EUIModelController.getActiveReview().isParticipant(newParticipant.getId()) && currentParticipant != null && currentParticipant.isEnabled()) {
                        ErrorDialog dialog2 = new ErrorDialog(null, "R4E Error", "Cannot Add Participant " + newParticipant.getId(), (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", 0, "Participant already part of this Review", null), 4);
                        dialog2.open();
                        continue;
                    }
                    if (newParticipant.getRoles().size() == 0) {
                        if (R4EUIModelController.getActiveReview().getReview().getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_BASIC)) {
                            newParticipant.getRoles().add((Object)R4EUserRole.R4E_ROLE_LEAD);
                        } else {
                            newParticipant.getRoles().add((Object)R4EUserRole.R4E_ROLE_REVIEWER);
                        }
                    }
                }
                validatedParticipants.add(newParticipant);
            }
            this.fParticipants = validatedParticipants;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ADD_PARTICIPANT_DIALOG_TITLE);
        shell.setMinimumSize(400, 300);
    }

    @Override
    public void create() {
        this.fParticipantsDetailsValues.clear();
        this.fParticipants.clear();
        super.create();
    }

    @Override
    public int open() {
        return super.open();
    }

    @Override
    public boolean close() {
        return super.close();
    }

    protected void createFormContent(IManagedForm mform) {
        FormToolkit toolkit = mform.getToolkit();
        ScrolledForm sform = mform.getForm();
        sform.setExpandVertical(true);
        Composite composite = sform.getBody();
        GridLayout layout = new GridLayout(4, false);
        composite.setLayout((Layout)layout);
        this.createParticipantsGroup(toolkit, composite);
        this.createBasicParameters(toolkit, composite);
        this.fUserToAddCombo.setFocus();
    }

    private void createParticipantsGroup(FormToolkit aToolkit, Composite aComposite) {
        Group usersToAddGroup = new Group(aComposite, 0);
        usersToAddGroup.setText(PARTICIPANTS_GROUP_LABEL);
        usersToAddGroup.setBackground(this.getShell().getDisplay().getSystemColor(1));
        usersToAddGroup.setLayout((Layout)new GridLayout(4, false));
        GridData groupGridData = new GridData(4, 4, true, true);
        usersToAddGroup.setLayoutData((Object)groupGridData);
        Composite dataComposite = aToolkit.createComposite((Composite)usersToAddGroup);
        dataComposite.setLayout((Layout)new GridLayout());
        GridData dataCompositeData = new GridData(4, 4, true, true);
        dataCompositeData.horizontalSpan = 3;
        dataComposite.setLayoutData((Object)dataCompositeData);
        Composite buttonsComposite = aToolkit.createComposite((Composite)usersToAddGroup);
        buttonsComposite.setLayout((Layout)new GridLayout());
        GridData buttonsCompositeData = new GridData(3, 4, false, true);
        buttonsComposite.setLayoutData((Object)buttonsCompositeData);
        String[] participantsLists = R4EPreferencePage.getParticipantsLists();
        if (participantsLists.length > 0) {
            this.fUserToAddCombo = new CCombo(dataComposite, 2052);
            ((CCombo)this.fUserToAddCombo).setItems(participantsLists);
            ((CCombo)this.fUserToAddCombo).setEditable(true);
        } else {
            this.fUserToAddCombo = aToolkit.createText(dataComposite, "", 2052);
            ((Text)this.fUserToAddCombo).setEditable(true);
        }
        GridData textGridData = new GridData(4, 1, true, false);
        this.fUserToAddCombo.setToolTipText("Semicolon-separated List of Users to be added to the Participant List");
        this.fUserToAddCombo.setLayoutData((Object)textGridData);
        this.fUserToAddCombo.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                String widgetStr = null;
                widgetStr = ParticipantInputDialog.this.fUserToAddCombo instanceof CCombo ? ((CCombo)ParticipantInputDialog.this.fUserToAddCombo).getText() : ((Text)ParticipantInputDialog.this.fUserToAddCombo).getText().trim();
                if (widgetStr.trim().length() > 0) {
                    ParticipantInputDialog.this.fAddUserButton.setEnabled(true);
                } else {
                    ParticipantInputDialog.this.fAddUserButton.setEnabled(false);
                }
            }
        });
        this.fUserToAddCombo.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.character == '\r') {
                    String[] users;
                    ParticipantInputDialog.this.getShell().setCursor(ParticipantInputDialog.this.getShell().getDisplay().getSystemCursor(1));
                    String widgetStr = null;
                    widgetStr = ParticipantInputDialog.this.fUserToAddCombo instanceof CCombo ? ((CCombo)ParticipantInputDialog.this.fUserToAddCombo).getText() : ((Text)ParticipantInputDialog.this.fUserToAddCombo).getText();
                    String[] stringArray = users = widgetStr.split(";");
                    int n = users.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String user = stringArray[n2];
                        ParticipantInputDialog.this.addUsersToParticipantList(user);
                        ++n2;
                    }
                    if (ParticipantInputDialog.this.fUserToAddCombo instanceof CCombo) {
                        ((CCombo)ParticipantInputDialog.this.fUserToAddCombo).setText("");
                    } else {
                        ((Text)ParticipantInputDialog.this.fUserToAddCombo).setText("");
                    }
                    ParticipantInputDialog.this.getShell().setCursor(ParticipantInputDialog.this.getShell().getDisplay().getSystemCursor(0));
                }
            }
        });
        Composite tableComposite = aToolkit.createComposite(dataComposite);
        GridData tableCompositeData = new GridData(4, 4, true, true);
        this.fAddedParticipantsTable = aToolkit.createTable(tableComposite, 67584);
        this.fAddedParticipantsTable.setHeaderVisible(true);
        this.fAddedParticipantsTable.setLinesVisible(true);
        this.fAddedParticipantsTable.setToolTipText("Add User to Participant List");
        this.fAddedParticipantsTable.setLinesVisible(true);
        this.fAddedParticipantsTable.setItemCount(0);
        GridData tableGridData = new GridData(4, 4, true, true);
        this.fAddedParticipantsTable.setLayoutData((Object)tableGridData);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        TableColumn idColumn = new TableColumn(this.fAddedParticipantsTable, 0, 0);
        idColumn.setText("Id: ");
        TableColumn emailColumn = new TableColumn(this.fAddedParticipantsTable, 0, 1);
        emailColumn.setText("Email: ");
        tableColumnLayout.setColumnData((Widget)idColumn, (ColumnLayoutData)new ColumnWeightData(30, idColumn.getWidth() * 2, true));
        tableColumnLayout.setColumnData((Widget)emailColumn, (ColumnLayoutData)new ColumnWeightData(70, emailColumn.getWidth(), true));
        tableComposite.setLayout((Layout)tableColumnLayout);
        tableComposite.setLayoutData((Object)tableCompositeData);
        this.fAddedParticipantsTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ParticipantInputDialog.this.fSelectedParticipantIndex = ParticipantInputDialog.this.fAddedParticipantsTable.getSelectionIndex();
                if (ParticipantInputDialog.this.fSelectedParticipantIndex >= 0) {
                    R4EParticipant participant = (R4EParticipant)ParticipantInputDialog.this.fParticipants.get(ParticipantInputDialog.this.fSelectedParticipantIndex);
                    if (participant != null) {
                        ParticipantInputDialog.this.fParticipantIdInputTextField.setText(participant.getId());
                        if (participant.getEmail() != null) {
                            ParticipantInputDialog.this.fParticipantEmailInputTextField.setText(participant.getEmail());
                        } else {
                            ParticipantInputDialog.this.fParticipantEmailInputTextField.setText("");
                        }
                        if (ParticipantInputDialog.this.fSelectedParticipantIndex < ParticipantInputDialog.this.fParticipantsDetailsValues.size()) {
                            ParticipantInputDialog.this.fParticipantDetailsInputTextField.setText((String)ParticipantInputDialog.this.fParticipantsDetailsValues.get(ParticipantInputDialog.this.fSelectedParticipantIndex));
                        } else {
                            ParticipantInputDialog.this.fParticipantDetailsInputTextField.setText("");
                        }
                    }
                    ParticipantInputDialog.this.fParticipantIdInputTextField.setEnabled(true);
                    ParticipantInputDialog.this.fParticipantEmailInputTextField.setEnabled(true);
                    ParticipantInputDialog.this.fParticipantDetailsInputTextField.setEnabled(true);
                }
            }
        });
        this.fAddUserButton = aToolkit.createButton(buttonsComposite, ADD_BUTTON_LABEL, 0);
        GridData addButtonGridData = new GridData(1, 1, false, false);
        this.fAddUserButton.setEnabled(false);
        this.fAddUserButton.setToolTipText("Semicolon-separated List of Users to be added to the Participant List");
        this.fAddUserButton.setLayoutData((Object)addButtonGridData);
        this.fAddUserButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String[] users;
                ParticipantInputDialog.this.getShell().setCursor(ParticipantInputDialog.this.getShell().getDisplay().getSystemCursor(1));
                String widgetStr = null;
                widgetStr = ParticipantInputDialog.this.fUserToAddCombo instanceof CCombo ? ((CCombo)ParticipantInputDialog.this.fUserToAddCombo).getText() : ((Text)ParticipantInputDialog.this.fUserToAddCombo).getText();
                String[] stringArray = users = widgetStr.split(";");
                int n = users.length;
                int n2 = 0;
                while (n2 < n) {
                    String user = stringArray[n2];
                    ParticipantInputDialog.this.addUsersToParticipantList(user);
                    ++n2;
                }
                ParticipantInputDialog.this.getShell().setCursor(ParticipantInputDialog.this.getShell().getDisplay().getSystemCursor(0));
            }
        });
        this.fFindUserButton = aToolkit.createButton(buttonsComposite, FIND_BUTTON_LABEL, 0);
        GridData findButtonGridData = new GridData(1, 1, false, false);
        this.fFindUserButton.setToolTipText("Search for Users...");
        this.fFindUserButton.setLayoutData((Object)findButtonGridData);
        this.fFindUserButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (R4EUIModelController.isUserQueryAvailable()) {
                    IFindUserDialog dialog = R4EUIDialogFactory.getInstance().getFindUserDialog();
                    dialog.create();
                    dialog.setDialogsDefaults();
                    int result = dialog.open();
                    if (result == 0) {
                        List<IUserInfo> usersInfos = dialog.getUserInfos();
                        for (IUserInfo user : usersInfos) {
                            ParticipantInputDialog.this.addUserToParticipantList(user);
                        }
                    }
                } else {
                    R4EUIPlugin.Ftracer.traceWarning(ParticipantInputDialog.LDAP_NOT_CONFIGURED);
                    final ErrorDialog dialog = new ErrorDialog(null, "R4E Warning", ParticipantInputDialog.LDAP_NOT_CONFIGURED, (IStatus)new Status(2, "org.eclipse.mylyn.reviews.r4e.ui", 0, ParticipantInputDialog.LDAP_NOT_CONFIGURED_DETAILED, null), 2);
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            dialog.open();
                        }
                    });
                }
            }
        });
        this.fRemoveUserButton = aToolkit.createButton(buttonsComposite, REMOVE_BUTTON_LABEL, 0);
        GridData removeButtonGridData = new GridData(1, 1, false, false);
        this.fRemoveUserButton.setEnabled(false);
        this.fRemoveUserButton.setToolTipText("Remove selected Participants from list");
        this.fRemoveUserButton.setLayoutData((Object)removeButtonGridData);
        if (!R4EUIModelController.isUserQueryAvailable()) {
            this.fRemoveUserButton.setEnabled(false);
        }
        this.fRemoveUserButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (ParticipantInputDialog.this.fSelectedParticipantIndex >= 0 && ParticipantInputDialog.this.fSelectedParticipantIndex < ParticipantInputDialog.this.fAddedParticipantsTable.getItemCount()) {
                    ParticipantInputDialog.this.fAddedParticipantsTable.remove(ParticipantInputDialog.this.fSelectedParticipantIndex);
                    ParticipantInputDialog.this.fParticipants.remove(ParticipantInputDialog.this.fSelectedParticipantIndex);
                    ParticipantInputDialog.this.fParticipantsDetailsValues.remove(ParticipantInputDialog.this.fSelectedParticipantIndex);
                    ParticipantInputDialog.this.clearParametersFields();
                }
            }
        });
        this.fClearParticipantsButton = aToolkit.createButton(buttonsComposite, CLEAR_BUTTON_LABEL, 0);
        GridData clearButtonGridData = new GridData(1, 1, false, false);
        this.fClearParticipantsButton.setEnabled(false);
        this.fClearParticipantsButton.setToolTipText("Clear Participants list");
        this.fClearParticipantsButton.setLayoutData((Object)clearButtonGridData);
        this.fClearParticipantsButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ParticipantInputDialog.this.fParticipants.clear();
                ParticipantInputDialog.this.fParticipantsDetailsValues.clear();
                ParticipantInputDialog.this.fAddedParticipantsTable.removeAll();
                ParticipantInputDialog.this.fSelectedParticipantIndex = -1;
                ParticipantInputDialog.this.clearParametersFields();
            }
        });
    }

    private void createBasicParameters(FormToolkit aToolkit, Composite aComposite) {
        Section basicSection = aToolkit.createSection(aComposite, 450);
        GridData basicSectionGridData = new GridData(4, 4, true, false);
        basicSectionGridData.horizontalSpan = 4;
        basicSection.setLayoutData((Object)basicSectionGridData);
        basicSection.setText("Basic Parameters");
        basicSection.setDescription("Enter the mandatory basic parameters for this participant");
        basicSection.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ParticipantInputDialog.this.getShell().setSize(ParticipantInputDialog.this.getShell().computeSize(-1, -1));
            }
        });
        Composite basicSectionClient = aToolkit.createComposite((Composite)basicSection);
        GridLayout layout = new GridLayout(4, false);
        basicSectionClient.setLayout((Layout)layout);
        basicSection.setClient((Control)basicSectionClient);
        Label label = aToolkit.createLabel(basicSectionClient, "Id: ");
        label.setToolTipText("A Tag that Identifies this Participant");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        aToolkit.setBorderStyle(0);
        this.fParticipantIdInputTextField = aToolkit.createText(basicSectionClient, "");
        GridData textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fParticipantIdInputTextField.setEnabled(false);
        this.fParticipantIdInputTextField.setEditable(false);
        this.fParticipantIdInputTextField.setToolTipText("A Tag that Identifies this Participant");
        this.fParticipantIdInputTextField.setLayoutData((Object)textGridData);
        label = aToolkit.createLabel(basicSectionClient, "Email: ");
        label.setToolTipText("The Email Address for the Participant");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        aToolkit.setBorderStyle(2048);
        this.fParticipantEmailInputTextField = aToolkit.createText(basicSectionClient, "", 4);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        this.fParticipantEmailInputTextField.setToolTipText("The Email Address for the Participant");
        this.fParticipantEmailInputTextField.setLayoutData((Object)textGridData);
        this.fParticipantEmailInputTextField.setEnabled(false);
        this.fParticipantEmailInputTextField.addListener(16, new Listener(){

            public void handleEvent(Event event) {
                if (ParticipantInputDialog.this.fSelectedParticipantIndex >= 0) {
                    R4EParticipant participant = (R4EParticipant)ParticipantInputDialog.this.fParticipants.get(ParticipantInputDialog.this.fSelectedParticipantIndex);
                    participant.setEmail(ParticipantInputDialog.this.fParticipantEmailInputTextField.getText().trim());
                    TableItem item = ParticipantInputDialog.this.fAddedParticipantsTable.getItem(ParticipantInputDialog.this.fSelectedParticipantIndex);
                    if (participant.getEmail() != null) {
                        item.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont"));
                        item.setText(1, participant.getEmail());
                    } else {
                        item.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
                    }
                }
            }
        });
        label = aToolkit.createLabel(basicSectionClient, "User Details: ");
        label.setToolTipText("Extra Information about this Participant");
        label.setLayoutData((Object)new GridData(1, 1, false, false));
        aToolkit.setBorderStyle(0);
        this.fParticipantDetailsInputTextField = aToolkit.createText(basicSectionClient, "", 522);
        textGridData = new GridData(4, 4, true, false);
        textGridData.horizontalSpan = 3;
        textGridData.heightHint = this.fParticipantDetailsInputTextField.getLineHeight() << 3;
        this.fParticipantDetailsInputTextField.setEnabled(false);
        this.fParticipantDetailsInputTextField.setEditable(false);
        this.fParticipantDetailsInputTextField.setToolTipText("Extra Information about this Participant");
        this.fParticipantDetailsInputTextField.setLayoutData((Object)textGridData);
    }

    protected Control createButtonBar(Composite parent) {
        Control bar = super.createButtonBar(parent);
        this.getButton(0).setEnabled(false);
        return bar;
    }

    protected boolean isResizable() {
        return true;
    }

    private String validateEmptyInput(String aText) {
        return this.fValidator.isValid(aText);
    }

    @Override
    public List<R4EParticipant> getParticipants() {
        return this.fParticipants;
    }

    private void clearParametersFields() {
        this.fParticipantIdInputTextField.setText("");
        this.fParticipantEmailInputTextField.setText("");
        this.fParticipantDetailsInputTextField.setText("");
        if (this.fParticipants.size() == 0) {
            this.fParticipantDetailsInputTextField.setEnabled(false);
            this.fParticipantIdInputTextField.setEnabled(false);
            this.fParticipantEmailInputTextField.setEnabled(false);
            this.fClearParticipantsButton.setEnabled(false);
            this.fRemoveUserButton.setEnabled(false);
            if (this.fReviewSource) {
                this.getButton(0).setEnabled(false);
            }
        }
    }

    private void addUsersToParticipantList(String aUser) {
        List<String> resolvedUsers = R4EPreferencePage.getParticipantsFromList(aUser.trim());
        for (String user : resolvedUsers) {
            String[] userTokens = user.split(";");
            R4EParticipant participant = this.getParticipant(userTokens[0].toLowerCase());
            if (participant == null) {
                return;
            }
            if (2 == userTokens.length && !userTokens[1].trim().equals("")) {
                participant.setEmail(userTokens[1]);
            }
            if (R4EUIModelController.getActiveReview() != null) {
                try {
                    R4EParticipant reviewParticipant = R4EUIModelController.getActiveReview().getParticipant(participant.getId(), false);
                    if (reviewParticipant != null) {
                        participant.setEmail(reviewParticipant.getEmail());
                    }
                }
                catch (ResourceHandlingException e) {
                    UIUtils.displayResourceErrorDialog(e);
                }
            }
            this.fParticipants.add(participant);
            this.updateComponents(participant);
        }
    }

    private void addUserToParticipantList(IUserInfo aUserInfo) {
        for (R4EParticipant tmpPart : this.fParticipants) {
            if (!aUserInfo.getUserId().equalsIgnoreCase(tmpPart.getId())) continue;
            return;
        }
        R4EParticipant participant = RModelFactory.eINSTANCE.createR4EParticipant();
        participant.setId(aUserInfo.getUserId());
        participant.setEmail(aUserInfo.getEmail());
        this.fParticipantsDetailsValues.add(UIUtils.buildUserDetailsString(aUserInfo));
        this.fParticipants.add(participant);
        this.updateComponents(participant);
    }

    private void updateComponents(R4EParticipant aParticipant) {
        TableItem item = new TableItem(this.fAddedParticipantsTable, 0);
        item.setText(0, aParticipant.getId());
        if (aParticipant.getEmail() != null && !"".equals(aParticipant.getEmail())) {
            item.setFont(JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont"));
            item.setText(1, aParticipant.getEmail());
        } else {
            item.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
        }
        this.fAddedParticipantsTable.showItem(item);
        if (this.fParticipants.size() > 0) {
            this.fClearParticipantsButton.setEnabled(true);
            this.fRemoveUserButton.setEnabled(true);
            if (this.fUserToAddCombo instanceof CCombo) {
                ((CCombo)this.fUserToAddCombo).setText("");
            } else {
                ((Text)this.fUserToAddCombo).setText("");
            }
            this.getButton(0).setEnabled(true);
            this.getButton(0).setSelection(false);
        } else if (this.fReviewSource) {
            this.getButton(0).setEnabled(false);
        }
    }

    protected R4EParticipant getParticipant(String aId) {
        for (R4EParticipant tmpPart : this.fParticipants) {
            if (!aId.equalsIgnoreCase(tmpPart.getId())) continue;
            return null;
        }
        R4EParticipant participant = RModelFactory.eINSTANCE.createR4EParticipant();
        if (R4EUIModelController.isUserQueryAvailable()) {
            IQueryUser query = new QueryUserFactory().getInstance();
            try {
                ArrayList users = query.searchByUserId(aId);
                for (IUserInfo user : users) {
                    if (!user.getUserId().toLowerCase().equals(aId)) continue;
                    participant.setId(user.getUserId().toLowerCase());
                    participant.setEmail(user.getEmail());
                    this.fParticipantsDetailsValues.add(UIUtils.buildUserDetailsString(user));
                    return participant;
                }
            }
            catch (NamingException e) {
                R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                R4EUIPlugin.getDefault().logError("Exception: " + e.toString(), e);
            }
            catch (IOException e) {
                R4EUIPlugin.getDefault().logWarning("Exception: " + e.toString(), e);
            }
        }
        participant.setId(aId);
        this.fParticipantsDetailsValues.add("");
        return participant;
    }

    @Override
    public void itemsUpdated(Item[] aItems, int aInstanceId) {
        if (this.fSelectedParticipantIndex >= 0) {
            R4EParticipant participant = this.fParticipants.get(this.fSelectedParticipantIndex);
            if (aInstanceId == 0) {
                participant.getRoles().clear();
                Item[] itemArray = aItems;
                int n = aItems.length;
                int n2 = 0;
                while (n2 < n) {
                    Item item = itemArray[n2];
                    R4EUserRole role = R4EUIParticipant.mapStringToRole(item.getText());
                    if (role != null) {
                        participant.getRoles().add((Object)role);
                    }
                    ++n2;
                }
            }
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    @Override
    public void itemSelected(Item aItem, int aInstanceId) {
    }

    @Override
    public void addParticipant(String aParticipant) {
        this.addUsersToParticipantList(aParticipant);
    }
}

