/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.editors;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.compare.ISharedDocumentAdapter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.EditableSharedDocumentAdapter;
import org.eclipse.team.internal.ui.synchronize.LocalResourceTypedElement;
import org.eclipse.ui.IEditorInput;

public class R4EFileTypedElement
extends LocalResourceTypedElement
implements IAdaptable {
    private final R4EFileVersion fFileVersion;
    private boolean fDirty = false;
    private EditableSharedDocumentAdapter sharedDocumentAdapter;
    private long timestamp;
    private boolean exists;
    private boolean useSharedDocument = true;
    private EditableSharedDocumentAdapter.ISharedDocumentAdapterListener sharedDocumentListener;

    public R4EFileTypedElement(R4EFileVersion aFileVersion) {
        super(aFileVersion.getResource());
        this.fFileVersion = aFileVersion;
        this.exists = aFileVersion.getResource().exists();
    }

    public R4EFileVersion getFileVersion() {
        return this.fFileVersion;
    }

    public void setContent(byte[] contents) {
        this.fDirty = true;
        super.setContent(contents);
    }

    public void commit(IProgressMonitor monitor) throws CoreException {
        if (this.isDirty()) {
            if (this.isConnected()) {
                this.saveDocument(true, monitor);
            } else {
                IResource resource = this.getResource();
                if (resource instanceof IFile) {
                    ByteArrayInputStream is = null;
                    try {
                        is = new ByteArrayInputStream(this.getContent());
                        IFile file = (IFile)resource;
                        if (file.exists()) {
                            file.setContents((InputStream)is, false, true, monitor);
                        } else {
                            file.create((InputStream)is, false, monitor);
                        }
                        this.fDirty = false;
                    }
                    catch (Throwable throwable) {
                        this.fireContentChanged();
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    this.fireContentChanged();
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                this.updateTimestamp();
            }
        }
    }

    public InputStream getContents() throws CoreException {
        if (this.exists) {
            return super.getContents();
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (ISharedDocumentAdapter.class.equals((Object)adapter)) {
            if (this.isSharedDocumentsEnable()) {
                return this.getSharedDocumentAdapter();
            }
            return null;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    private synchronized ISharedDocumentAdapter getSharedDocumentAdapter() {
        if (this.sharedDocumentAdapter == null) {
            this.sharedDocumentAdapter = new EditableSharedDocumentAdapter(new EditableSharedDocumentAdapter.ISharedDocumentAdapterListener(){

                public void handleDocumentConnected() {
                    R4EFileTypedElement.this.updateTimestamp();
                    if (R4EFileTypedElement.this.sharedDocumentListener != null) {
                        R4EFileTypedElement.this.sharedDocumentListener.handleDocumentConnected();
                    }
                }

                public void handleDocumentFlushed() {
                    R4EFileTypedElement.this.fireContentChanged();
                    if (R4EFileTypedElement.this.sharedDocumentListener != null) {
                        R4EFileTypedElement.this.sharedDocumentListener.handleDocumentFlushed();
                    }
                }

                public void handleDocumentDeleted() {
                    R4EFileTypedElement.this.update();
                    if (R4EFileTypedElement.this.sharedDocumentListener != null) {
                        R4EFileTypedElement.this.sharedDocumentListener.handleDocumentDeleted();
                    }
                }

                public void handleDocumentSaved() {
                    R4EFileTypedElement.this.updateTimestamp();
                    if (R4EFileTypedElement.this.sharedDocumentListener != null) {
                        R4EFileTypedElement.this.sharedDocumentListener.handleDocumentSaved();
                    }
                }

                public void handleDocumentDisconnected() {
                    if (R4EFileTypedElement.this.sharedDocumentListener != null) {
                        R4EFileTypedElement.this.sharedDocumentListener.handleDocumentDisconnected();
                    }
                }
            });
        }
        return this.sharedDocumentAdapter;
    }

    public boolean isEditable() {
        IResource resource = this.getResource();
        return resource.getType() == 1 && this.exists;
    }

    public boolean isConnected() {
        return this.sharedDocumentAdapter != null && this.sharedDocumentAdapter.isConnected();
    }

    public boolean saveDocument(boolean overwrite, IProgressMonitor monitor) throws CoreException {
        if (this.isConnected()) {
            IEditorInput input = this.sharedDocumentAdapter.getDocumentKey((Object)this);
            this.sharedDocumentAdapter.saveDocument(input, overwrite, monitor);
            this.updateTimestamp();
            return true;
        }
        return false;
    }

    protected InputStream createStream() throws CoreException {
        InputStream inputStream = super.createStream();
        this.updateTimestamp();
        return inputStream;
    }

    void updateTimestamp() {
        if (this.getResource().exists()) {
            this.timestamp = this.getResource().getLocalTimeStamp();
        } else {
            this.exists = false;
        }
    }

    private long getTimestamp() {
        return this.timestamp;
    }

    public int hashCode() {
        return this.getResource().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof R4EFileTypedElement) {
            R4EFileTypedElement otherElement = (R4EFileTypedElement)((Object)obj);
            return otherElement.getResource().equals((Object)this.getResource()) && this.exists == otherElement.exists;
        }
        return false;
    }

    public void update() {
        this.exists = this.getResource().exists();
    }

    public boolean isSynchronized() {
        long current = this.getResource().getLocalTimeStamp();
        return current == this.getTimestamp();
    }

    public boolean exists() {
        return this.exists;
    }

    public void discardBuffer() {
        if (this.sharedDocumentAdapter != null) {
            this.sharedDocumentAdapter.releaseBuffer();
        }
        super.discardBuffer();
    }

    public boolean isSharedDocumentsEnable() {
        return this.useSharedDocument && this.getResource().getType() == 1 && this.exists;
    }

    public void enableSharedDocument(boolean enablement) {
        this.useSharedDocument = enablement;
    }

    public boolean isDirty() {
        return this.fDirty || this.sharedDocumentAdapter != null && this.sharedDocumentAdapter.hasBufferedContents();
    }

    public void setSharedDocumentListener(EditableSharedDocumentAdapter.ISharedDocumentAdapterListener sharedDocumentListener) {
        this.sharedDocumentListener = sharedDocumentListener;
    }
}

