/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.databinding.IdentityWrapper;
import org.eclipse.core.internal.databinding.Util;
import org.eclipse.core.runtime.Assert;

public class IdentityMap<K, V>
implements Map<K, V> {
    private Map<IdentityWrapper<K>, V> wrappedMap = new HashMap<IdentityWrapper<K>, V>();

    public IdentityMap() {
    }

    public IdentityMap(Map<? extends K, ? extends V> map) {
        this();
        Assert.isNotNull(map);
        this.putAll(map);
    }

    @Override
    public void clear() {
        this.wrappedMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrappedMap.containsKey(IdentityWrapper.wrap(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrappedMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        final Set<Map.Entry<IdentityWrapper<K>, V>> wrappedEntrySet = this.wrappedMap.entrySet();
        return new Set<Map.Entry<K, V>>(){

            @Override
            public boolean add(Map.Entry<K, V> o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<K, V>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                wrappedEntrySet.clear();
            }

            @Override
            public boolean contains(Object o) {
                for (Map.Entry entry : this) {
                    if (!entry.equals(o)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                for (Object element : c) {
                    if (this.contains(element)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean isEmpty() {
                return wrappedEntrySet.isEmpty();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator wrappedIterator = wrappedEntrySet.iterator();
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return wrappedIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        final Map.Entry wrappedEntry = (Map.Entry)wrappedIterator.next();
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return ((IdentityWrapper)wrappedEntry.getKey()).unwrap();
                            }

                            @Override
                            public V getValue() {
                                return wrappedEntry.getValue();
                            }

                            @Override
                            public V setValue(V value) {
                                return wrappedEntry.setValue(value);
                            }

                            @Override
                            public boolean equals(Object obj) {
                                if (obj == this) {
                                    return true;
                                }
                                if (obj == null || !(obj instanceof Map.Entry)) {
                                    return false;
                                }
                                Map.Entry that = (Map.Entry)obj;
                                return this.getKey() == that.getKey() && Util.equals(this.getValue(), that.getValue());
                            }

                            @Override
                            public int hashCode() {
                                return wrappedEntry.hashCode();
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        wrappedIterator.remove();
                    }
                };
            }

            @Override
            public boolean remove(Object o) {
                final Map.Entry unwrappedEntry = (Map.Entry)o;
                Object key = unwrappedEntry.getKey();
                final IdentityWrapper wrappedKey = IdentityWrapper.wrap(key);
                Map.Entry<IdentityWrapper<Object>, Object> wrappedEntry = new Map.Entry<IdentityWrapper<Object>, Object>(){

                    @Override
                    public IdentityWrapper<Object> getKey() {
                        return wrappedKey;
                    }

                    @Override
                    public Object getValue() {
                        return unwrappedEntry.getValue();
                    }

                    @Override
                    public Object setValue(Object value) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean equals(Object obj) {
                        if (obj == this) {
                            return true;
                        }
                        if (obj == null || !(obj instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry that = (Map.Entry)obj;
                        return Util.equals(wrappedKey, that.getKey()) && Util.equals(this.getValue(), that.getValue());
                    }

                    @Override
                    public int hashCode() {
                        return wrappedKey.hashCode() ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
                    }
                };
                return wrappedEntrySet.remove(wrappedEntry);
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                boolean changed = false;
                for (Object element : c) {
                    changed |= this.remove(element);
                }
                return changed;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                boolean changed = false;
                Object[] toRetain = c.toArray();
                Iterator iterator = this.iterator();
                block0: while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    int i = 0;
                    while (i < toRetain.length) {
                        if (((Object)entry).equals(toRetain[i])) continue block0;
                        ++i;
                    }
                    iterator.remove();
                    changed = true;
                }
                return changed;
            }

            @Override
            public int size() {
                return wrappedEntrySet.size();
            }

            @Override
            public Object[] toArray() {
                return this.toArray(new Object[this.size()]);
            }

            @Override
            public <T> T[] toArray(T[] a) {
                int size = this.size();
                if (a.length < size) {
                    a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
                }
                int i = 0;
                for (Map.Entry entry : this) {
                    a[i++] = entry;
                }
                return a;
            }

            @Override
            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj == null || !(obj instanceof Set)) {
                    return false;
                }
                Set that = (Set)obj;
                return this.size() == that.size() && this.containsAll(that);
            }

            @Override
            public int hashCode() {
                return wrappedEntrySet.hashCode();
            }
        };
    }

    @Override
    public V get(Object key) {
        return this.wrappedMap.get(IdentityWrapper.wrap(key));
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        final Set<IdentityWrapper<K>> wrappedKeySet = this.wrappedMap.keySet();
        return new Set<K>(){

            @Override
            public boolean add(K o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends K> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                wrappedKeySet.clear();
            }

            @Override
            public boolean contains(Object o) {
                return wrappedKeySet.contains(IdentityWrapper.wrap(o));
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                for (Object element : c) {
                    if (wrappedKeySet.contains(IdentityWrapper.wrap(element))) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean isEmpty() {
                return wrappedKeySet.isEmpty();
            }

            @Override
            public Iterator<K> iterator() {
                final Iterator wrappedIterator = wrappedKeySet.iterator();
                return new Iterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return wrappedIterator.hasNext();
                    }

                    @Override
                    public K next() {
                        return ((IdentityWrapper)wrappedIterator.next()).unwrap();
                    }

                    @Override
                    public void remove() {
                        wrappedIterator.remove();
                    }
                };
            }

            @Override
            public boolean remove(Object o) {
                return wrappedKeySet.remove(IdentityWrapper.wrap(o));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                boolean changed = false;
                for (Object element : c) {
                    changed |= wrappedKeySet.remove(IdentityWrapper.wrap(element));
                }
                return changed;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                boolean changed = false;
                Object[] toRetain = c.toArray();
                block0: for (Object element : this) {
                    int i = 0;
                    while (i < toRetain.length) {
                        if (element == toRetain[i]) continue block0;
                        ++i;
                    }
                    this.remove(element);
                    changed = true;
                }
                return changed;
            }

            @Override
            public int size() {
                return wrappedKeySet.size();
            }

            @Override
            public Object[] toArray() {
                return this.toArray(new Object[wrappedKeySet.size()]);
            }

            @Override
            public <T> T[] toArray(T[] a) {
                int size = wrappedKeySet.size();
                Object[] result = a;
                if (a.length < size) {
                    result = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
                }
                int i = 0;
                for (IdentityWrapper wrapper : wrappedKeySet) {
                    result[i++] = wrapper.unwrap();
                }
                return result;
            }

            @Override
            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj == null || !(obj instanceof Set)) {
                    return false;
                }
                Set that = (Set)obj;
                return this.size() == that.size() && this.containsAll(that);
            }

            @Override
            public int hashCode() {
                return wrappedKeySet.hashCode();
            }
        };
    }

    @Override
    public V put(K key, V value) {
        return this.wrappedMap.put(IdentityWrapper.wrap(key), value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> other) {
        for (Map.Entry<K, V> entry : other.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            this.wrappedMap.put(IdentityWrapper.wrap(key), value);
        }
    }

    @Override
    public V remove(Object key) {
        return this.wrappedMap.remove(IdentityWrapper.wrap(key));
    }

    @Override
    public int size() {
        return this.wrappedMap.size();
    }

    @Override
    public Collection<V> values() {
        return this.wrappedMap.values();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Map)) {
            return false;
        }
        Map that = (Map)obj;
        return this.entrySet().equals(that.entrySet());
    }

    @Override
    public int hashCode() {
        return this.wrappedMap.hashCode();
    }
}

