/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.variables;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.Activator;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;

public class GitTemplateVariableResolver
extends TemplateVariableResolver {
    public GitTemplateVariableResolver(String type, String description) {
        super(type, description);
    }

    public GitTemplateVariableResolver() {
    }

    public void resolve(TemplateVariable variable, TemplateContext context) {
        GitTemplateVariableResolver.resolveVariable(variable, context);
    }

    protected static void resolveVariable(TemplateVariable variable, IProject project) {
        List params = variable.getVariableType().getParams();
        if (params.isEmpty()) {
            variable.setValue("");
            return;
        }
        String gitKey = (String)params.get(0);
        if (gitKey == null || gitKey.length() == 0) {
            variable.setValue("");
            return;
        }
        RepositoryMapping mapping = RepositoryMapping.getMapping((IProject)project);
        Repository repository = null;
        if (mapping != null) {
            repository = mapping.getRepository();
        }
        if (repository == null) {
            variable.setValue("");
            return;
        }
        StoredConfig config = repository.getConfig();
        String[] splits = gitKey.split("\\.");
        String section = null;
        String subSection = null;
        String name = null;
        if (splits.length == 3) {
            section = splits[0];
            subSection = splits[1];
            name = splits[2];
        } else if (splits.length == 2) {
            section = splits[0];
            name = splits[1];
        } else {
            variable.setValue("");
            return;
        }
        String gitValue = config.getString(section, subSection, name);
        if (gitValue != null) {
            variable.setValue(gitValue);
        }
    }

    protected static void resolveVariable(TemplateVariable variable, TemplateContext context) {
        IProject project = GitTemplateVariableResolver.getProject(context);
        if (project != null) {
            GitTemplateVariableResolver.resolveVariable(variable, project);
        }
    }

    @Nullable
    protected static IProject getProject(TemplateContext context) {
        if (IAdaptable.class.isInstance(context)) {
            return (IProject)AdapterUtils.adapt((Object)context, IProject.class);
        }
        if (Activator.hasJavaPlugin()) {
            boolean hasPublicMethod = context.getClass().getSimpleName().equals("CodeTemplateContext");
            try {
                Method method;
                if (hasPublicMethod) {
                    method = context.getClass().getMethod("getJavaProject", new Class[0]);
                } else {
                    method = context.getClass().getSuperclass().getDeclaredMethod("getJavaProject", new Class[0]);
                    method.setAccessible(true);
                }
                Object result = method.invoke((Object)context, new Object[0]);
                if (result instanceof IJavaProject) {
                    IJavaProject javaProject = (IJavaProject)result;
                    return javaProject.getProject();
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                return null;
            }
        }
        return null;
    }
}

