/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTabView;
import org.eclipse.swt.internal.cocoa.NSTabViewItem;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.NSWindow;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;

public class TabItem
extends Item {
    static final int IMAGE_GAP = 2;
    TabFolder parent;
    Control control;
    String toolTipText;
    NSTabViewItem nsItem;
    NSAttributedString attriStr;

    public TabItem(TabFolder parent, int style) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
    }

    public TabItem(TabFolder parent, int style, int index) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, index);
    }

    @Override
    long accessibilityAttributeValue(long id2, long sel, long arg0) {
        if (id2 == this.nsItem.id) {
            NSString nsAttributeName = new NSString(arg0);
            if (nsAttributeName.isEqualToString(OS.NSAccessibilityTitleAttribute)) {
                if (this.text != null) {
                    return NSString.stringWith((String)this.text).id;
                }
            } else if (nsAttributeName.isEqualToString(OS.NSAccessibilityHelpAttribute) && this.toolTipText != null) {
                return NSString.stringWith((String)this.toolTipText).id;
            }
        }
        return super.accessibilityAttributeValue(id2, sel, arg0);
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void deregister() {
        super.deregister();
        this.display.removeWidget(this.nsItem);
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    @Override
    void drawLabelInRect(long id2, long sel, boolean shouldTruncateLabel, NSRect rect) {
        if (this.image != null && !this.image.isDisposed()) {
            NSSize imageSize = this.image.handle.size();
            NSRect destRect = new NSRect();
            destRect.x = rect.x;
            destRect.y = rect.y;
            destRect.width = imageSize.width;
            destRect.height = imageSize.height;
            NSGraphicsContext.static_saveGraphicsState();
            NSAffineTransform transform = NSAffineTransform.transform();
            transform.scaleXBy(1.0, -1.0);
            transform.translateXBy(0.0, -(destRect.height + 2.0 * destRect.y));
            transform.concat();
            this.image.handle.drawInRect(destRect, new NSRect(), 2L, 1.0);
            NSGraphicsContext.static_restoreGraphicsState();
            rect.x += imageSize.width + 2.0;
            rect.width -= imageSize.width + 2.0;
        }
        if (this.attriStr != null) {
            this.attriStr.drawInRect(rect);
        }
        super.drawLabelInRect(id2, sel, shouldTruncateLabel, rect);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        Rectangle result = new Rectangle(0, 0, 0, 0);
        if (this.nsItem.respondsToSelector(OS.sel_accessibilityAttributeValue_)) {
            long posValue = OS.objc_msgSend(this.nsItem.id, OS.sel_accessibilityAttributeValue_, OS.NSAccessibilityPositionAttribute());
            long sizeValue = OS.objc_msgSend(this.nsItem.id, OS.sel_accessibilityAttributeValue_, OS.NSAccessibilitySizeAttribute());
            NSValue val = new NSValue(posValue);
            NSPoint pt = val.pointValue();
            NSWindow window = this.parent.view.window();
            pt = window.convertScreenToBase(pt);
            pt = this.parent.view.convertPoint_fromView_(pt, null);
            val = new NSValue(sizeValue);
            NSSize size = val.sizeValue();
            result.width = (int)Math.ceil(size.width);
            result.height = (int)Math.ceil(size.height);
            result.x = (int)pt.x;
            result.y = (int)pt.y - result.height;
        }
        return result;
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public TabFolder getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    @Override
    void register() {
        super.register();
        this.display.addWidget(this.nsItem, this);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        if (this.nsItem != null) {
            this.nsItem.release();
        }
        this.nsItem = null;
        if (this.attriStr != null) {
            this.attriStr.release();
        }
        this.attriStr = null;
        this.parent = null;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        int index = this.parent.indexOf(this);
        if (index == this.parent.getSelectionIndex() && this.control != null) {
            this.control.setVisible(false);
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.control = null;
    }

    public void setControl(Control control) {
        NSView topView;
        NSView view;
        int selectionIndex;
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (this.control != null && this.control.isDisposed()) {
            this.control = null;
        }
        Control oldControl = this.control;
        Control newControl = control;
        this.control = control;
        int index = this.parent.indexOf(this);
        if (index != (selectionIndex = this.parent.getSelectionIndex())) {
            if (newControl != null) {
                Control selectedControl;
                boolean hideControl = true;
                if (selectionIndex != -1 && (selectedControl = this.parent.getItem(selectionIndex).getControl()) == newControl) {
                    hideControl = false;
                }
                if (hideControl) {
                    newControl.setVisible(false);
                }
            }
        } else {
            if (newControl != null) {
                newControl.setVisible(true);
            }
            if (oldControl != null && newControl != null && oldControl != newControl) {
                oldControl.setVisible(false);
            }
        }
        if (newControl != null) {
            view = newControl.topView();
        } else {
            view = (NSView)new NSView().alloc();
            view.init();
            view.autorelease();
        }
        this.nsItem.setView(view);
        if (oldControl != null && (topView = oldControl.topView()).superview() == null) {
            this.parent.contentView().addSubview(topView, -1L, null);
        }
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        int index = this.parent.indexOf(this);
        if (index == -1) {
            return;
        }
        super.setImage(image);
        this.nsItem.setLabel(NSString.string());
    }

    @Override
    public void setText(String string) {
        int index;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((index = this.parent.indexOf(this)) == -1) {
            return;
        }
        super.setText(string);
        this.updateText();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        this.parent.checkToolTip(this);
    }

    @Override
    NSSize sizeOfLabel(long id2, long sel, boolean shouldTruncateLabel) {
        NSSize size = super.sizeOfLabel(id2, sel, shouldTruncateLabel);
        if (this.image != null && !this.image.isDisposed()) {
            NSSize imageSize = this.image.handle.size();
            size.width += imageSize.width + 2.0;
        }
        if (this.attriStr != null) {
            NSSize textSize = this.attriStr.size();
            size.width += textSize.width;
        }
        return size;
    }

    @Override
    String tooltipText() {
        return this.toolTipText;
    }

    void updateText() {
        NSTabViewItem selected = ((NSTabView)this.parent.view).selectedTabViewItem();
        this.updateText(selected != null && selected.id == this.nsItem.id);
    }

    void updateText(boolean selected) {
        double[] foreground;
        if (this.attriStr != null) {
            this.attriStr.release();
        }
        if ((foreground = this.parent.foreground) == null) {
            foreground = selected ? (OS.isBigSurOrLater() ? this.display.selectedControlTextColor : this.display.alternateSelectedControlTextColor) : this.parent.defaultForeground().handle;
        }
        this.attriStr = this.parent.createString(this.text, null, foreground, 0, false, true, true);
        this.nsItem.setLabel(NSString.string());
    }
}

