/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.base;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.DistinctIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategyFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.BindingAssigner;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.CompareOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ConjunctiveConstraintSplitter;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ConstantOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.DisjunctiveConstraintOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.FilterOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.IterativeEvaluationOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.OrderLimitOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryJoinOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryModelNormalizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.RegexAsStringFunctionOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.SameTermFilterOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.StrictEvaluationStrategyFactory;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.UnknownSailTransactionStateException;
import org.eclipse.rdf4j.sail.UpdateContext;
import org.eclipse.rdf4j.sail.base.DelegatingSailSource;
import org.eclipse.rdf4j.sail.base.SailClosable;
import org.eclipse.rdf4j.sail.base.SailClosingIteration;
import org.eclipse.rdf4j.sail.base.SailDataset;
import org.eclipse.rdf4j.sail.base.SailDatasetTripleSource;
import org.eclipse.rdf4j.sail.base.SailSink;
import org.eclipse.rdf4j.sail.base.SailSource;
import org.eclipse.rdf4j.sail.base.SailStore;
import org.eclipse.rdf4j.sail.base.UnionSailSource;
import org.eclipse.rdf4j.sail.helpers.AbstractSail;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailConnectionBase;
import org.eclipse.rdf4j.sail.inferencer.InferencerConnection;

public abstract class SailSourceConnection
extends NotifyingSailConnectionBase
implements InferencerConnection,
FederatedServiceResolverClient {
    private final Map<UpdateContext, SailDataset> datasets = new HashMap<UpdateContext, SailDataset>();
    private final Map<UpdateContext, SailSink> explicitSinks = new HashMap<UpdateContext, SailSink>();
    private volatile SailDataset explicitOnlyDataset;
    private volatile SailDataset inferredDataset;
    private volatile SailSink inferredSink;
    private final ValueFactory vf;
    private final SailStore store;
    private final IsolationLevel defaultIsolationLevel;
    private volatile SailSource explicitOnlyBranch;
    private volatile SailSource inferredOnlyBranch;
    private volatile SailSource includeInferredBranch;
    private final EvaluationStrategyFactory evalStratFactory;
    private volatile FederatedServiceResolver federatedServiceResolver;

    protected SailSourceConnection(AbstractSail sail, SailStore store, FederatedServiceResolver resolver) {
        this(sail, store, new StrictEvaluationStrategyFactory(resolver));
    }

    protected SailSourceConnection(AbstractSail sail, SailStore store, EvaluationStrategyFactory evalStratFactory) {
        super(sail);
        this.vf = sail.getValueFactory();
        this.store = store;
        this.defaultIsolationLevel = sail.getDefaultIsolationLevel();
        this.evalStratFactory = evalStratFactory;
        this.federatedServiceResolver = evalStratFactory instanceof StrictEvaluationStrategyFactory ? ((StrictEvaluationStrategyFactory)evalStratFactory).getFederatedServiceResolver() : null;
    }

    public FederatedServiceResolver getFederatedServiceResolver() {
        return this.federatedServiceResolver;
    }

    @Override
    public void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        this.federatedServiceResolver = resolver;
    }

    protected EvaluationStrategy getEvaluationStrategy(Dataset dataset, TripleSource tripleSource) {
        EvaluationStrategy evalStrat = this.evalStratFactory.createEvaluationStrategy(dataset, tripleSource);
        if (this.federatedServiceResolver != null && evalStrat instanceof FederatedServiceResolverClient) {
            ((FederatedServiceResolverClient)((Object)evalStrat)).setFederatedServiceResolver(this.federatedServiceResolver);
        }
        return evalStrat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        this.flush();
        this.logger.trace("Incoming query model:\n{}", (Object)tupleExpr);
        tupleExpr = tupleExpr.clone();
        if (!(tupleExpr instanceof QueryRoot)) {
            tupleExpr = new QueryRoot(tupleExpr);
        }
        SailSource branch = null;
        SailDataset rdfDataset = null;
        CloseableIteration<BindingSet, QueryEvaluationException> iter1 = null;
        CloseableIteration<BindingSet, QueryEvaluationException> iter2 = null;
        boolean allGood = false;
        try {
            branch = this.branch(includeInferred);
            rdfDataset = branch.dataset(this.getIsolationLevel());
            SailDatasetTripleSource tripleSource = new SailDatasetTripleSource(this.vf, rdfDataset);
            EvaluationStrategy strategy = this.getEvaluationStrategy(dataset, tripleSource);
            new BindingAssigner().optimize(tupleExpr, dataset, bindings);
            new ConstantOptimizer(strategy).optimize(tupleExpr, dataset, bindings);
            new RegexAsStringFunctionOptimizer(this.vf).optimize(tupleExpr, dataset, bindings);
            new CompareOptimizer().optimize(tupleExpr, dataset, bindings);
            new ConjunctiveConstraintSplitter().optimize(tupleExpr, dataset, bindings);
            new DisjunctiveConstraintOptimizer().optimize(tupleExpr, dataset, bindings);
            new SameTermFilterOptimizer().optimize(tupleExpr, dataset, bindings);
            new QueryModelNormalizer().optimize(tupleExpr, dataset, bindings);
            new QueryJoinOptimizer(this.store.getEvaluationStatistics()).optimize(tupleExpr, dataset, bindings);
            new IterativeEvaluationOptimizer().optimize(tupleExpr, dataset, bindings);
            new FilterOptimizer().optimize(tupleExpr, dataset, bindings);
            new OrderLimitOptimizer().optimize(tupleExpr, dataset, bindings);
            this.logger.trace("Optimized query model:\n{}", (Object)tupleExpr);
            iter1 = strategy.evaluate(tupleExpr, EmptyBindingSet.getInstance());
            iter2 = this.interlock(iter1, rdfDataset, branch);
            allGood = true;
            CloseableIteration<BindingSet, QueryEvaluationException> closeableIteration = iter2;
            return closeableIteration;
        }
        catch (QueryEvaluationException e) {
            throw new SailException(e);
        }
        finally {
            if (!allGood) {
                try {
                    if (iter2 != null) {
                        iter2.close();
                    }
                }
                finally {
                    try {
                        if (iter1 != null) {
                            iter1.close();
                        }
                    }
                    finally {
                        try {
                            if (rdfDataset != null) {
                                rdfDataset.close();
                            }
                        }
                        finally {
                            if (branch != null) {
                                branch.close();
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void closeInternal() throws SailException {
    }

    @Override
    protected CloseableIteration<? extends Resource, SailException> getContextIDsInternal() throws SailException {
        this.flush();
        SailSource branch = this.branch(false);
        SailDataset snapshot = branch.dataset(this.getIsolationLevel());
        return SailClosingIteration.makeClosable(snapshot.getContextIDs(), snapshot, branch);
    }

    @Override
    protected CloseableIteration<? extends Statement, SailException> getStatementsInternal(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        this.flush();
        SailSource branch = this.branch(includeInferred);
        SailDataset snapshot = branch.dataset(this.getIsolationLevel());
        return SailClosingIteration.makeClosable(snapshot.getStatements(subj, pred, obj, contexts), snapshot, branch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long sizeInternal(Resource ... contexts) throws SailException {
        try (DistinctIteration<? extends Statement, SailException> iter = null;){
            this.flush();
            iter = new DistinctIteration<Statement, SailException>(this.getStatementsInternal(null, null, null, false, contexts));
            long size = 0L;
            while (iter.hasNext()) {
                iter.next();
                ++size;
            }
            long l = size;
            return l;
        }
    }

    @Override
    protected CloseableIteration<? extends Namespace, SailException> getNamespacesInternal() throws SailException {
        SailSource branch = this.branch(false);
        SailDataset snapshot = branch.dataset(this.getIsolationLevel());
        return SailClosingIteration.makeClosable(snapshot.getNamespaces(), snapshot, branch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getNamespaceInternal(String prefix) throws SailException {
        SailSource branch = null;
        SailDataset snapshot = null;
        try {
            branch = this.branch(false);
            snapshot = branch.dataset(this.getIsolationLevel());
            String string = snapshot.getNamespace(prefix);
            return string;
        }
        finally {
            try {
                if (snapshot != null) {
                    snapshot.close();
                }
            }
            finally {
                if (branch != null) {
                    branch.close();
                }
            }
        }
    }

    @Override
    protected void startTransactionInternal() throws SailException {
        assert (this.explicitOnlyBranch == null);
        assert (this.inferredOnlyBranch == null);
        assert (this.includeInferredBranch == null);
        IsolationLevel level = this.getTransactionIsolation();
        if (!IsolationLevels.NONE.isCompatibleWith(level)) {
            this.explicitOnlyBranch = this.store.getExplicitSailSource().fork();
            this.inferredOnlyBranch = this.store.getInferredSailSource().fork();
            this.includeInferredBranch = new UnionSailSource(this.inferredOnlyBranch, this.explicitOnlyBranch);
        }
    }

    @Override
    protected void prepareInternal() throws SailException {
        SailSource toCheckIncludeInferredBranch = this.includeInferredBranch;
        if (toCheckIncludeInferredBranch != null) {
            toCheckIncludeInferredBranch.prepare();
        }
    }

    @Override
    protected void commitInternal() throws SailException {
        SailSource toCloseInferredBranch = this.includeInferredBranch;
        this.explicitOnlyBranch = null;
        this.inferredOnlyBranch = null;
        this.includeInferredBranch = null;
        try {
            if (toCloseInferredBranch != null) {
                toCloseInferredBranch.flush();
            }
        }
        finally {
            if (toCloseInferredBranch != null) {
                toCloseInferredBranch.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void rollbackInternal() throws SailException {
        Map<UpdateContext, SailDataset> map = this.datasets;
        synchronized (map) {
            SailDataset toCloseDataset = null;
            SailClosable toCloseExplicitSink = null;
            SailDataset toCloseExplicitOnlyDataset = this.explicitOnlyDataset;
            this.explicitOnlyDataset = null;
            SailDataset toCloseInferredDataset = this.inferredDataset;
            this.inferredDataset = null;
            SailSink toCloseInferredSink = this.inferredSink;
            this.inferredSink = null;
            SailSource toCloseIncludeInferredBranch = this.includeInferredBranch;
            this.includeInferredBranch = null;
            this.explicitOnlyBranch = null;
            this.inferredOnlyBranch = null;
            try {
                if (this.datasets.containsKey(null)) {
                    toCloseDataset = this.datasets.remove(null);
                }
            }
            finally {
                try {
                    if (toCloseDataset != null) {
                        toCloseDataset.close();
                    }
                }
                finally {
                    try {
                        if (this.explicitSinks.containsKey(null)) {
                            toCloseExplicitSink = this.explicitSinks.remove(null);
                        }
                    }
                    finally {
                        try {
                            if (toCloseExplicitSink != null) {
                                toCloseExplicitSink.close();
                            }
                        }
                        finally {
                            try {
                                if (toCloseExplicitOnlyDataset != null) {
                                    toCloseExplicitOnlyDataset.close();
                                }
                            }
                            finally {
                                try {
                                    if (toCloseInferredDataset != null) {
                                        toCloseInferredDataset.close();
                                    }
                                }
                                finally {
                                    try {
                                        if (toCloseInferredSink != null) {
                                            toCloseInferredSink.close();
                                        }
                                    }
                                    finally {
                                        if (toCloseIncludeInferredBranch != null) {
                                            toCloseIncludeInferredBranch.close();
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startUpdate(UpdateContext op) throws SailException {
        if (op != null) {
            IsolationLevel level = this.getIsolationLevel();
            this.flush();
            Map<UpdateContext, SailDataset> map = this.datasets;
            synchronized (map) {
                SailSource source;
                assert (!this.datasets.containsKey(op));
                if (op.isIncludeInferred() && this.inferredOnlyBranch == null) {
                    SailSource explicit = this.store.getExplicitSailSource();
                    SailSource inferred = this.store.getInferredSailSource();
                    source = new UnionSailSource(explicit, inferred);
                } else {
                    source = op.isIncludeInferred() ? new UnionSailSource(this.explicitOnlyBranch, this.inferredOnlyBranch) : this.branch(false);
                }
                this.datasets.put(op, source.dataset(level));
                this.explicitSinks.put(op, source.sink(level));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStatement(UpdateContext op, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.verifyIsOpen();
        this.verifyIsActive();
        Map<UpdateContext, SailDataset> map = this.datasets;
        synchronized (map) {
            if (op == null && !this.datasets.containsKey(null)) {
                SailSource source = this.branch(false);
                this.datasets.put(null, source.dataset(this.getIsolationLevel()));
                this.explicitSinks.put(null, source.sink(this.getIsolationLevel()));
            }
            assert (this.explicitSinks.containsKey(op));
            this.add(subj, pred, obj, this.datasets.get(op), this.explicitSinks.get(op), contexts);
        }
        this.addStatementInternal(subj, pred, obj, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStatement(UpdateContext op, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.verifyIsOpen();
        this.verifyIsActive();
        Map<UpdateContext, SailDataset> map = this.datasets;
        synchronized (map) {
            if (op == null && !this.datasets.containsKey(null)) {
                SailSource source = this.branch(false);
                this.datasets.put(null, source.dataset(this.getIsolationLevel()));
                this.explicitSinks.put(null, source.sink(this.getIsolationLevel()));
            }
            assert (this.explicitSinks.containsKey(op));
            this.remove(subj, pred, obj, this.datasets.get(op), this.explicitSinks.get(op), contexts);
        }
        this.removeStatementsInternal(subj, pred, obj, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void endUpdateInternal(UpdateContext op) throws SailException {
        Map<UpdateContext, SailDataset> map = this.datasets;
        synchronized (map) {
            SailSink toCloseInferredSink = this.inferredSink;
            this.inferredSink = null;
            SailDataset toCloseExplicitOnlyDataset = this.explicitOnlyDataset;
            this.explicitOnlyDataset = null;
            SailDataset toCloseInferredDataset = this.inferredDataset;
            this.inferredDataset = null;
            try {
                if (toCloseInferredSink != null) {
                    toCloseInferredSink.flush();
                }
            }
            finally {
                try {
                    if (toCloseInferredSink != null) {
                        toCloseInferredSink.close();
                    }
                }
                finally {
                    try {
                        if (toCloseExplicitOnlyDataset != null) {
                            toCloseExplicitOnlyDataset.close();
                        }
                    }
                    finally {
                        try {
                            if (toCloseInferredDataset != null) {
                                toCloseInferredDataset.close();
                            }
                        }
                        finally {
                            SailSink explicit = null;
                            try {
                                explicit = this.explicitSinks.remove(op);
                                if (explicit != null) {
                                    explicit.flush();
                                }
                            }
                            finally {
                                try {
                                    if (explicit != null) {
                                        explicit.close();
                                    }
                                }
                                finally {
                                    try (SailDataset toCloseDataset = null;){
                                        toCloseDataset = this.datasets.remove(op);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addInferredStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.verifyIsOpen();
        this.verifyIsActive();
        IsolationLevel level = this.getIsolationLevel();
        Map<UpdateContext, SailDataset> map = this.datasets;
        synchronized (map) {
            if (this.inferredSink == null) {
                SailSource branch = this.branch(true);
                this.inferredDataset = branch.dataset(level);
                this.inferredSink = branch.sink(level);
                this.explicitOnlyDataset = this.branch(false).dataset(level);
            }
            boolean modified = false;
            if (contexts.length == 0) {
                if (!this.hasStatement(this.explicitOnlyDataset, subj, pred, obj, new Resource[0])) {
                    if (!this.hasStatement(this.inferredDataset, subj, pred, obj, new Resource[0])) {
                        this.addStatementInternal(subj, pred, obj, contexts);
                        this.notifyStatementAdded(this.vf.createStatement(subj, pred, obj));
                        modified = true;
                    }
                    this.inferredSink.approve(subj, pred, obj, null);
                }
            } else {
                for (Resource ctx : contexts) {
                    if (this.hasStatement(this.explicitOnlyDataset, subj, pred, obj, ctx)) continue;
                    if (!this.hasStatement(this.inferredDataset, subj, pred, obj, ctx)) {
                        this.addStatementInternal(subj, pred, obj, ctx);
                        this.notifyStatementAdded(this.vf.createStatement(subj, pred, obj, ctx));
                        modified = true;
                    }
                    this.inferredSink.approve(subj, pred, obj, ctx);
                }
            }
            return modified;
        }
    }

    private void add(Resource subj, IRI pred, Value obj, SailDataset dataset, SailSink sink, Resource ... contexts) throws SailException {
        if (contexts.length == 0) {
            if (this.hasConnectionListeners() && !this.hasStatement(dataset, subj, pred, obj, new Resource[0])) {
                this.notifyStatementAdded(this.vf.createStatement(subj, pred, obj));
            }
            sink.approve(subj, pred, obj, null);
        } else {
            for (Resource ctx : contexts) {
                if (this.hasConnectionListeners() && !this.hasStatement(dataset, subj, pred, obj, ctx)) {
                    this.notifyStatementAdded(this.vf.createStatement(subj, pred, obj, ctx));
                }
                sink.approve(subj, pred, obj, ctx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeInferredStatement(Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        this.verifyIsOpen();
        this.verifyIsActive();
        Map<UpdateContext, SailDataset> map = this.datasets;
        synchronized (map) {
            IsolationLevel level = this.getIsolationLevel();
            if (this.inferredSink == null) {
                SailSource branch = this.branch(true);
                this.inferredDataset = branch.dataset(level);
                this.inferredSink = branch.sink(level);
                this.explicitOnlyDataset = this.branch(false).dataset(level);
            }
            this.removeStatementsInternal(subj, pred, obj, contexts);
            return this.remove(subj, pred, obj, this.inferredDataset, this.inferredSink, contexts);
        }
    }

    private boolean remove(Resource subj, IRI pred, Value obj, SailDataset dataset, SailSink sink, Resource ... contexts) throws SailException {
        boolean statementsRemoved = false;
        try (CloseableIteration<? extends Statement, SailException> iter = dataset.getStatements(subj, pred, obj, contexts);){
            while (iter.hasNext()) {
                Statement st = (Statement)iter.next();
                sink.deprecate(st.getSubject(), st.getPredicate(), st.getObject(), st.getContext());
                statementsRemoved = true;
                this.notifyStatementRemoved(st);
            }
        }
        return statementsRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clearInternal(Resource ... contexts) throws SailException {
        this.verifyIsOpen();
        this.verifyIsActive();
        Map<UpdateContext, SailDataset> map = this.datasets;
        synchronized (map) {
            if (!this.datasets.containsKey(null)) {
                SailSource source = this.branch(false);
                this.datasets.put(null, source.dataset(this.getIsolationLevel()));
                this.explicitSinks.put(null, source.sink(this.getIsolationLevel()));
            }
            assert (this.explicitSinks.containsKey(null));
            if (this.hasConnectionListeners()) {
                this.remove(null, null, null, this.datasets.get(null), this.explicitSinks.get(null), contexts);
            }
            this.explicitSinks.get(null).clear(contexts);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearInferred(Resource ... contexts) throws SailException {
        this.verifyIsOpen();
        this.verifyIsActive();
        Map<UpdateContext, SailDataset> map = this.datasets;
        synchronized (map) {
            if (this.inferredSink == null) {
                IsolationLevel level = this.getIsolationLevel();
                SailSource branch = this.branch(true);
                this.inferredDataset = branch.dataset(level);
                this.inferredSink = branch.sink(level);
                this.explicitOnlyDataset = this.branch(false).dataset(level);
            }
            if (this.hasConnectionListeners()) {
                this.remove(null, null, null, this.inferredDataset, this.inferredSink, contexts);
            }
            this.inferredSink.clear(contexts);
        }
    }

    @Override
    public void flushUpdates() throws SailException {
        this.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setNamespaceInternal(String prefix, String name) throws SailException {
        SailSource branch = null;
        SailClosable sink = null;
        try {
            branch = this.branch(false);
            sink = branch.sink(this.getTransactionIsolation());
            sink.setNamespace(prefix, name);
            sink.flush();
        }
        finally {
            try {
                if (sink != null) {
                    sink.close();
                }
            }
            finally {
                if (branch != null) {
                    branch.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeNamespaceInternal(String prefix) throws SailException {
        SailSource branch = null;
        SailClosable sink = null;
        try {
            branch = this.branch(false);
            sink = branch.sink(this.getTransactionIsolation());
            sink.removeNamespace(prefix);
            sink.flush();
        }
        finally {
            try {
                if (sink != null) {
                    sink.close();
                }
            }
            finally {
                if (branch != null) {
                    branch.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clearNamespacesInternal() throws SailException {
        SailSource branch = null;
        SailClosable sink = null;
        try {
            branch = this.branch(false);
            sink = branch.sink(this.getTransactionIsolation());
            sink.clearNamespaces();
            sink.flush();
        }
        finally {
            try {
                if (sink != null) {
                    sink.close();
                }
            }
            finally {
                if (branch != null) {
                    branch.close();
                }
            }
        }
    }

    private IsolationLevel getIsolationLevel() throws UnknownSailTransactionStateException {
        if (this.isActive()) {
            return super.getTransactionIsolation();
        }
        return this.defaultIsolationLevel;
    }

    private SailSource branch(boolean includeinferred) throws SailException {
        boolean isolated;
        boolean active = this.isActive();
        IsolationLevel level = this.getIsolationLevel();
        boolean bl = isolated = !IsolationLevels.NONE.isCompatibleWith(level);
        if (includeinferred && active && isolated) {
            return new DelegatingSailSource(this.includeInferredBranch, false);
        }
        if (active && isolated) {
            return new DelegatingSailSource(this.explicitOnlyBranch, false);
        }
        if (includeinferred && active) {
            return new UnionSailSource(this.store.getInferredSailSource(), this.store.getExplicitSailSource());
        }
        if (active) {
            return this.store.getExplicitSailSource();
        }
        if (includeinferred) {
            return new UnionSailSource(this.store.getInferredSailSource().fork(), this.store.getExplicitSailSource().fork());
        }
        return this.store.getExplicitSailSource().fork();
    }

    private <T, X extends Exception> CloseableIteration<T, QueryEvaluationException> interlock(CloseableIteration<T, QueryEvaluationException> iter, SailClosable ... closes) {
        return new SailClosingIteration<T, QueryEvaluationException>(iter, closes){

            @Override
            protected void handleSailException(SailException e) throws QueryEvaluationException {
                throw new QueryEvaluationException(e);
            }
        };
    }

    private boolean hasStatement(SailDataset dataset, Resource subj, IRI pred, Value obj, Resource ... contexts) throws SailException {
        try (CloseableIteration<? extends Statement, SailException> iter = dataset.getStatements(subj, pred, obj, contexts);){
            boolean bl = iter.hasNext();
            return bl;
        }
    }
}

