/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.targets;

import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.DASH;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ExternalFilterIsObject;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnBufferedPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnorderedSelect;
import org.eclipse.rdf4j.sail.shacl.ast.targets.Target;

public class DashAllObjects
extends Target {
    private final Resource id;

    public DashAllObjects(Resource id) {
        this.id = id;
    }

    @Override
    public IRI getPredicate() {
        return DASH.AllObjectsTarget;
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> exported) {
        model.add(subject, SHACL.TARGET_PROP, (Value)this.id, new Resource[0]);
        model.add(this.id, RDF.TYPE, (Value)this.getPredicate(), new Resource[0]);
    }

    @Override
    public PlanNode getAdded(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope) {
        return this.getAddedRemovedInner(connectionsGroup, scope, connectionsGroup.getAddedStatements());
    }

    private PlanNode getAddedRemovedInner(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope, SailConnection connection) {
        return new Unique(new UnorderedSelect(connection, null, null, null, UnorderedSelect.Mapper.ObjectScopedMapper.getFunction(scope)));
    }

    @Override
    public String getQueryFragment(String subjectVariable, String objectVariable, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
        String tempVar = "?" + UUID.randomUUID().toString().replace("-", "");
        throw new UnsupportedOperationException("Not sure what calls this code!");
    }

    @Override
    public PlanNode getTargetFilter(ConnectionsGroup connectionsGroup, PlanNode parent) {
        return new ExternalFilterIsObject(connectionsGroup.getBaseConnection(), parent).getFalseNode(UnBufferedPlanNode.class);
    }

    @Override
    public Stream<StatementMatcher> getStatementMatcher(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
        assert (subject == null);
        return Stream.of(new StatementMatcher(null, null, object));
    }

    @Override
    public String getTargetQueryFragment(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
        assert (subject == null);
        String tempVar1 = "?" + UUID.randomUUID().toString().replace("-", "");
        String tempVar2 = "?" + UUID.randomUUID().toString().replace("-", "");
        return tempVar1 + " " + tempVar2 + " ?" + object.getName() + " .";
    }
}

