/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.util;

import com.google.common.base.Charsets;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.DynamicModel;
import org.eclipse.rdf4j.model.impl.DynamicModelFactory;
import org.eclipse.rdf4j.model.util.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GraphComparisons {
    private static final Logger logger = LoggerFactory.getLogger(GraphComparisons.class);
    private static final HashFunction hashFunction = Hashing.murmur3_128();
    private static final HashCode initialHashCode = hashFunction.hashString((CharSequence)"", Charsets.UTF_8);
    private static final HashCode outgoing = hashFunction.hashString((CharSequence)"+", Charsets.UTF_8);
    private static final HashCode incoming = hashFunction.hashString((CharSequence)"-", Charsets.UTF_8);
    private static final HashCode distinguisher = hashFunction.hashString((CharSequence)"@", Charsets.UTF_8);

    GraphComparisons() {
    }

    public static boolean isomorphic(Model model1, Model model2) {
        if (model1 == model2) {
            return true;
        }
        if (model1.size() != model2.size()) {
            return false;
        }
        if (model1.contexts().size() != model2.contexts().size()) {
            return false;
        }
        if (model1.contexts().size() > 1) {
            for (Resource context : model1.contexts()) {
                Model canonicalizedContext2;
                Model contextInModel1 = model1.filter(null, null, null, new Resource[]{context});
                if (context != null && context.isBNode()) {
                    Map<BNode, HashCode> mapping1 = GraphComparisons.getIsoCanonicalMapping(model1);
                    Multimap<HashCode, BNode> partitionMapping2 = GraphComparisons.partitionMapping(GraphComparisons.getIsoCanonicalMapping(model2));
                    Collection contextCandidates = partitionMapping2.get((Object)mapping1.get(context));
                    if (contextCandidates.isEmpty()) {
                        return false;
                    }
                    boolean foundIsomorphicBlankNodeContext = false;
                    for (BNode context2 : contextCandidates) {
                        Model contextInModel2 = model2.filter(null, null, null, new Resource[]{context2});
                        if (contextInModel1.size() != contextInModel2.size() || !GraphComparisons.isomorphicSingleContext(contextInModel1, contextInModel2)) continue;
                        foundIsomorphicBlankNodeContext = true;
                        break;
                    }
                    if (foundIsomorphicBlankNodeContext) continue;
                    return false;
                }
                Model contextInModel2 = model2.filter(null, null, null, new Resource[]{context});
                if (contextInModel1.size() != contextInModel2.size()) {
                    return false;
                }
                Model canonicalizedContext1 = GraphComparisons.isoCanonicalize(contextInModel1);
                if (canonicalizedContext1.equals(canonicalizedContext2 = GraphComparisons.isoCanonicalize(contextInModel2))) continue;
                return false;
            }
            return true;
        }
        return GraphComparisons.isomorphicSingleContext(model1, model2);
    }

    private static boolean isomorphicSingleContext(Model model1, Model model2) {
        Map<BNode, HashCode> mapping1 = GraphComparisons.getIsoCanonicalMapping(model1);
        if (mapping1.isEmpty()) {
            return model1.equals(model2);
        }
        Map<BNode, HashCode> mapping2 = GraphComparisons.getIsoCanonicalMapping(model2);
        if (GraphComparisons.mappingsIncompatible(mapping1, mapping2)) {
            return false;
        }
        Optional<Statement> missingInModel2 = model1.stream().filter(st -> !st.getSubject().isBNode() && !st.getObject().isBNode() && !(st.getContext() instanceof BNode)).filter(st -> !model2.contains(st)).findAny();
        return !missingInModel2.isPresent();
    }

    private static boolean mappingsIncompatible(Map<BNode, HashCode> mapping1, Map<BNode, HashCode> mapping2) {
        HashSet<HashCode> values2;
        if (mapping1.size() != mapping2.size()) {
            return true;
        }
        HashSet<HashCode> values1 = new HashSet<HashCode>(mapping1.values());
        return !values1.equals(values2 = new HashSet<HashCode>(mapping2.values()));
    }

    protected static Model isoCanonicalize(Model m) {
        return GraphComparisons.labelModel(m, GraphComparisons.getIsoCanonicalMapping(m));
    }

    protected static Map<BNode, HashCode> getIsoCanonicalMapping(Model m) {
        Partitioning partitioning = GraphComparisons.hashBNodes(m);
        if (partitioning.isFine()) {
            return partitioning.getCurrentNodeMapping();
        }
        return GraphComparisons.distinguish(m, partitioning, null, new ArrayList<BNode>(), new ArrayList<Map<BNode, HashCode>>());
    }

    protected static Set<BNode> getBlankNodes(Model m) {
        HashSet<BNode> blankNodes = new HashSet<BNode>();
        m.forEach(st -> {
            if (st.getSubject().isBNode()) {
                blankNodes.add((BNode)st.getSubject());
            }
            if (st.getObject().isBNode()) {
                blankNodes.add((BNode)st.getObject());
            }
            if (st.getContext() != null && st.getContext().isBNode()) {
                blankNodes.add((BNode)st.getContext());
            }
        });
        return blankNodes;
    }

    private static Map<BNode, HashCode> distinguish(Model m, Partitioning partitioning, Map<BNode, HashCode> lowestFound, List<BNode> parentFixpoints, List<Map<BNode, HashCode>> finePartitionMappings) {
        for (BNode node : partitioning.getLowestNonTrivialPartition()) {
            ArrayList<BNode> fixpoints = new ArrayList<BNode>(parentFixpoints);
            fixpoints.add(node);
            Partitioning clonedPartitioning = new Partitioning(partitioning.getCurrentNodeMapping(), partitioning.getStaticValueMapping());
            clonedPartitioning.setCurrentHashCode(node, GraphComparisons.hashTuple(clonedPartitioning.getCurrentHashCode((Value)node), distinguisher));
            clonedPartitioning = GraphComparisons.hashBNodes(m, clonedPartitioning);
            if (clonedPartitioning.isFine()) {
                finePartitionMappings.add(clonedPartitioning.getCurrentNodeMapping());
                if (lowestFound != null && clonedPartitioning.getMappingSize().compareTo(partitioning.getMappingSize()) >= 0) continue;
                lowestFound = clonedPartitioning.getCurrentNodeMapping();
                continue;
            }
            Map<BNode, BNode> compatibleAutomorphism = GraphComparisons.findCompatibleAutomorphism(fixpoints, finePartitionMappings);
            if (compatibleAutomorphism != null) continue;
            lowestFound = GraphComparisons.distinguish(m, clonedPartitioning, lowestFound, fixpoints, finePartitionMappings);
        }
        return lowestFound;
    }

    protected static Map<BNode, BNode> findCompatibleAutomorphism(List<BNode> fixpoints, List<Map<BNode, HashCode>> partitionMappings) {
        for (Map<BNode, HashCode> mapping : partitionMappings) {
            BNode fixpoint;
            Map<BNode, HashCode> compatibleMapping = null;
            for (Map<BNode, HashCode> om : partitionMappings) {
                if (om.equals(mapping) || !om.values().containsAll(mapping.values())) continue;
                compatibleMapping = om;
                break;
            }
            if (compatibleMapping == null) continue;
            Map<HashCode, BNode> invertedMapping = mapping.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
            HashMap<BNode, BNode> automorphism = new HashMap<BNode, BNode>();
            for (Map.Entry<BNode, HashCode> entry : compatibleMapping.entrySet()) {
                automorphism.put(entry.getKey(), invertedMapping.get(entry.getValue()));
            }
            Iterator<Map.Entry<BNode, HashCode>> iterator = fixpoints.iterator();
            if (!iterator.hasNext() || !((BNode)automorphism.get(fixpoint = (BNode)iterator.next())).equals((Object)fixpoint)) continue;
            return automorphism;
        }
        return null;
    }

    protected static List<Collection<BNode>> partitions(Multimap<HashCode, BNode> partitionMapping) {
        ArrayList<Collection<BNode>> partition = new ArrayList<Collection<BNode>>();
        for (Map.Entry entry : partitionMapping.asMap().entrySet()) {
            partition.add((Collection<BNode>)entry.getValue());
        }
        return partition;
    }

    protected static Multimap<HashCode, BNode> partitionMapping(Map<BNode, HashCode> blankNodeMapping) {
        return Multimaps.invertFrom((Multimap)Multimaps.forMap(blankNodeMapping), (Multimap)MultimapBuilder.hashKeys((int)blankNodeMapping.keySet().size()).arrayListValues().build());
    }

    private static Model labelModel(Model original, Map<BNode, HashCode> hash) {
        DynamicModel result = new DynamicModelFactory().createEmptyModel();
        for (Statement st : original) {
            if (st.getSubject().isBNode() || st.getObject().isBNode() || st.getContext() != null && st.getContext().isBNode()) {
                Resource subject = st.getSubject().isBNode() ? GraphComparisons.createCanonicalBNode((BNode)st.getSubject(), hash) : st.getSubject();
                IRI predicate = st.getPredicate();
                Value object = st.getObject().isBNode() ? GraphComparisons.createCanonicalBNode((BNode)st.getObject(), hash) : st.getObject();
                Resource context = st.getContext() != null && st.getContext().isBNode() ? GraphComparisons.createCanonicalBNode((BNode)st.getContext(), hash) : st.getContext();
                result.add(subject, predicate, object, new Resource[]{context});
                continue;
            }
            result.add(st);
        }
        return result;
    }

    protected static Partitioning hashBNodes(Model m) {
        return GraphComparisons.hashBNodes(m, null);
    }

    private static Partitioning hashBNodes(Model m, Partitioning partitioning) {
        if (partitioning == null) {
            Set<BNode> blankNodes = GraphComparisons.getBlankNodes(m);
            partitioning = new Partitioning(blankNodes);
        }
        if (!partitioning.getNodes().isEmpty()) {
            do {
                partitioning.nextIteration();
                for (BNode b : partitioning.getNodes()) {
                    HashCode c;
                    for (Statement st : m.getStatements((Resource)b, null, null, new Resource[0])) {
                        c = GraphComparisons.hashTuple(partitioning.getPreviousHashCode(st.getObject()), partitioning.getPreviousHashCode((Value)st.getPredicate()), outgoing);
                        partitioning.setCurrentHashCode(b, GraphComparisons.hashBag(c, partitioning.getCurrentHashCode((Value)b)));
                    }
                    for (Statement st : m.getStatements(null, null, (Value)b, new Resource[0])) {
                        c = GraphComparisons.hashTuple(partitioning.getPreviousHashCode((Value)st.getSubject()), partitioning.getPreviousHashCode((Value)st.getPredicate()), incoming);
                        partitioning.setCurrentHashCode(b, GraphComparisons.hashBag(c, partitioning.getCurrentHashCode((Value)b)));
                    }
                }
            } while (!partitioning.isFullyDistinguished());
        }
        return partitioning;
    }

    protected static HashCode hashTuple(HashCode ... hashCodes) {
        return Hashing.combineOrdered(Arrays.asList(hashCodes));
    }

    protected static HashCode hashBag(HashCode ... hashCodes) {
        return Hashing.combineUnordered(Arrays.asList(hashCodes));
    }

    private static BNode createCanonicalBNode(BNode node, Map<BNode, HashCode> mapping) {
        return Values.bnode("iso-" + mapping.get(node).toString());
    }

    static class Partitioning {
        private final Map<Value, HashCode> staticValueMapping;
        private Map<BNode, HashCode> previousNodeMapping;
        private Map<BNode, HashCode> currentNodeMapping;
        private Multimap<HashCode, BNode> currentHashCodeMapping;
        private final int nodeCount;

        public Partitioning(Set<BNode> blankNodes) {
            this.staticValueMapping = new HashMap<Value, HashCode>();
            this.nodeCount = blankNodes.size();
            this.currentNodeMapping = new HashMap<BNode, HashCode>(this.nodeCount);
            blankNodes.forEach(node -> this.currentNodeMapping.put((BNode)node, initialHashCode));
        }

        public Partitioning(Map<BNode, HashCode> nodeMapping, Map<Value, HashCode> staticValueMapping) {
            this.staticValueMapping = staticValueMapping;
            this.nodeCount = nodeMapping.keySet().size();
            this.currentNodeMapping = new HashMap<BNode, HashCode>(nodeMapping);
        }

        public Map<Value, HashCode> getStaticValueMapping() {
            return this.staticValueMapping;
        }

        public HashCode getCurrentHashCode(Value value) {
            if (value.isBNode()) {
                return this.currentNodeMapping.get((BNode)value);
            }
            return this.staticValueMapping.computeIfAbsent(value, v -> hashFunction.hashString((CharSequence)v.stringValue(), Charsets.UTF_8));
        }

        public Set<BNode> getNodes() {
            return this.currentNodeMapping.keySet();
        }

        public HashCode getPreviousHashCode(Value value) {
            if (value.isBNode()) {
                return this.previousNodeMapping.get((BNode)value);
            }
            return this.staticValueMapping.computeIfAbsent(value, v -> hashFunction.hashString((CharSequence)v.stringValue(), Charsets.UTF_8));
        }

        public void setCurrentHashCode(BNode bnode, HashCode hashCode) {
            this.currentNodeMapping.put(bnode, hashCode);
        }

        public Map<BNode, HashCode> getCurrentNodeMapping() {
            return Collections.unmodifiableMap(this.currentNodeMapping);
        }

        public void nextIteration() {
            this.previousNodeMapping = this.currentNodeMapping;
            this.currentNodeMapping = new HashMap<BNode, HashCode>(this.currentNodeMapping);
            this.currentHashCodeMapping = null;
        }

        public boolean isFine() {
            return this.getCurrentHashCodeMapping().asMap().values().stream().allMatch(member -> member.size() == 1);
        }

        public boolean isFullyDistinguished() {
            if (this.isFine()) {
                return true;
            }
            return this.currentUnchanged();
        }

        public Collection<BNode> getLowestNonTrivialPartition() {
            ArrayList sortedPartitions = new ArrayList(this.getCurrentHashCodeMapping().asMap().values());
            Collections.sort(sortedPartitions, new Comparator<Collection<BNode>>(){

                @Override
                public int compare(Collection<BNode> a, Collection<BNode> b) {
                    int result = a.size() - b.size();
                    if (result == 0) {
                        HashCode hashOfA = (HashCode)currentNodeMapping.get(a.iterator().next());
                        HashCode hashOfB = (HashCode)currentNodeMapping.get(b.iterator().next());
                        BigInteger difference = new BigInteger(1, hashOfA.asBytes()).subtract(new BigInteger(1, hashOfB.asBytes()));
                        result = difference.compareTo(BigInteger.ZERO);
                    }
                    return result;
                }
            });
            Collection lowestNonTrivialPartition = sortedPartitions.stream().filter(part -> part.size() > 1).findFirst().orElseThrow(RuntimeException::new);
            return lowestNonTrivialPartition;
        }

        public BigInteger getMappingSize() {
            BigInteger size = this.currentNodeMapping.values().stream().map(h -> new BigInteger(1, h.asBytes())).reduce(BigInteger.ZERO, (v1, v2) -> v1.add((BigInteger)v2));
            return size;
        }

        private Multimap<HashCode, BNode> getCurrentHashCodeMapping() {
            if (this.currentHashCodeMapping == null) {
                this.currentHashCodeMapping = Multimaps.invertFrom((Multimap)Multimaps.forMap(this.currentNodeMapping), (Multimap)HashMultimap.create());
            }
            return this.currentHashCodeMapping;
        }

        private boolean currentUnchanged() {
            Multimap previous = Multimaps.invertFrom((Multimap)Multimaps.forMap(this.previousNodeMapping), (Multimap)HashMultimap.create());
            for (Collection currentSharedHashNodes : this.getCurrentHashCodeMapping().asMap().values()) {
                BNode node = (BNode)currentSharedHashNodes.iterator().next();
                HashCode previousHashCode = this.previousNodeMapping.get(node);
                if (previous.get((Object)previousHashCode).equals(currentSharedHashNodes)) continue;
                return false;
            }
            return true;
        }
    }
}

