/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Objects;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class LiteralComparatorFilter
extends FilterPlanNode {
    private final Literal compareTo;
    private final Compare.CompareOp compareOp;

    public LiteralComparatorFilter(PlanNode parent, Literal compareTo, Compare.CompareOp compareOp) {
        super(parent);
        this.compareTo = compareTo;
        this.compareOp = compareOp;
    }

    @Override
    boolean checkTuple(ValidationTuple t) {
        Value literal = t.getValue();
        try {
            return QueryEvaluationUtil.compare((Value)this.compareTo, (Value)literal, (Compare.CompareOp)this.compareOp);
        }
        catch (ValueExprEvaluationException e) {
            return false;
        }
    }

    @Override
    public String toString() {
        return "LiteralComparatorFilter{compareTo=" + this.compareTo + ", compareOp=" + this.compareOp + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LiteralComparatorFilter that = (LiteralComparatorFilter)o;
        return this.compareTo.equals((Object)that.compareTo) && this.compareOp == that.compareOp;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.compareTo, this.compareOp);
    }
}

