/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.text;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import org.eclipse.rdf4j.common.text.ASCIIUtil;

public class StringUtil {
    private static final char[] IRI_DONT_ESCAPE = new char[]{'_', '~', '.', '-', '!', '$', '&', '\'', '(', ')', '*', '+', ',', ';', '=', ':', '/', '?', '#', '@', '%', '[', ']'};

    @Deprecated
    public static String gsub(String olds, String news, String text) {
        if (olds == null || olds.length() == 0) {
            return text;
        }
        if (text == null) {
            return null;
        }
        int oldsIndex = text.indexOf(olds);
        if (oldsIndex == -1) {
            return text;
        }
        StringBuilder buf = new StringBuilder(text.length());
        int prevIndex = 0;
        while (oldsIndex >= 0) {
            buf.append(text.substring(prevIndex, oldsIndex));
            buf.append(news);
            prevIndex = oldsIndex + olds.length();
            oldsIndex = text.indexOf(olds, prevIndex);
        }
        buf.append(text.substring(prevIndex));
        return buf.toString();
    }

    private static String hex(int c) {
        return Integer.toHexString(c).toUpperCase(Locale.US);
    }

    public static void simpleEscapeIRI(String str, Appendable appendable, boolean escapeUnicode) throws IOException {
        int strlen = str.length();
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (ASCIIUtil.isLetterOrNumber(c)) {
                appendable.append(c);
                continue;
            }
            if (c < '\u00a0') {
                if (Arrays.binarySearch(IRI_DONT_ESCAPE, c) > -1) {
                    appendable.append(c);
                    continue;
                }
                appendable.append('%').append(StringUtil.hex(c));
                continue;
            }
            if (escapeUnicode) {
                if (c <= '\u00ff') {
                    appendable.append("\\u00").append(StringUtil.hex(c));
                    continue;
                }
                if (c <= '\u0fff') {
                    appendable.append("\\u0").append(StringUtil.hex(c));
                    continue;
                }
                if (Character.isSurrogate(c) && i < strlen - 1) {
                    int code = str.codePointAt(i);
                    ++i;
                    appendable.append("\\U000").append(StringUtil.hex(code));
                    continue;
                }
                appendable.append("\\u").append(StringUtil.hex(c));
                continue;
            }
            appendable.append(c);
        }
    }

    public static void appendN(char c, int n, StringBuilder sb) {
        for (int i = n; i > 0; --i) {
            sb.append(c);
        }
    }

    public static String trimDoubleQuotes(String text) {
        int textLength = text.length();
        if (textLength >= 2 && text.charAt(0) == '\"' && text.charAt(textLength - 1) == '\"') {
            return text.substring(1, textLength - 1);
        }
        return text;
    }

    static {
        Arrays.sort(IRI_DONT_ESCAPE);
    }
}

