/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.event.base;

import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.base.RepositoryConnectionWrapper;
import org.eclipse.rdf4j.repository.event.InterceptingRepositoryConnection;
import org.eclipse.rdf4j.repository.event.RepositoryConnectionInterceptor;

public class InterceptingRepositoryConnectionWrapper
extends RepositoryConnectionWrapper
implements InterceptingRepositoryConnection {
    private boolean activated;
    private Set<RepositoryConnectionInterceptor> interceptors = new CopyOnWriteArraySet<RepositoryConnectionInterceptor>();

    public InterceptingRepositoryConnectionWrapper(Repository repository, RepositoryConnection connection) {
        super(repository, connection);
    }

    @Override
    public void addRepositoryConnectionInterceptor(RepositoryConnectionInterceptor interceptor) {
        this.interceptors.add(interceptor);
        this.activated = true;
    }

    @Override
    public void removeRepositoryConnectionInterceptor(RepositoryConnectionInterceptor interceptor) {
        this.interceptors.remove(interceptor);
        this.activated = !this.interceptors.isEmpty();
    }

    @Override
    protected boolean isDelegatingAdd() {
        return !this.activated;
    }

    @Override
    protected boolean isDelegatingRemove() {
        return !this.activated;
    }

    @Override
    public void addWithoutCommit(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> iterator = this.interceptors.iterator();
            while (iterator.hasNext() && !(denied = (interceptor = iterator.next()).add(this.getDelegate(), subject, predicate, object, contexts))) {
            }
        }
        if (!denied) {
            this.getDelegate().add(subject, predicate, object, contexts);
        }
    }

    @Override
    public void clear(Resource ... contexts) throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> iterator = this.interceptors.iterator();
            while (iterator.hasNext() && !(denied = (interceptor = iterator.next()).clear(this.getDelegate(), contexts))) {
            }
        }
        if (!denied) {
            this.getDelegate().clear(contexts);
        }
    }

    @Override
    public void begin() throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> iterator = this.interceptors.iterator();
            while (iterator.hasNext() && !(denied = (interceptor = iterator.next()).begin(this.getDelegate()))) {
            }
        }
        if (!denied) {
            super.begin();
        }
    }

    @Override
    public void close() throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> iterator = this.interceptors.iterator();
            while (iterator.hasNext() && !(denied = (interceptor = iterator.next()).close(this.getDelegate()))) {
            }
        }
        if (!denied) {
            super.close();
        }
    }

    @Override
    public void commit() throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> iterator = this.interceptors.iterator();
            while (iterator.hasNext() && !(denied = (interceptor = iterator.next()).commit(this.getDelegate()))) {
            }
        }
        if (!denied) {
            this.getDelegate().commit();
        }
    }

    @Override
    public void removeWithoutCommit(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> iterator = this.interceptors.iterator();
            while (iterator.hasNext() && !(denied = (interceptor = iterator.next()).remove(this.getDelegate(), subject, predicate, object, contexts))) {
            }
        }
        if (!denied) {
            this.getDelegate().remove(subject, predicate, object, contexts);
        }
    }

    @Override
    public void removeNamespace(String prefix) throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> iterator = this.interceptors.iterator();
            while (iterator.hasNext() && !(denied = (interceptor = iterator.next()).removeNamespace(this.getDelegate(), prefix))) {
            }
        }
        if (!denied) {
            this.getDelegate().removeNamespace(prefix);
        }
    }

    @Override
    public void clearNamespaces() throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> iterator = this.interceptors.iterator();
            while (iterator.hasNext() && !(denied = (interceptor = iterator.next()).clearNamespaces(this.getDelegate()))) {
            }
        }
        if (!denied) {
            this.getDelegate().clearNamespaces();
        }
    }

    @Override
    public void rollback() throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> iterator = this.interceptors.iterator();
            while (iterator.hasNext() && !(denied = (interceptor = iterator.next()).rollback(this.getDelegate()))) {
            }
        }
        if (!denied) {
            this.getDelegate().rollback();
        }
    }

    @Override
    @Deprecated
    public void setAutoCommit(boolean autoCommit) throws RepositoryException {
        boolean denied = false;
        boolean wasAutoCommit = this.isAutoCommit();
        if (this.activated && wasAutoCommit != autoCommit) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> iterator = this.interceptors.iterator();
            while (iterator.hasNext() && !(denied = (interceptor = iterator.next()).setAutoCommit(this.getDelegate(), autoCommit))) {
            }
        }
        if (!denied) {
            this.getDelegate().setAutoCommit(autoCommit);
        }
    }

    @Override
    public void setNamespace(String prefix, String name) throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryConnectionInterceptor interceptor;
            Iterator<RepositoryConnectionInterceptor> iterator = this.interceptors.iterator();
            while (iterator.hasNext() && !(denied = (interceptor = iterator.next()).setNamespace(this.getDelegate(), prefix, name))) {
            }
        }
        if (!denied) {
            this.getDelegate().setNamespace(prefix, name);
        }
    }

    @Override
    public Update prepareUpdate(final QueryLanguage ql, final String update, final String baseURI) throws MalformedQueryException, RepositoryException {
        if (this.activated) {
            return new Update(){
                private final RepositoryConnection conn;
                private final Update delegate;
                {
                    this.conn = InterceptingRepositoryConnectionWrapper.this.getDelegate();
                    this.delegate = this.conn.prepareUpdate(ql, update, baseURI);
                }

                @Override
                public void execute() throws UpdateExecutionException {
                    boolean denied = false;
                    if (InterceptingRepositoryConnectionWrapper.this.activated) {
                        RepositoryConnectionInterceptor interceptor;
                        Iterator<RepositoryConnectionInterceptor> iterator = InterceptingRepositoryConnectionWrapper.this.interceptors.iterator();
                        while (iterator.hasNext() && !(denied = (interceptor = iterator.next()).execute(this.conn, ql, update, baseURI, this.delegate))) {
                        }
                    }
                    if (!denied) {
                        this.delegate.execute();
                    }
                }

                @Override
                public void setBinding(String name, Value value) {
                    this.delegate.setBinding(name, value);
                }

                @Override
                public void removeBinding(String name) {
                    this.delegate.removeBinding(name);
                }

                @Override
                public void clearBindings() {
                    this.delegate.clearBindings();
                }

                @Override
                public BindingSet getBindings() {
                    return this.delegate.getBindings();
                }

                @Override
                public void setDataset(Dataset dataset) {
                    this.delegate.setDataset(dataset);
                }

                @Override
                public Dataset getDataset() {
                    return this.delegate.getDataset();
                }

                @Override
                public void setIncludeInferred(boolean includeInferred) {
                    this.delegate.setIncludeInferred(includeInferred);
                }

                @Override
                public boolean getIncludeInferred() {
                    return this.delegate.getIncludeInferred();
                }

                @Override
                public void setMaxExecutionTime(int maxExecutionTimeSeconds) {
                    this.delegate.setMaxExecutionTime(maxExecutionTimeSeconds);
                }

                @Override
                public int getMaxExecutionTime() {
                    return this.delegate.getMaxExecutionTime();
                }
            };
        }
        return this.getDelegate().prepareUpdate(ql, update, baseURI);
    }
}

