/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.ArbitraryLengthPath;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.EmptySet;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.SameTerm;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;

@Deprecated(forRemoval=true, since="4.1.0")
public class SameTermFilterOptimizer
implements QueryOptimizer {
    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit(new SameTermFilterVisitor());
    }

    protected static class VarBinder
    extends AbstractQueryModelVisitor<RuntimeException> {
        private final String varName;
        private final Value value;

        public VarBinder(String varName, Value value) {
            this.varName = varName;
            this.value = value;
        }

        @Override
        public void meet(Var var) {
            if (var.getName().equals(this.varName)) {
                var.setValue(this.value);
            }
        }
    }

    protected static class BindingSetAssignmentCollector
    extends AbstractQueryModelVisitor<RuntimeException> {
        private final List<BindingSetAssignment> assignments = new ArrayList<BindingSetAssignment>();

        protected BindingSetAssignmentCollector() {
        }

        @Override
        public void meet(BindingSetAssignment bsa) {
            this.assignments.add(bsa);
        }

        public List<BindingSetAssignment> getBindingSetAssignments() {
            return this.assignments;
        }
    }

    protected static class VarRenamer
    extends AbstractQueryModelVisitor<RuntimeException> {
        private final Var oldVar;
        private final Var newVar;

        public VarRenamer(Var oldVar, Var newVar) {
            this.oldVar = oldVar;
            this.newVar = newVar;
        }

        @Override
        public void meet(Var var) {
            if (var.equals(this.oldVar)) {
                var.replaceWith(this.newVar.clone());
            }
        }

        @Override
        public void meet(ProjectionElem projElem) throws RuntimeException {
            if (projElem.getSourceName().equals(this.oldVar.getName())) {
                projElem.setSourceName(this.newVar.getName());
            }
        }
    }

    protected static class SameTermFilterVisitor
    extends AbstractQueryModelVisitor<RuntimeException> {
        protected SameTermFilterVisitor() {
        }

        @Override
        public void meet(Filter filter) {
            super.meet(filter);
            if (filter.getCondition() instanceof SameTerm) {
                SameTerm sameTerm = (SameTerm)filter.getCondition();
                TupleExpr filterArg = filter.getArg();
                ValueExpr leftArg = sameTerm.getLeftArg();
                ValueExpr rightArg = sameTerm.getRightArg();
                Set<String> bindingNames = filterArg.getBindingNames();
                if (this.isUnboundVar(leftArg, bindingNames) || this.isUnboundVar(rightArg, bindingNames)) {
                    filter.replaceWith(new EmptySet());
                    return;
                }
                Set<String> assuredBindingNames = filterArg.getAssuredBindingNames();
                if (this.isUnboundVar(leftArg, assuredBindingNames) || this.isUnboundVar(rightArg, assuredBindingNames)) {
                    return;
                }
                if (leftArg instanceof Var || rightArg instanceof Var) {
                    if (filterArg instanceof ArbitraryLengthPath && leftArg instanceof Var && rightArg instanceof Var) {
                        ArbitraryLengthPath alp = (ArbitraryLengthPath)filterArg;
                        List<Var> sameTermArgs = Arrays.asList((Var)leftArg, (Var)rightArg);
                        if (sameTermArgs.contains(alp.getSubjectVar()) && sameTermArgs.contains(alp.getObjectVar())) {
                            return;
                        }
                    }
                    BindingSetAssignmentCollector collector = new BindingSetAssignmentCollector();
                    filterArg.visit(collector);
                    for (BindingSetAssignment bsa : collector.getBindingSetAssignments()) {
                        Set<String> names = bsa.getAssuredBindingNames();
                        if (leftArg instanceof Var && names.contains(((Var)leftArg).getName())) {
                            return;
                        }
                        if (!(rightArg instanceof Var) || !names.contains(((Var)rightArg).getName())) continue;
                        return;
                    }
                }
                Value leftValue = this.getValue(leftArg);
                Value rightValue = this.getValue(rightArg);
                if (leftValue == null || rightValue == null) {
                    if (leftValue != null && rightArg instanceof Var) {
                        this.bindVar((Var)rightArg, leftValue, filter);
                    } else if (rightValue != null && leftArg instanceof Var) {
                        this.bindVar((Var)leftArg, rightValue, filter);
                    } else if (leftArg instanceof Var && rightArg instanceof Var) {
                        this.renameVar((Var)rightArg, (Var)leftArg, filter);
                    }
                }
            }
        }

        private boolean isUnboundVar(ValueExpr valueExpr, Set<String> bindingNames) {
            if (valueExpr instanceof Var) {
                Var var = (Var)valueExpr;
                return !var.hasValue() && !bindingNames.contains(var.getName());
            }
            return false;
        }

        private Value getValue(ValueExpr valueExpr) {
            if (valueExpr instanceof ValueConstant) {
                return ((ValueConstant)valueExpr).getValue();
            }
            if (valueExpr instanceof Var) {
                return ((Var)valueExpr).getValue();
            }
            return null;
        }

        private void renameVar(Var oldVar, Var newVar, Filter filter) {
            filter.getArg().visit(new VarRenamer(oldVar, newVar));
            Extension extension = new Extension(filter.getArg());
            extension.addElement(new ExtensionElem(new Var(newVar.getName()), oldVar.getName()));
            filter.replaceWith(extension);
        }

        private void bindVar(Var var, Value value, Filter filter) {
            filter.getArg().visit(new VarBinder(var.getName(), value));
        }
    }
}

