/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import com.google.common.base.Stopwatch;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.rdf4j.collection.factory.api.CollectionFactory;
import org.eclipse.rdf4j.collection.factory.impl.DefaultCollectionFactory;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.DistinctIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.IterationWrapper;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.common.iteration.ReducedIteration;
import org.eclipse.rdf4j.common.iteration.SingletonIteration;
import org.eclipse.rdf4j.common.transaction.QueryEvaluationMode;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.ArbitraryLengthPath;
import org.eclipse.rdf4j.query.algebra.BNodeGenerator;
import org.eclipse.rdf4j.query.algebra.BinaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.BinaryValueOperator;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Bound;
import org.eclipse.rdf4j.query.algebra.Coalesce;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.CompareAll;
import org.eclipse.rdf4j.query.algebra.CompareAny;
import org.eclipse.rdf4j.query.algebra.Datatype;
import org.eclipse.rdf4j.query.algebra.DescribeOperator;
import org.eclipse.rdf4j.query.algebra.Difference;
import org.eclipse.rdf4j.query.algebra.Distinct;
import org.eclipse.rdf4j.query.algebra.EmptySet;
import org.eclipse.rdf4j.query.algebra.Exists;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.FunctionCall;
import org.eclipse.rdf4j.query.algebra.Group;
import org.eclipse.rdf4j.query.algebra.IRIFunction;
import org.eclipse.rdf4j.query.algebra.If;
import org.eclipse.rdf4j.query.algebra.In;
import org.eclipse.rdf4j.query.algebra.Intersection;
import org.eclipse.rdf4j.query.algebra.IsBNode;
import org.eclipse.rdf4j.query.algebra.IsLiteral;
import org.eclipse.rdf4j.query.algebra.IsNumeric;
import org.eclipse.rdf4j.query.algebra.IsResource;
import org.eclipse.rdf4j.query.algebra.IsURI;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.Label;
import org.eclipse.rdf4j.query.algebra.Lang;
import org.eclipse.rdf4j.query.algebra.LangMatches;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.ListMemberOperator;
import org.eclipse.rdf4j.query.algebra.LocalName;
import org.eclipse.rdf4j.query.algebra.MathExpr;
import org.eclipse.rdf4j.query.algebra.MultiProjection;
import org.eclipse.rdf4j.query.algebra.Namespace;
import org.eclipse.rdf4j.query.algebra.Not;
import org.eclipse.rdf4j.query.algebra.Or;
import org.eclipse.rdf4j.query.algebra.Order;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.Reduced;
import org.eclipse.rdf4j.query.algebra.Regex;
import org.eclipse.rdf4j.query.algebra.SameTerm;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.Slice;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Str;
import org.eclipse.rdf4j.query.algebra.TripleRef;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.TupleFunctionCall;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.UnaryValueOperator;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.ValueExprTripleRef;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.ZeroLengthPath;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizerPipeline;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.RDFStarTripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedService;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolverClient;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.function.FunctionRegistry;
import org.eclipse.rdf4j.query.algebra.evaluation.function.TupleFunction;
import org.eclipse.rdf4j.query.algebra.evaluation.function.TupleFunctionRegistry;
import org.eclipse.rdf4j.query.algebra.evaluation.function.datetime.Now;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ArrayBindingBasedQueryEvaluationContext;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.ExtensionQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.BindingSetAssignmentQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.IntersectionQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.JoinQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.LeftJoinQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.MinusQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.OrderQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.ProjectionQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.RdfStarQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.RegexValueEvaluationStepSupplier;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.ReificationRdfStarQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.ServiceQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.SliceQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.StatementPatternQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.UnionQueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.ZeroLengthPathEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.values.AndValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.values.CompareAllQueryValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.values.CompareAnyValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.values.ExistsQueryValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.values.IfValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.values.InValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.values.ListMemberValueOperationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.values.OrValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.values.QueryValueEvaluationStepSupplier;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps.values.ValueExprTripleRefEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.DescribeIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.ExtensionIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.FilterIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.GroupIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.MultiProjectionIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.PathIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.StandardQueryOptimizerPipeline;
import org.eclipse.rdf4j.query.algebra.evaluation.util.MathUtil;
import org.eclipse.rdf4j.query.algebra.evaluation.util.OrderComparator;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtility;
import org.eclipse.rdf4j.query.algebra.evaluation.util.ValueComparator;
import org.eclipse.rdf4j.query.algebra.evaluation.util.XMLDatatypeMathUtil;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;

public class DefaultEvaluationStrategy
implements EvaluationStrategy,
FederatedServiceResolverClient {
    protected final TripleSource tripleSource;
    protected final Dataset dataset;
    protected FederatedServiceResolver serviceResolver;
    private Literal sharedValueOfNow;
    private final long iterationCacheSyncThreshold;
    private boolean trackResultSize;
    private boolean trackTime;
    private UUID uuid;
    private QueryOptimizerPipeline pipeline;
    private final TupleFunctionRegistry tupleFuncRegistry;
    private QueryEvaluationMode queryEvaluationMode;
    private Supplier<CollectionFactory> collectionFactory = DefaultCollectionFactory::new;

    static CloseableIteration<BindingSet> evaluate(TupleFunction func, final List<Var> resultVars, final BindingSet bindings, ValueFactory valueFactory, Value ... argValues) throws QueryEvaluationException {
        final CloseableIteration<? extends List<? extends Value>> iter = func.evaluate(valueFactory, argValues);
        return new LookAheadIteration<BindingSet>(){

            public BindingSet getNextElement() throws QueryEvaluationException {
                QueryBindingSet resultBindings = null;
                block0: while (resultBindings == null && iter.hasNext()) {
                    resultBindings = new QueryBindingSet(bindings);
                    List values = (List)iter.next();
                    if (resultVars.size() != values.size()) {
                        throw new QueryEvaluationException("Incorrect number of result vars: require " + values.size());
                    }
                    for (int i = 0; i < values.size(); ++i) {
                        Value result = (Value)values.get(i);
                        Var resultVar = (Var)resultVars.get(i);
                        Value varValue = resultVar.getValue();
                        String varName = resultVar.getName();
                        Value boundValue = bindings.getValue(varName);
                        if ((varValue == null || result.equals(varValue)) && (boundValue == null || result.equals(boundValue))) {
                            if (boundValue != null) continue;
                            resultBindings.addBinding(varName, result);
                            continue;
                        }
                        resultBindings = null;
                        continue block0;
                    }
                }
                return resultBindings;
            }

            protected void handleClose() throws QueryEvaluationException {
                try {
                    super.handleClose();
                }
                finally {
                    iter.close();
                }
            }
        };
    }

    public DefaultEvaluationStrategy(TripleSource tripleSource, FederatedServiceResolver serviceResolver) {
        this(tripleSource, null, serviceResolver);
    }

    public DefaultEvaluationStrategy(TripleSource tripleSource, Dataset dataset, FederatedServiceResolver serviceResolver) {
        this(tripleSource, dataset, serviceResolver, 0L, new EvaluationStatistics());
    }

    public DefaultEvaluationStrategy(TripleSource tripleSource, Dataset dataset, FederatedServiceResolver serviceResolver, long iterationCacheSyncTreshold, EvaluationStatistics evaluationStatistics) {
        this(tripleSource, dataset, serviceResolver, iterationCacheSyncTreshold, evaluationStatistics, false);
    }

    public DefaultEvaluationStrategy(TripleSource tripleSource, Dataset dataset, FederatedServiceResolver serviceResolver, long iterationCacheSyncTreshold, EvaluationStatistics evaluationStatistics, boolean trackResultSize) {
        this(tripleSource, dataset, serviceResolver, iterationCacheSyncTreshold, evaluationStatistics, trackResultSize, TupleFunctionRegistry.getInstance());
    }

    public DefaultEvaluationStrategy(TripleSource tripleSource, Dataset dataset, FederatedServiceResolver serviceResolver, long iterationCacheSyncTreshold, EvaluationStatistics evaluationStatistics, boolean trackResultSize, TupleFunctionRegistry tupleFunctionRegistry) {
        this.tripleSource = tripleSource;
        this.dataset = dataset;
        this.serviceResolver = serviceResolver;
        this.iterationCacheSyncThreshold = iterationCacheSyncTreshold;
        this.pipeline = new StandardQueryOptimizerPipeline(this, tripleSource, evaluationStatistics);
        this.trackResultSize = trackResultSize;
        this.tupleFuncRegistry = tupleFunctionRegistry;
        this.setQueryEvaluationMode(QueryEvaluationMode.STANDARD);
    }

    public void setFederatedServiceResolver(FederatedServiceResolver resolver) {
        this.serviceResolver = resolver;
    }

    public FederatedServiceResolver getFederatedServiceResolver() {
        return this.serviceResolver;
    }

    @Override
    public FederatedService getService(String serviceUrl) throws QueryEvaluationException {
        return this.serviceResolver.getService(serviceUrl);
    }

    @Override
    public void setOptimizerPipeline(QueryOptimizerPipeline pipeline) {
        Objects.requireNonNull(pipeline);
        this.pipeline = pipeline;
    }

    @Override
    public TupleExpr optimize(TupleExpr expr, EvaluationStatistics evaluationStatistics, BindingSet bindings) {
        for (QueryOptimizer optimizer : this.pipeline.getOptimizers()) {
            optimizer.optimize(expr, this.dataset, bindings);
        }
        return expr;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Deprecated(forRemoval=true)
    public CloseableIteration<BindingSet> evaluate(TupleExpr expr, BindingSet bindings) throws QueryEvaluationException {
        Object var3_3 = null;
        try {
            void var3_30;
            void var3_32;
            if (expr instanceof StatementPattern) {
                CloseableIteration<BindingSet> closeableIteration = this.precompile(expr).evaluate(bindings);
            } else if (expr instanceof UnaryTupleOperator) {
                if (expr instanceof Projection) {
                    CloseableIteration<BindingSet> closeableIteration = this.precompile(expr).evaluate(bindings);
                } else if (expr instanceof MultiProjection) {
                    CloseableIteration<BindingSet> closeableIteration = this.precompile(expr).evaluate(bindings);
                } else if (expr instanceof Filter) {
                    CloseableIteration<BindingSet> closeableIteration = this.precompile(expr).evaluate(bindings);
                } else if (expr instanceof Service) {
                    CloseableIteration<BindingSet> closeableIteration = this.precompile(expr).evaluate(bindings);
                } else if (expr instanceof Slice) {
                    CloseableIteration<BindingSet> closeableIteration = this.precompile(expr).evaluate(bindings);
                } else if (expr instanceof Extension) {
                    CloseableIteration<BindingSet> closeableIteration = this.precompile(expr).evaluate(bindings);
                } else if (expr instanceof Distinct) {
                    CloseableIteration<BindingSet> closeableIteration = this.precompile(expr).evaluate(bindings);
                } else if (expr instanceof Reduced) {
                    CloseableIteration<BindingSet> closeableIteration = this.precompile(expr).evaluate(bindings);
                } else if (expr instanceof Group) {
                    CloseableIteration<BindingSet> closeableIteration = this.precompile(expr).evaluate(bindings);
                } else if (expr instanceof Order) {
                    CloseableIteration<BindingSet> closeableIteration = this.precompile(expr).evaluate(bindings);
                } else if (expr instanceof QueryRoot) {
                    this.sharedValueOfNow = null;
                    CloseableIteration<BindingSet> closeableIteration = this.evaluate(((UnaryTupleOperator)expr).getArg(), bindings);
                } else {
                    if (!(expr instanceof DescribeOperator)) throw new QueryEvaluationException("Unknown unary tuple operator type: " + ((UnaryTupleOperator)expr).getClass());
                    CloseableIteration<BindingSet> closeableIteration = this.precompile(expr).evaluate(bindings);
                }
            } else if (expr instanceof BinaryTupleOperator) {
                if (expr instanceof Join) {
                    CloseableIteration<BindingSet> closeableIteration = this.precompile(expr).evaluate(bindings);
                } else if (expr instanceof LeftJoin) {
                    CloseableIteration<BindingSet> closeableIteration = this.precompile(expr).evaluate(bindings);
                } else if (expr instanceof Union) {
                    CloseableIteration<BindingSet> closeableIteration = this.precompile(expr).evaluate(bindings);
                } else if (expr instanceof Intersection) {
                    CloseableIteration<BindingSet> closeableIteration = this.precompile(expr).evaluate(bindings);
                } else {
                    if (!(expr instanceof Difference)) throw new QueryEvaluationException("Unsupported binary tuple operator type: " + ((BinaryTupleOperator)expr).getClass());
                    CloseableIteration<BindingSet> closeableIteration = this.precompile(expr).evaluate(bindings);
                }
            } else if (expr instanceof SingletonSet) {
                CloseableIteration<BindingSet> closeableIteration = this.precompile(expr).evaluate(bindings);
            } else if (expr instanceof EmptySet) {
                EmptyIteration emptyIteration = new EmptyIteration();
            } else if (expr instanceof ZeroLengthPath) {
                CloseableIteration<BindingSet> closeableIteration = this.precompile(expr).evaluate(bindings);
            } else if (expr instanceof ArbitraryLengthPath) {
                CloseableIteration<BindingSet> closeableIteration = this.precompile(expr).evaluate(bindings);
            } else if (expr instanceof BindingSetAssignment) {
                CloseableIteration<BindingSet> closeableIteration = this.precompile(expr).evaluate(bindings);
            } else if (expr instanceof TripleRef) {
                CloseableIteration<BindingSet> closeableIteration = this.evaluate((TripleRef)expr, bindings);
            } else {
                if (expr instanceof TupleFunctionCall) {
                    if (this.getQueryEvaluationMode().compareTo((Enum)QueryEvaluationMode.STANDARD) >= 0) return this.evaluate(expr, bindings);
                    throw new QueryEvaluationException("Tuple function call not supported in query evaluation mode " + this.getQueryEvaluationMode());
                }
                if (expr != null) throw new QueryEvaluationException("Unsupported tuple expr type: " + expr.getClass());
                throw new IllegalArgumentException("expr must not be null");
            }
            if (this.trackTime) {
                void var3_28;
                expr.setTotalTimeNanosActual(Math.max(0L, expr.getTotalTimeNanosActual()));
                TimedIterator timedIterator = new TimedIterator((CloseableIteration<BindingSet>)var3_28, (QueryModelNode)expr);
            }
            if (!this.trackResultSize) return var3_32;
            expr.setResultSizeActual(Math.max(0L, expr.getResultSizeActual()));
            ResultSizeCountingIterator resultSizeCountingIterator = new ResultSizeCountingIterator((CloseableIteration<BindingSet>)var3_30, (QueryModelNode)expr);
            return var3_32;
        }
        catch (Throwable t) {
            if (var3_3 == null) throw t;
            var3_3.close();
            throw t;
        }
    }

    @Override
    public QueryEvaluationStep precompile(TupleExpr expr) {
        QueryEvaluationContext context = new QueryEvaluationContext.Minimal(this.dataset, this.tripleSource.getValueFactory());
        if (expr instanceof QueryRoot) {
            String[] allVariables = ArrayBindingBasedQueryEvaluationContext.findAllVariablesUsedInQuery((QueryRoot)expr);
            context = new ArrayBindingBasedQueryEvaluationContext(context, allVariables);
        }
        return this.precompile(expr, context);
    }

    @Override
    public QueryEvaluationStep precompile(TupleExpr expr, QueryEvaluationContext context) {
        QueryEvaluationStep ret;
        if (expr instanceof StatementPattern) {
            ret = this.prepare((StatementPattern)expr, context);
        } else if (expr instanceof UnaryTupleOperator) {
            ret = this.prepare((UnaryTupleOperator)expr, context);
        } else if (expr instanceof BinaryTupleOperator) {
            ret = this.prepare((BinaryTupleOperator)expr, context);
        } else if (expr instanceof SingletonSet) {
            ret = this.prepare((SingletonSet)expr, context);
        } else if (expr instanceof EmptySet) {
            ret = this.prepare((EmptySet)expr, context);
        } else if (expr instanceof ZeroLengthPath) {
            ret = this.prepare((ZeroLengthPath)expr, context);
        } else if (expr instanceof ArbitraryLengthPath) {
            ret = this.prepare((ArbitraryLengthPath)expr, context);
        } else if (expr instanceof BindingSetAssignment) {
            ret = this.prepare((BindingSetAssignment)expr, context);
        } else if (expr instanceof TripleRef) {
            ret = this.prepare((TripleRef)expr, context);
        } else if (expr instanceof TupleFunctionCall) {
            ret = this.prepare((TupleFunctionCall)expr, context);
        } else {
            if (expr == null) {
                throw new IllegalArgumentException("expr must not be null");
            }
            throw new QueryEvaluationException("Unsupported tuple expr type: " + expr.getClass());
        }
        if (ret != null) {
            if (this.trackTime) {
                ret = this.trackTime(expr, ret);
            }
            if (this.trackResultSize) {
                ret = this.trackResultSize(expr, ret);
            }
            return ret;
        }
        return QueryEvaluationStep.minimal(this, expr);
    }

    private QueryEvaluationStep trackResultSize(TupleExpr expr, QueryEvaluationStep qes) {
        return QueryEvaluationStep.wrap(qes, iter -> {
            expr.setResultSizeActual(Math.max(0L, expr.getResultSizeActual()));
            return new ResultSizeCountingIterator((CloseableIteration<BindingSet>)iter, (QueryModelNode)expr);
        });
    }

    private QueryEvaluationStep trackTime(TupleExpr expr, QueryEvaluationStep qes) {
        return QueryEvaluationStep.wrap(qes, iter -> {
            expr.setTotalTimeNanosActual(Math.max(0L, expr.getTotalTimeNanosActual()));
            return new TimedIterator((CloseableIteration<BindingSet>)iter, (QueryModelNode)expr);
        });
    }

    protected QueryEvaluationStep prepare(ArbitraryLengthPath alp, QueryEvaluationContext context) throws QueryEvaluationException {
        StatementPattern.Scope scope = alp.getScope();
        Var subjectVar = alp.getSubjectVar();
        TupleExpr pathExpression = alp.getPathExpression();
        Var objVar = alp.getObjectVar();
        Var contextVar = alp.getContextVar();
        long minLength = alp.getMinLength();
        return bindings -> new PathIteration(this, scope, subjectVar, pathExpression, objVar, contextVar, minLength, bindings);
    }

    protected QueryEvaluationStep prepare(ZeroLengthPath zlp, QueryEvaluationContext context) throws QueryEvaluationException {
        Var subjectVar = zlp.getSubjectVar();
        Var objVar = zlp.getObjectVar();
        Var contextVar = zlp.getContextVar();
        QueryValueEvaluationStep subPrep = this.precompile((ValueExpr)subjectVar, context);
        QueryValueEvaluationStep objPrep = this.precompile((ValueExpr)objVar, context);
        return new ZeroLengthPathEvaluationStep(subjectVar, objVar, contextVar, subPrep, objPrep, this, context);
    }

    protected QueryEvaluationStep prepare(Difference node, QueryEvaluationContext context) throws QueryEvaluationException {
        return new MinusQueryEvaluationStep(this.precompile(node.getLeftArg(), context), this.precompile(node.getRightArg(), context));
    }

    protected QueryEvaluationStep prepare(Group node, QueryEvaluationContext context) throws QueryEvaluationException {
        return bindings -> new GroupIterator(this, node, bindings, this.iterationCacheSyncThreshold, context);
    }

    protected QueryEvaluationStep prepare(Intersection node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryEvaluationStep leftArg = this.precompile(node.getLeftArg(), context);
        QueryEvaluationStep rightArg = this.precompile(node.getRightArg(), context);
        return new IntersectionQueryEvaluationStep(leftArg, rightArg, this::makeSet);
    }

    protected QueryEvaluationStep prepare(Join node, QueryEvaluationContext context) throws QueryEvaluationException {
        return new JoinQueryEvaluationStep(this, node, context);
    }

    protected QueryEvaluationStep prepare(LeftJoin node, QueryEvaluationContext context) throws QueryEvaluationException {
        return LeftJoinQueryEvaluationStep.supply(this, node, context);
    }

    protected QueryEvaluationStep prepare(MultiProjection node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryEvaluationStep arg = this.precompile(node.getArg(), context);
        return bindings -> {
            CloseableIteration<BindingSet> evaluate = null;
            try {
                evaluate = arg.evaluate(bindings);
                return new MultiProjectionIterator(node, evaluate, bindings);
            }
            catch (Throwable t) {
                if (evaluate != null) {
                    evaluate.close();
                }
                throw t;
            }
        };
    }

    protected QueryEvaluationStep prepare(Projection node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryEvaluationStep temp = this.precompile(node.getArg(), context);
        return new ProjectionQueryEvaluationStep(node, temp, context);
    }

    protected QueryEvaluationStep prepare(QueryRoot node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryEvaluationStep arg = this.precompile(node.getArg(), context);
        return new QueryRootQueryEvaluationStep(arg, context);
    }

    protected QueryEvaluationStep prepare(StatementPattern node, QueryEvaluationContext context) throws QueryEvaluationException {
        return new StatementPatternQueryEvaluationStep(node, context, this.tripleSource);
    }

    protected QueryEvaluationStep prepare(Union node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryEvaluationStep leftQes = this.precompile(node.getLeftArg(), context);
        QueryEvaluationStep rightQes = this.precompile(node.getRightArg(), context);
        return new UnionQueryEvaluationStep(leftQes, rightQes);
    }

    protected QueryEvaluationStep prepare(Slice node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryEvaluationStep arg = this.precompile(node.getArg(), context);
        return SliceQueryEvaluationStep.supply(node, arg);
    }

    protected QueryEvaluationStep prepare(Extension node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryEvaluationStep arg = this.precompile(node.getArg(), context);
        Consumer<MutableBindingSet> consumer = ExtensionIterator.buildLambdaToEvaluateTheExpressions(node, this, context);
        return new ExtensionQueryEvaluationStep(arg, consumer, context);
    }

    protected QueryEvaluationStep prepare(Service service, QueryEvaluationContext context) throws QueryEvaluationException {
        Var serviceRef = service.getServiceRef();
        return new ServiceQueryEvaluationStep(service, serviceRef, this.serviceResolver);
    }

    protected QueryEvaluationStep prepare(Filter node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryValueEvaluationStep ves;
        QueryEvaluationStep arg = this.precompile(node.getArg(), context);
        try {
            ves = this.precompile(node.getCondition(), context);
        }
        catch (QueryEvaluationException e) {
            return bs -> new EmptyIteration();
        }
        return bs -> {
            CloseableIteration<BindingSet> evaluate = null;
            try {
                evaluate = arg.evaluate(bs);
                return new FilterIterator(node, evaluate, ves, this);
            }
            catch (Throwable t) {
                if (evaluate != null) {
                    evaluate.close();
                }
                throw t;
            }
        };
    }

    protected QueryEvaluationStep prepare(Order node, QueryEvaluationContext context) throws QueryEvaluationException {
        ValueComparator vcmp = new ValueComparator();
        OrderComparator cmp = new OrderComparator(this, node, vcmp, context);
        boolean reduced = this.isReducedOrDistinct((QueryModelNode)node);
        long limit = this.getLimit((QueryModelNode)node);
        QueryEvaluationStep preparedArg = this.precompile(node.getArg(), context);
        return new OrderQueryEvaluationStep(cmp, limit, reduced, preparedArg, this.iterationCacheSyncThreshold);
    }

    protected QueryEvaluationStep prepare(BindingSetAssignment node, QueryEvaluationContext context) throws QueryEvaluationException {
        return new BindingSetAssignmentQueryEvaluationStep(node, context);
    }

    protected QueryEvaluationStep prepare(DescribeOperator node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryEvaluationStep child = this.precompile(node.getArg(), context);
        return bs -> new DescribeIteration(child.evaluate(bs), this, node.getBindingNames(), bs);
    }

    protected QueryEvaluationStep prepare(Distinct node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryEvaluationStep child = this.precompile(node.getArg(), context);
        return bindings -> {
            CloseableIteration<BindingSet> evaluate = child.evaluate(bindings);
            return new DistinctIteration(evaluate, this::makeSet);
        };
    }

    protected QueryEvaluationStep prepare(Reduced node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryEvaluationStep arg = this.precompile(node.getArg(), context);
        return bindings -> new ReducedIteration(arg.evaluate(bindings));
    }

    protected QueryEvaluationStep prepare(TupleFunctionCall expr, QueryEvaluationContext context) throws QueryEvaluationException {
        TupleFunction func = (TupleFunction)this.tupleFuncRegistry.get(expr.getURI()).orElseThrow(() -> new QueryEvaluationException("Unknown tuple function '" + expr.getURI() + "'"));
        List args = expr.getArgs();
        QueryValueEvaluationStep[] argEpresions = new QueryValueEvaluationStep[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            argEpresions[i] = this.precompile((ValueExpr)args.get(i), context);
        }
        return bindings -> {
            Value[] argValues = new Value[args.size()];
            for (int i = 0; i < args.size(); ++i) {
                argValues[i] = argEpresions[i].evaluate(bindings);
            }
            return DefaultEvaluationStrategy.evaluate(func, expr.getResultVars(), bindings, this.tripleSource.getValueFactory(), argValues);
        };
    }

    public static Value getVarValue(Var var, BindingSet bindings) {
        if (var == null) {
            return null;
        }
        if (var.hasValue()) {
            return var.getValue();
        }
        return bindings.getValue(var.getName());
    }

    protected QueryEvaluationStep prepare(UnaryTupleOperator expr, QueryEvaluationContext context) throws QueryEvaluationException {
        if (expr instanceof Projection) {
            return this.prepare((Projection)expr, context);
        }
        if (expr instanceof MultiProjection) {
            return this.prepare((MultiProjection)expr, context);
        }
        if (expr instanceof Filter) {
            return this.prepare((Filter)expr, context);
        }
        if (expr instanceof Service) {
            return this.prepare((Service)expr, context);
        }
        if (expr instanceof Slice) {
            return this.prepare((Slice)expr, context);
        }
        if (expr instanceof Extension) {
            return this.prepare((Extension)expr, context);
        }
        if (expr instanceof Distinct) {
            return this.prepare((Distinct)expr, context);
        }
        if (expr instanceof Reduced) {
            return this.prepare((Reduced)expr, context);
        }
        if (expr instanceof Group) {
            return this.prepare((Group)expr, context);
        }
        if (expr instanceof Order) {
            return this.prepare((Order)expr, context);
        }
        if (expr instanceof QueryRoot) {
            this.sharedValueOfNow = null;
            return this.precompile(expr.getArg(), context);
        }
        if (expr instanceof DescribeOperator) {
            return this.prepare((DescribeOperator)expr, context);
        }
        if (expr == null) {
            throw new IllegalArgumentException("expr must not be null");
        }
        throw new QueryEvaluationException("Unknown unary tuple operator type: " + expr.getClass());
    }

    protected QueryEvaluationStep prepare(BinaryTupleOperator expr, QueryEvaluationContext context) throws QueryEvaluationException {
        if (expr instanceof Join) {
            return this.prepare((Join)expr, context);
        }
        if (expr instanceof LeftJoin) {
            return this.prepare((LeftJoin)expr, context);
        }
        if (expr instanceof Union) {
            return this.prepare((Union)expr, context);
        }
        if (expr instanceof Intersection) {
            return this.prepare((Intersection)expr, context);
        }
        if (expr instanceof Difference) {
            return this.prepare((Difference)expr, context);
        }
        if (expr == null) {
            throw new IllegalArgumentException("expr must not be null");
        }
        throw new QueryEvaluationException("Unsupported binary tuple operator type: " + expr.getClass());
    }

    protected QueryEvaluationStep prepare(SingletonSet singletonSet, QueryEvaluationContext context) throws QueryEvaluationException {
        return SingletonIteration::new;
    }

    protected QueryEvaluationStep prepare(EmptySet emptySet, QueryEvaluationContext context) throws QueryEvaluationException {
        return bindings -> new EmptyIteration();
    }

    @Override
    public QueryValueEvaluationStep precompile(ValueExpr expr, QueryEvaluationContext context) throws QueryEvaluationException {
        if (expr instanceof Var) {
            return this.prepare((Var)expr, context);
        }
        if (expr instanceof ValueConstant) {
            return this.prepare((ValueConstant)expr, context);
        }
        if (expr instanceof BNodeGenerator) {
            return this.prepare((BNodeGenerator)expr, context);
        }
        if (expr instanceof Bound) {
            return this.prepare((Bound)expr, context);
        }
        if (expr instanceof Str) {
            return this.prepare((Str)expr, context);
        }
        if (expr instanceof Label) {
            return this.prepare((Label)expr, context);
        }
        if (expr instanceof Lang) {
            return this.prepare((Lang)expr, context);
        }
        if (expr instanceof LangMatches) {
            return this.prepare((LangMatches)expr, context);
        }
        if (expr instanceof Datatype) {
            return this.prepare((Datatype)expr, context);
        }
        if (expr instanceof Namespace) {
            return this.prepare((Namespace)expr, context);
        }
        if (expr instanceof LocalName) {
            return this.prepare((LocalName)expr, context);
        }
        if (expr instanceof IsResource) {
            return this.prepare((IsResource)expr, context);
        }
        if (expr instanceof IsURI) {
            return this.prepare((IsURI)expr, context);
        }
        if (expr instanceof IsBNode) {
            return this.prepare((IsBNode)expr, context);
        }
        if (expr instanceof IsLiteral) {
            return this.prepare((IsLiteral)expr, context);
        }
        if (expr instanceof IsNumeric) {
            return this.prepare((IsNumeric)expr, context);
        }
        if (expr instanceof IRIFunction) {
            return this.prepare((IRIFunction)expr, context);
        }
        if (expr instanceof Regex) {
            return this.prepare((Regex)expr, context);
        }
        if (expr instanceof Coalesce) {
            return this.prepare((Coalesce)expr, context);
        }
        if (expr instanceof FunctionCall) {
            return this.prepare((FunctionCall)expr, context);
        }
        if (expr instanceof And) {
            return this.prepare((And)expr, context);
        }
        if (expr instanceof Or) {
            return this.prepare((Or)expr, context);
        }
        if (expr instanceof Not) {
            return this.prepare((Not)expr, context);
        }
        if (expr instanceof SameTerm) {
            return this.prepare((SameTerm)expr, context);
        }
        if (expr instanceof Compare) {
            return this.prepare((Compare)expr, context);
        }
        if (expr instanceof MathExpr) {
            return this.prepare((MathExpr)expr, context);
        }
        if (expr instanceof In) {
            return this.prepare((In)expr, context);
        }
        if (expr instanceof CompareAny) {
            return this.prepare((CompareAny)expr, context);
        }
        if (expr instanceof CompareAll) {
            return this.prepare((CompareAll)expr, context);
        }
        if (expr instanceof Exists) {
            return this.prepare((Exists)expr, context);
        }
        if (expr instanceof If) {
            return this.prepare((If)expr, context);
        }
        if (expr instanceof ListMemberOperator) {
            return this.prepare((ListMemberOperator)expr, context);
        }
        if (expr instanceof ValueExprTripleRef) {
            return this.prepare((ValueExprTripleRef)expr, context);
        }
        if (expr == null) {
            throw new IllegalArgumentException("expr must not be null");
        }
        throw new QueryEvaluationException("Unsupported value expr type: " + expr.getClass());
    }

    @Override
    @Deprecated(forRemoval=true)
    public Value evaluate(ValueExpr expr, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(expr, (QueryEvaluationContext)new QueryEvaluationContext.Minimal(this.sharedValueOfNow, this.dataset)).evaluate(bindings);
    }

    protected QueryValueEvaluationStep prepare(Var var, QueryEvaluationContext context) throws QueryEvaluationException {
        Value value = var.getValue();
        if (value != null) {
            return new QueryValueEvaluationStep.ConstantQueryValueEvaluationStep(value);
        }
        java.util.function.Function<BindingSet, Value> getValue = context.getValue(var.getName());
        return bindings -> {
            Value value1 = (Value)getValue.apply(bindings);
            if (value1 == null) {
                throw new ValueExprEvaluationException();
            }
            return value1;
        };
    }

    protected QueryValueEvaluationStep prepare(ValueConstant valueConstant, QueryEvaluationContext context) throws QueryEvaluationException {
        return new QueryValueEvaluationStep.ConstantQueryValueEvaluationStep(valueConstant);
    }

    protected QueryValueEvaluationStep prepare(BNodeGenerator node, QueryEvaluationContext context) throws QueryEvaluationException {
        ValueFactory vf = this.tripleSource.getValueFactory();
        ValueExpr nodeIdExpr = node.getNodeIdExpr();
        if (nodeIdExpr != null) {
            QueryValueEvaluationStep nodeVes = this.precompile(nodeIdExpr, context);
            return QueryValueEvaluationStepSupplier.bnode(nodeVes, vf);
        }
        return new QueryValueEvaluationStep.ApplyFunctionForEachBinding(bs -> vf.createBNode());
    }

    protected QueryValueEvaluationStep prepare(Bound node, QueryEvaluationContext context) throws QueryEvaluationException {
        try {
            QueryValueEvaluationStep arg = this.precompile((ValueExpr)node.getArg(), context);
            return QueryValueEvaluationStepSupplier.prepareBound(arg, context);
        }
        catch (QueryEvaluationException e) {
            return new QueryValueEvaluationStep.ConstantQueryValueEvaluationStep((Value)BooleanLiteral.FALSE);
        }
    }

    protected QueryValueEvaluationStep prepare(Str node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryValueEvaluationStep arg = this.precompile(node.getArg(), context);
        ValueFactory valueFactory = this.tripleSource.getValueFactory();
        return QueryValueEvaluationStepSupplier.prepareStr(arg, valueFactory);
    }

    protected QueryValueEvaluationStep prepare(Label node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryValueEvaluationStep arg = this.precompile(node.getArg(), context);
        return QueryValueEvaluationStepSupplier.prepareLabel(arg, this.tripleSource.getValueFactory());
    }

    protected QueryValueEvaluationStep prepare(Lang node, QueryEvaluationContext context) {
        QueryValueEvaluationStep arg = this.precompile(node.getArg(), context);
        return QueryValueEvaluationStepSupplier.prepareLang(arg, this.tripleSource.getValueFactory());
    }

    public Value evaluate(Datatype node, BindingSet bindings) throws QueryEvaluationException {
        return this.prepare(node, (QueryEvaluationContext)new QueryEvaluationContext.Minimal(this.dataset)).evaluate(bindings);
    }

    protected QueryValueEvaluationStep prepare(Datatype node, QueryEvaluationContext context) {
        QueryValueEvaluationStep arg = this.precompile(node.getArg(), context);
        return QueryValueEvaluationStepSupplier.prepareDatatype(arg, context);
    }

    protected QueryValueEvaluationStep prepare(Namespace node, QueryEvaluationContext context) {
        QueryValueEvaluationStep arg = this.precompile(node.getArg(), context);
        return QueryValueEvaluationStepSupplier.prepareNamespace(arg, this.tripleSource.getValueFactory());
    }

    protected QueryValueEvaluationStep prepare(LocalName node, QueryEvaluationContext context) {
        QueryValueEvaluationStep arg = this.precompile(node.getArg(), context);
        return QueryValueEvaluationStepSupplier.prepareLocalName(arg, this.tripleSource.getValueFactory());
    }

    protected QueryValueEvaluationStep prepare(IsResource node, QueryEvaluationContext context) {
        QueryValueEvaluationStep arg = this.precompile(node.getArg(), context);
        return QueryValueEvaluationStepSupplier.prepareIs(arg, v -> v instanceof Resource);
    }

    protected QueryValueEvaluationStep prepare(IsURI node, QueryEvaluationContext context) {
        QueryValueEvaluationStep arg = this.precompile(node.getArg(), context);
        return QueryValueEvaluationStepSupplier.prepareIs(arg, v -> v instanceof IRI);
    }

    protected QueryValueEvaluationStep prepare(IsBNode node, QueryEvaluationContext context) {
        QueryValueEvaluationStep arg = this.precompile(node.getArg(), context);
        return QueryValueEvaluationStepSupplier.prepareIs(arg, v -> v instanceof BNode);
    }

    protected QueryValueEvaluationStep prepare(IsLiteral node, QueryEvaluationContext context) {
        QueryValueEvaluationStep arg = this.precompile(node.getArg(), context);
        return QueryValueEvaluationStepSupplier.prepareIs(arg, v -> v instanceof Literal);
    }

    protected QueryValueEvaluationStep prepare(IsNumeric node, QueryEvaluationContext context) {
        QueryValueEvaluationStep arg = this.precompile(node.getArg(), context);
        return QueryValueEvaluationStepSupplier.prepareIs(arg, DefaultEvaluationStrategy::isNumeric);
    }

    private static boolean isNumeric(Value argValue) {
        if (argValue instanceof Literal) {
            Literal lit = (Literal)argValue;
            CoreDatatype.XSD datatype = lit.getCoreDatatype().asXSDDatatypeOrNull();
            return datatype != null && datatype.isNumericDatatype();
        }
        return false;
    }

    protected QueryValueEvaluationStep prepare(IRIFunction node, QueryEvaluationContext context) {
        QueryValueEvaluationStep arg = this.precompile(node.getArg(), context);
        return QueryValueEvaluationStepSupplier.prepareIriFunction(node, arg, this.tripleSource.getValueFactory());
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(Regex node, BindingSet bindings) throws QueryEvaluationException {
        return this.prepare(node, (QueryEvaluationContext)new QueryEvaluationContext.Minimal(this.sharedValueOfNow, this.dataset)).evaluate(bindings);
    }

    protected QueryValueEvaluationStep prepare(Regex node, QueryEvaluationContext context) throws QueryEvaluationException {
        return RegexValueEvaluationStepSupplier.make(this, node, context);
    }

    protected QueryValueEvaluationStep prepare(LangMatches node, QueryEvaluationContext context) {
        return this.supplyBinaryValueEvaluation((BinaryValueOperator)node, this::evaluateLangMatch, context);
    }

    private Value evaluateLangMatch(Value langTagValue, Value langRangeValue) {
        if (QueryEvaluationUtility.isSimpleLiteral(langTagValue) && QueryEvaluationUtility.isSimpleLiteral(langRangeValue)) {
            String langTag = ((Literal)langTagValue).getLabel();
            String langRange = ((Literal)langRangeValue).getLabel();
            boolean result = Literals.langMatches((String)langTag, (String)langRange);
            return BooleanLiteral.valueOf((boolean)result);
        }
        throw new ValueExprEvaluationException();
    }

    public QueryValueEvaluationStep prepare(FunctionCall node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryValueEvaluationStep[] argSteps;
        Function function = (Function)FunctionRegistry.getInstance().get(node.getURI()).orElseThrow(() -> new QueryEvaluationException("Unknown function '" + node.getURI() + "'"));
        if (function instanceof Now) {
            return this.prepare((Now)function, context);
        }
        List args = node.getArgs();
        boolean allConstant = this.determineIfFunctionCallWillBeAConstant(context, function, args, argSteps = new QueryValueEvaluationStep[args.size()]);
        if (allConstant) {
            try {
                Value[] argValues = this.evaluateAllArguments(args, argSteps, EmptyBindingSet.getInstance());
                Value res = function.evaluate(this.tripleSource, argValues);
                return new QueryValueEvaluationStep.ConstantQueryValueEvaluationStep(res);
            }
            catch (QueryEvaluationException ex) {
                return new QueryValueEvaluationStep.Fail("Constant failure: " + ex.getMessage());
            }
        }
        return bindings -> {
            Value[] argValues = this.evaluateAllArguments(args, argSteps, bindings);
            return function.evaluate(this.tripleSource, argValues);
        };
    }

    private boolean determineIfFunctionCallWillBeAConstant(QueryEvaluationContext context, Function function, List<ValueExpr> args, QueryValueEvaluationStep[] argSteps) {
        boolean allConstant = true;
        if (function.mustReturnDifferentResult()) {
            allConstant = false;
            for (int i = 0; i < args.size(); ++i) {
                argSteps[i] = this.precompile(args.get(i), context);
            }
        } else {
            for (int i = 0; i < args.size(); ++i) {
                argSteps[i] = this.precompile(args.get(i), context);
                if (argSteps[i].isConstant()) continue;
                allConstant = false;
            }
        }
        return allConstant;
    }

    private Value[] evaluateAllArguments(List<ValueExpr> args, QueryValueEvaluationStep[] argSteps, BindingSet bindings) {
        Value[] argValues = new Value[argSteps.length];
        for (int i = 0; i < args.size(); ++i) {
            argValues[i] = argSteps[i].evaluate(bindings);
        }
        return argValues;
    }

    private QueryValueEvaluationStep prepare(And node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryValueEvaluationStep leftStep = this.precompile(node.getLeftArg(), context);
        QueryValueEvaluationStep rightStep = this.precompile(node.getRightArg(), context);
        return AndValueEvaluationStep.supply(leftStep, rightStep);
    }

    protected QueryValueEvaluationStep prepare(Or node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryValueEvaluationStep leftArg = null;
        QueryValueEvaluationStep rightArg = null;
        try {
            try {
                leftArg = this.precompile(node.getLeftArg(), context);
            }
            catch (ValueExprEvaluationException e) {
                return this.precompile(node.getRightArg(), context);
            }
            rightArg = this.precompile(node.getRightArg(), context);
        }
        catch (ValueExprEvaluationException e) {
            return new QueryValueEvaluationStep.Fail("Value Expressions in OR both failed to prepare/precompile");
        }
        return new OrValueEvaluationStep(leftArg, rightArg);
    }

    protected QueryValueEvaluationStep prepare(Not node, QueryEvaluationContext context) {
        return this.supplyUnaryValueEvaluation((UnaryValueOperator)node, v -> BooleanLiteral.valueOf((!QueryEvaluationUtil.getEffectiveBooleanValue(v) ? 1 : 0) != 0), context);
    }

    protected QueryValueEvaluationStep prepare(Now node, QueryEvaluationContext context) {
        return new QueryValueEvaluationStep.ConstantQueryValueEvaluationStep((Value)context.getNow());
    }

    protected QueryValueEvaluationStep prepare(SameTerm node, QueryEvaluationContext context) {
        return this.supplyBinaryValueEvaluation((BinaryValueOperator)node, (leftVal, rightVal) -> BooleanLiteral.valueOf((leftVal != null && leftVal.equals(rightVal) ? 1 : 0) != 0), context);
    }

    protected QueryValueEvaluationStep prepare(Coalesce node, QueryEvaluationContext context) throws QueryEvaluationException {
        List args = node.getArguments();
        ArrayList<QueryValueEvaluationStep> compiledArgs = new ArrayList<QueryValueEvaluationStep>(args.size());
        for (ValueExpr arg : args) {
            try {
                compiledArgs.add(this.precompile(arg, context));
            }
            catch (QueryEvaluationException queryEvaluationException) {}
        }
        return bindings -> {
            for (QueryValueEvaluationStep expr : compiledArgs) {
                try {
                    return expr.evaluate(bindings);
                }
                catch (QueryEvaluationException queryEvaluationException) {
                }
            }
            throw new ValueExprEvaluationException("COALESCE arguments do not evaluate to a value: " + node.getSignature());
        };
    }

    protected QueryValueEvaluationStep prepare(Compare node, QueryEvaluationContext context) {
        boolean strict = QueryEvaluationMode.STRICT == this.getQueryEvaluationMode();
        return this.supplyBinaryValueEvaluation((BinaryValueOperator)node, (leftVal, rightVal) -> BooleanLiteral.valueOf((boolean)QueryEvaluationUtil.compare(leftVal, rightVal, node.getOperator(), strict)), context);
    }

    private BiFunction<Value, Value, Value> mathOperationApplier(MathExpr node, QueryEvaluationMode queryEvaluationMode, ValueFactory vf) {
        MathExpr.MathOp operator = node.getOperator();
        switch (queryEvaluationMode) {
            case STRICT: {
                return (l, r) -> {
                    if (l instanceof Literal && r instanceof Literal) {
                        return MathUtil.compute((Literal)l, (Literal)r, operator);
                    }
                    throw new ValueExprEvaluationException("Both arguments must be literals");
                };
            }
        }
        return (l, r) -> {
            if (l instanceof Literal && r instanceof Literal) {
                return XMLDatatypeMathUtil.compute((Literal)l, (Literal)r, operator, vf);
            }
            throw new ValueExprEvaluationException("Both arguments must be literals");
        };
    }

    protected QueryValueEvaluationStep prepare(MathExpr node, QueryEvaluationContext context) {
        BiFunction<Value, Value, Value> mathOperationApplier = this.mathOperationApplier(node, this.getQueryEvaluationMode(), this.tripleSource.getValueFactory());
        return this.supplyBinaryValueEvaluation((BinaryValueOperator)node, mathOperationApplier, context);
    }

    protected QueryValueEvaluationStep prepare(If node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryValueEvaluationStep condition;
        try {
            condition = this.precompile(node.getCondition(), context);
        }
        catch (ValueExprEvaluationException e) {
            return new QueryValueEvaluationStep.ApplyFunctionForEachBinding(bs -> null);
        }
        QueryValueEvaluationStep result = this.precompile(node.getResult(), context);
        QueryValueEvaluationStep alternative = this.precompile(node.getAlternative(), context);
        return new IfValueEvaluationStep(result, condition, alternative);
    }

    protected QueryValueEvaluationStep prepare(In node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryValueEvaluationStep left = this.precompile(node.getArg(), context);
        QueryEvaluationStep subquery = this.precompile(node.getSubQuery(), context);
        return new InValueEvaluationStep(node, subquery, left);
    }

    protected QueryValueEvaluationStep prepare(ListMemberOperator node, QueryEvaluationContext context) throws QueryEvaluationException {
        List args = node.getArguments();
        ArrayList<QueryValueEvaluationStep> compiledArgs = new ArrayList<QueryValueEvaluationStep>(args.size());
        for (ValueExpr arg : args) {
            try {
                compiledArgs.add(this.precompile(arg, context));
            }
            catch (ValueExprEvaluationException e) {
                compiledArgs.add(new QueryValueEvaluationStep.Fail(""));
            }
        }
        return new ListMemberValueOperationStep(compiledArgs);
    }

    protected QueryValueEvaluationStep prepare(CompareAny node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryValueEvaluationStep arg = this.precompile(node.getArg(), context);
        QueryEvaluationStep subquery = this.precompile(node.getSubQuery(), context);
        return new CompareAnyValueEvaluationStep(arg, node, subquery, context);
    }

    protected QueryValueEvaluationStep prepare(CompareAll node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryValueEvaluationStep arg = this.precompile(node.getArg(), context);
        QueryEvaluationStep subquery = this.precompile(node.getSubQuery(), context);
        return new CompareAllQueryValueEvaluationStep(arg, node, subquery, context);
    }

    protected QueryValueEvaluationStep prepare(Exists node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryEvaluationStep subquery = this.precompile(node.getSubQuery(), context);
        return new ExistsQueryValueEvaluationStep(subquery);
    }

    @Override
    public boolean isTrue(ValueExpr expr, BindingSet bindings) throws QueryEvaluationException {
        Value value = this.evaluate(expr, bindings);
        return QueryEvaluationUtility.getEffectiveBooleanValue(value).orElse(false);
    }

    @Override
    public boolean isTrue(QueryValueEvaluationStep expr, BindingSet bindings) throws QueryEvaluationException {
        Value value = expr.evaluate(bindings);
        return QueryEvaluationUtility.getEffectiveBooleanValue(value).orElse(false);
    }

    protected boolean isReducedOrDistinct(QueryModelNode node) {
        QueryModelNode parent = node.getParentNode();
        if (parent instanceof Slice) {
            return this.isReducedOrDistinct(parent);
        }
        return parent instanceof Distinct || parent instanceof Reduced;
    }

    protected long getLimit(QueryModelNode node) {
        QueryModelNode parent;
        long offset = 0L;
        if (node instanceof Slice) {
            Slice slice = (Slice)node;
            if (slice.hasOffset() && slice.hasLimit()) {
                return slice.getOffset() + slice.getLimit();
            }
            if (slice.hasLimit()) {
                return slice.getLimit();
            }
            if (slice.hasOffset()) {
                offset = slice.getOffset();
            }
        }
        if ((parent = node.getParentNode()) instanceof Distinct || parent instanceof Reduced || parent instanceof Slice) {
            long limit = this.getLimit(parent);
            if (offset > 0L && limit < Long.MAX_VALUE) {
                return offset + limit;
            }
            return limit;
        }
        return Long.MAX_VALUE;
    }

    protected QueryValueEvaluationStep prepare(ValueExprTripleRef node, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryValueEvaluationStep subject = this.precompile((ValueExpr)node.getSubjectVar(), context);
        QueryValueEvaluationStep predicate = this.precompile((ValueExpr)node.getPredicateVar(), context);
        QueryValueEvaluationStep object = this.precompile((ValueExpr)node.getObjectVar(), context);
        ValueFactory valueFactory = this.tripleSource.getValueFactory();
        return new ValueExprTripleRefEvaluationStep(subject, valueFactory, predicate, object);
    }

    public CloseableIteration<BindingSet> evaluate(TripleRef ref, BindingSet bindings) {
        return this.precompile((TupleExpr)ref).evaluate(bindings);
    }

    protected QueryEvaluationStep prepare(TripleRef ref, QueryEvaluationContext context) {
        Var subjVar = ref.getSubjectVar();
        Var predVar = ref.getPredicateVar();
        Var objVar = ref.getObjectVar();
        Var extVar = ref.getExprVar();
        boolean sourceSupportsRdfStar = this.tripleSource instanceof RDFStarTripleSource;
        if (sourceSupportsRdfStar) {
            return new RdfStarQueryEvaluationStep(subjVar, predVar, objVar, extVar, (RDFStarTripleSource)this.tripleSource, context);
        }
        return new ReificationRdfStarQueryEvaluationStep(subjVar, predVar, objVar, extVar, this.tripleSource, context);
    }

    @Override
    public void setTrackResultSize(boolean trackResultSize) {
        this.trackResultSize = trackResultSize;
    }

    @Override
    public void setTrackTime(boolean trackTime) {
        this.trackTime = trackTime;
    }

    protected QueryValueEvaluationStep supplyBinaryValueEvaluation(BinaryValueOperator node, BiFunction<Value, Value, Value> operation, QueryEvaluationContext context) {
        QueryValueEvaluationStep leftStep = this.precompile(node.getLeftArg(), context);
        QueryValueEvaluationStep rightStep = this.precompile(node.getRightArg(), context);
        if (leftStep.isConstant() && rightStep.isConstant()) {
            Value leftVal = leftStep.evaluate(EmptyBindingSet.getInstance());
            Value rightVal = rightStep.evaluate(EmptyBindingSet.getInstance());
            Value value = operation.apply(leftVal, rightVal);
            return new QueryValueEvaluationStep.ConstantQueryValueEvaluationStep(value);
        }
        if (leftStep.isConstant()) {
            Value leftVal = leftStep.evaluate(EmptyBindingSet.getInstance());
            return bindings -> {
                Value rightVal = rightStep.evaluate(bindings);
                return (Value)operation.apply(leftVal, rightVal);
            };
        }
        if (rightStep.isConstant()) {
            Value rightVal = rightStep.evaluate(EmptyBindingSet.getInstance());
            return bindings -> {
                Value leftVal = leftStep.evaluate(bindings);
                Value result = (Value)operation.apply(leftVal, rightVal);
                return result;
            };
        }
        return bindings -> {
            Value leftVal = leftStep.evaluate(bindings);
            Value rightVal = rightStep.evaluate(bindings);
            return (Value)operation.apply(leftVal, rightVal);
        };
    }

    protected QueryValueEvaluationStep supplyUnaryValueEvaluation(UnaryValueOperator node, java.util.function.Function<Value, Value> operation, QueryEvaluationContext context) {
        QueryValueEvaluationStep argStep = this.precompile(node.getArg(), context);
        if (argStep.isConstant()) {
            Value argValue = argStep.evaluate(EmptyBindingSet.getInstance());
            return new QueryValueEvaluationStep.ConstantQueryValueEvaluationStep(operation.apply(argValue));
        }
        return bindings -> {
            Value argValue = argStep.evaluate(bindings);
            return (Value)operation.apply(argValue);
        };
    }

    @Override
    public QueryEvaluationMode getQueryEvaluationMode() {
        return this.queryEvaluationMode;
    }

    @Override
    public void setQueryEvaluationMode(QueryEvaluationMode queryEvaluationMode) {
        this.queryEvaluationMode = Objects.requireNonNull(queryEvaluationMode);
    }

    @Override
    public Supplier<CollectionFactory> getCollectionFactory() {
        return this.collectionFactory;
    }

    @Override
    public void setCollectionFactory(Supplier<CollectionFactory> cf) {
        this.collectionFactory = cf;
    }

    private static class TimedIterator
    extends IterationWrapper<BindingSet> {
        CloseableIteration<BindingSet> iterator;
        QueryModelNode queryModelNode;
        Stopwatch stopwatch = Stopwatch.createUnstarted();

        public TimedIterator(CloseableIteration<BindingSet> iterator, QueryModelNode queryModelNode) {
            super(iterator);
            this.iterator = iterator;
            this.queryModelNode = queryModelNode;
        }

        public BindingSet next() throws QueryEvaluationException {
            this.stopwatch.start();
            BindingSet next = (BindingSet)this.iterator.next();
            this.stopwatch.stop();
            return next;
        }

        public boolean hasNext() throws QueryEvaluationException {
            this.stopwatch.start();
            boolean hasNext = super.hasNext();
            this.stopwatch.stop();
            return hasNext;
        }

        protected void handleClose() throws QueryEvaluationException {
            try {
                this.queryModelNode.setTotalTimeNanosActual(this.queryModelNode.getTotalTimeNanosActual() + this.stopwatch.elapsed(TimeUnit.NANOSECONDS));
            }
            finally {
                super.handleClose();
            }
        }
    }

    private static class ResultSizeCountingIterator
    extends IterationWrapper<BindingSet> {
        CloseableIteration<BindingSet> iterator;
        QueryModelNode queryModelNode;

        public ResultSizeCountingIterator(CloseableIteration<BindingSet> iterator, QueryModelNode queryModelNode) {
            super(iterator);
            this.iterator = iterator;
            this.queryModelNode = queryModelNode;
        }

        public boolean hasNext() throws QueryEvaluationException {
            return this.iterator.hasNext();
        }

        public BindingSet next() throws QueryEvaluationException {
            this.queryModelNode.setResultSizeActual(this.queryModelNode.getResultSizeActual() + 1L);
            return (BindingSet)this.iterator.next();
        }
    }

    private final class QueryRootQueryEvaluationStep
    implements QueryEvaluationStep {
        private final QueryEvaluationStep arg;
        private final QueryEvaluationContext context;

        private QueryRootQueryEvaluationStep(QueryEvaluationStep arg, QueryEvaluationContext context) {
            this.arg = arg;
            this.context = context;
        }

        @Override
        public CloseableIteration<BindingSet> evaluate(BindingSet bs) {
            DefaultEvaluationStrategy.this.sharedValueOfNow = null;
            CloseableIteration<BindingSet> evaluate = null;
            try {
                final CloseableIteration<BindingSet> eval = evaluate = this.arg.evaluate(bs);
                CloseableIteration<BindingSet> closeContext = new CloseableIteration<BindingSet>(){

                    public boolean hasNext() throws QueryEvaluationException {
                        return eval.hasNext();
                    }

                    public BindingSet next() throws QueryEvaluationException {
                        return (BindingSet)eval.next();
                    }

                    public void remove() throws QueryEvaluationException {
                        eval.remove();
                    }

                    public void close() throws QueryEvaluationException {
                        eval.close();
                    }
                };
                return closeContext;
            }
            catch (Throwable t) {
                if (evaluate != null) {
                    evaluate.close();
                }
                throw t;
            }
        }
    }
}

