/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.EmptyIteration;
import org.eclipse.rdf4j.common.iteration.SingletonIteration;
import org.eclipse.rdf4j.federated.FedX;
import org.eclipse.rdf4j.federated.FederationContext;
import org.eclipse.rdf4j.federated.algebra.CheckStatementPattern;
import org.eclipse.rdf4j.federated.algebra.ConjunctiveFilterExpr;
import org.eclipse.rdf4j.federated.algebra.EmptyResult;
import org.eclipse.rdf4j.federated.algebra.EmptyStatementPattern;
import org.eclipse.rdf4j.federated.algebra.ExclusiveGroup;
import org.eclipse.rdf4j.federated.algebra.ExclusiveStatement;
import org.eclipse.rdf4j.federated.algebra.ExclusiveTupleExpr;
import org.eclipse.rdf4j.federated.algebra.ExclusiveTupleExprRenderer;
import org.eclipse.rdf4j.federated.algebra.FedXArbitraryLengthPath;
import org.eclipse.rdf4j.federated.algebra.FedXLeftJoin;
import org.eclipse.rdf4j.federated.algebra.FedXService;
import org.eclipse.rdf4j.federated.algebra.FedXZeroLengthPath;
import org.eclipse.rdf4j.federated.algebra.FederatedDescribeOperator;
import org.eclipse.rdf4j.federated.algebra.FilterExpr;
import org.eclipse.rdf4j.federated.algebra.FilterValueExpr;
import org.eclipse.rdf4j.federated.algebra.HolderNode;
import org.eclipse.rdf4j.federated.algebra.NJoin;
import org.eclipse.rdf4j.federated.algebra.NUnion;
import org.eclipse.rdf4j.federated.algebra.SingleSourceQuery;
import org.eclipse.rdf4j.federated.algebra.StatementSource;
import org.eclipse.rdf4j.federated.algebra.StatementSourcePattern;
import org.eclipse.rdf4j.federated.algebra.StatementTupleExpr;
import org.eclipse.rdf4j.federated.cache.CacheUtils;
import org.eclipse.rdf4j.federated.cache.SourceSelectionCache;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.evaluation.FedXZeroLengthPathEvaluationStep;
import org.eclipse.rdf4j.federated.evaluation.FederationEvaluationStatistics;
import org.eclipse.rdf4j.federated.evaluation.TripleSource;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ControlledWorkerScheduler;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelServiceExecutor;
import org.eclipse.rdf4j.federated.evaluation.iterator.FedXPathIteration;
import org.eclipse.rdf4j.federated.evaluation.iterator.FederatedDescribeIteration;
import org.eclipse.rdf4j.federated.evaluation.iterator.SingleBindingSetIteration;
import org.eclipse.rdf4j.federated.evaluation.join.ControlledWorkerLeftJoin;
import org.eclipse.rdf4j.federated.evaluation.union.ControlledWorkerUnion;
import org.eclipse.rdf4j.federated.evaluation.union.ParallelGetStatementsTask;
import org.eclipse.rdf4j.federated.evaluation.union.ParallelPreparedAlgebraUnionTask;
import org.eclipse.rdf4j.federated.evaluation.union.ParallelPreparedUnionTask;
import org.eclipse.rdf4j.federated.evaluation.union.ParallelUnionOperatorTask;
import org.eclipse.rdf4j.federated.evaluation.union.SynchronousWorkerUnion;
import org.eclipse.rdf4j.federated.evaluation.union.WorkerUnionBase;
import org.eclipse.rdf4j.federated.exception.FedXRuntimeException;
import org.eclipse.rdf4j.federated.exception.IllegalQueryException;
import org.eclipse.rdf4j.federated.optimizer.DefaultFedXCostModel;
import org.eclipse.rdf4j.federated.optimizer.ExclusiveTupleExprOptimizer;
import org.eclipse.rdf4j.federated.optimizer.FilterOptimizer;
import org.eclipse.rdf4j.federated.optimizer.GenericInfoOptimizer;
import org.eclipse.rdf4j.federated.optimizer.LimitOptimizer;
import org.eclipse.rdf4j.federated.optimizer.ServiceOptimizer;
import org.eclipse.rdf4j.federated.optimizer.SourceSelection;
import org.eclipse.rdf4j.federated.optimizer.StatementGroupAndJoinOptimizer;
import org.eclipse.rdf4j.federated.optimizer.UnionOptimizer;
import org.eclipse.rdf4j.federated.structures.FedXDataset;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.federated.structures.QueryType;
import org.eclipse.rdf4j.federated.util.FedXUtil;
import org.eclipse.rdf4j.federated.util.QueryStringUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.DescribeOperator;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.EvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryValueEvaluationStep;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedService;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.eclipse.rdf4j.query.algebra.evaluation.federation.ServiceJoinIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.QueryEvaluationContext;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.StrictEvaluationStrategy;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.BadlyDesignedLeftJoinIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.HashJoinIteration;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.ConstantOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.optimizer.DisjunctiveConstraintOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;
import org.eclipse.rdf4j.query.algebra.helpers.TupleExprs;
import org.eclipse.rdf4j.query.algebra.helpers.collectors.VarNameCollector;
import org.eclipse.rdf4j.query.impl.EmptyBindingSet;
import org.eclipse.rdf4j.query.impl.FallbackDataset;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sparql.federation.CollectionIteration;
import org.eclipse.rdf4j.repository.sparql.federation.RepositoryFederatedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FederationEvalStrategy
extends StrictEvaluationStrategy {
    private static final Logger log = LoggerFactory.getLogger(FederationEvalStrategy.class);
    protected Executor executor;
    protected SourceSelectionCache cache;
    protected FederationContext federationContext;

    public FederationEvalStrategy(FederationContext federationContext) {
        super(new org.eclipse.rdf4j.query.algebra.evaluation.TripleSource(){

            public CloseableIteration<? extends Statement> getStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws QueryEvaluationException {
                throw new FedXRuntimeException("Federation Strategy does not support org.eclipse.rdf4j.query.algebra.evaluation.TripleSource#getStatements. If you encounter this exception, please report it.");
            }

            public ValueFactory getValueFactory() {
                return SimpleValueFactory.getInstance();
            }
        }, (FederatedServiceResolver)federationContext.getFederatedServiceResolver());
        this.federationContext = federationContext;
        this.executor = federationContext.getManager().getExecutor();
        this.cache = federationContext.getSourceSelectionCache();
    }

    public TupleExpr optimize(TupleExpr expr, EvaluationStatistics evaluationStatistics, BindingSet bindings) {
        if (!(evaluationStatistics instanceof FederationEvaluationStatistics)) {
            throw new FedXRuntimeException("Expected FederationEvaluationStatistics, was " + evaluationStatistics.getClass());
        }
        FederationEvaluationStatistics stats = (FederationEvaluationStatistics)evaluationStatistics;
        QueryInfo queryInfo = stats.getQueryInfo();
        List<Endpoint> members = this.getMembersFromContext(stats);
        TupleExpr clone = expr.clone();
        Object query = clone instanceof QueryRoot ? clone : new QueryRoot(clone);
        GenericInfoOptimizer info = new GenericInfoOptimizer(queryInfo);
        info.optimize((TupleExpr)query);
        if (members.size() == 1 && queryInfo.getQuery() != null && this.propagateServices(info.getServices()) && queryInfo.getQueryType() != QueryType.UPDATE) {
            return new SingleSourceQuery(expr, members.get(0), queryInfo);
        }
        if (log.isTraceEnabled()) {
            log.trace("Query before Optimization: " + query);
        }
        new ConstantOptimizer((EvaluationStrategy)this).optimize(query, this.dataset, bindings);
        new DisjunctiveConstraintOptimizer().optimize(query, this.dataset, bindings);
        Set<Endpoint> relevantSources = this.performSourceSelection(members, this.cache, queryInfo, info);
        if (relevantSources.size() == 1 && this.propagateServices(info.getServices()) && queryInfo.getQueryType() != QueryType.UPDATE && queryInfo.getQueryType() != QueryType.DESCRIBE) {
            return new SingleSourceQuery((TupleExpr)query, relevantSources.iterator().next(), queryInfo);
        }
        if (info.hasService()) {
            new ServiceOptimizer(queryInfo).optimize((TupleExpr)query);
        }
        if (info.hasUnion()) {
            new UnionOptimizer(queryInfo).optimize((TupleExpr)query);
        }
        this.optimizeExclusiveExpressions((TupleExpr)query, queryInfo, info);
        this.optimizeJoinOrder((TupleExpr)query, queryInfo, info);
        if (info.hasLimit()) {
            new LimitOptimizer().optimize((TupleExpr)query);
        }
        if (info.hasFilter()) {
            new FilterOptimizer().optimize((TupleExpr)query);
        }
        if (log.isTraceEnabled()) {
            log.trace("Query after Optimization: " + query);
        }
        return query;
    }

    protected List<Endpoint> getMembersFromContext(FederationEvaluationStatistics evaluationStatisticss) {
        Dataset queryDataset = evaluationStatisticss.getDataset();
        if (queryDataset instanceof FallbackDataset) {
            queryDataset = ((FallbackDataset)queryDataset).getPrimary();
        }
        if (queryDataset instanceof FedXDataset) {
            FedXDataset ds = (FedXDataset)queryDataset;
            return this.federationContext.getEndpointManager().getEndpoints(ds.getEndpoints());
        }
        FedX fed = this.federationContext.getFederation();
        return fed.getMembers();
    }

    protected Set<Endpoint> performSourceSelection(List<Endpoint> members, SourceSelectionCache cache, QueryInfo queryInfo, GenericInfoOptimizer info) {
        HashSet<Endpoint> relevantMembers = new HashSet<Endpoint>();
        HashSet<StatementPattern> stmtPatterns = new HashSet<StatementPattern>(info.getStatements());
        if (info.hasPathExpression()) {
            HashSet<StatementPattern> handled = new HashSet<StatementPattern>();
            for (StatementPattern stmt : stmtPatterns) {
                if (!(stmt.getParentNode() instanceof FedXArbitraryLengthPath)) continue;
                FedXArbitraryLengthPath pathExpr = (FedXArbitraryLengthPath)stmt.getParentNode();
                Set<Endpoint> identifiedMembers = this.performSourceSelection(pathExpr, stmt, members, cache, queryInfo);
                relevantMembers.addAll(identifiedMembers);
                handled.add(stmt);
            }
            stmtPatterns.removeAll(handled);
        }
        SourceSelection sourceSelection = new SourceSelection(members, cache, queryInfo);
        sourceSelection.doSourceSelection(info.getStatements());
        relevantMembers.addAll(sourceSelection.getRelevantSources());
        return relevantMembers;
    }

    protected Set<Endpoint> performSourceSelection(FedXArbitraryLengthPath pathExpr, StatementPattern stmt, List<Endpoint> members, SourceSelectionCache cache, QueryInfo queryInfo) {
        StatementPattern replacement;
        Set<Endpoint> identifiedMembers;
        if (pathExpr.getMinLength() == 0L) {
            identifiedMembers = new HashSet<Endpoint>(members);
        } else {
            StatementPattern checkStmt = new StatementPattern(stmt.getScope(), new Var("subject"), this.clone(stmt.getPredicateVar()), new Var("object"), this.clone(stmt.getContextVar()));
            HolderNode holderParent = new HolderNode((QueryModelNode)checkStmt);
            SourceSelection sourceSelection = new SourceSelection(members, cache, queryInfo);
            sourceSelection.doSourceSelection(List.of(checkStmt));
            identifiedMembers = sourceSelection.getRelevantSources();
        }
        List statementSources = identifiedMembers.stream().map(e -> new StatementSource(e.getId(), StatementSource.StatementSourceType.REMOTE)).collect(Collectors.toList());
        if (statementSources.size() == 1) {
            replacement = new ExclusiveStatement(stmt, (StatementSource)((Object)statementSources.iterator().next()), queryInfo);
            stmt.replaceWith((QueryModelNode)replacement);
        } else if (statementSources.size() > 1) {
            replacement = new StatementSourcePattern(stmt, queryInfo);
            for (StatementSource stmtSource : statementSources) {
                replacement.addStatementSource(stmtSource);
            }
            stmt.replaceWith((QueryModelNode)replacement);
        } else {
            replacement = new EmptyStatementPattern(stmt);
            stmt.replaceWith((QueryModelNode)replacement);
        }
        return identifiedMembers;
    }

    private Var clone(Var var) {
        if (var == null) {
            return null;
        }
        return var.clone();
    }

    protected void optimizeJoinOrder(TupleExpr query, QueryInfo queryInfo, GenericInfoOptimizer info) {
        new StatementGroupAndJoinOptimizer(queryInfo, DefaultFedXCostModel.INSTANCE).optimize(query);
    }

    protected boolean propagateServices(List<Service> serviceNodes) {
        boolean hasServices;
        boolean bl = hasServices = serviceNodes != null && !serviceNodes.isEmpty();
        return !hasServices;
    }

    protected void optimizeExclusiveExpressions(TupleExpr query, QueryInfo queryInfo, GenericInfoOptimizer info) {
        new ExclusiveTupleExprOptimizer().optimize(query);
    }

    @Deprecated(forRemoval=true)
    public CloseableIteration<BindingSet> evaluate(TupleExpr expr, BindingSet bindings) throws QueryEvaluationException {
        if (expr instanceof StatementTupleExpr) {
            return ((StatementTupleExpr)expr).evaluate(bindings);
        }
        if (expr instanceof NJoin) {
            return this.evaluateNJoin((NJoin)expr, bindings);
        }
        if (expr instanceof NUnion) {
            return this.evaluateNaryUnion((NUnion)expr, bindings);
        }
        if (expr instanceof ExclusiveGroup) {
            return ((ExclusiveGroup)expr).evaluate(bindings);
        }
        if (expr instanceof ExclusiveTupleExpr) {
            return this.evaluateExclusiveTupleExpr((ExclusiveTupleExpr)expr, bindings);
        }
        if (expr instanceof FedXLeftJoin) {
            return this.evaluateLeftJoin((FedXLeftJoin)expr, bindings);
        }
        if (expr instanceof SingleSourceQuery) {
            return this.evaluateSingleSourceQuery((SingleSourceQuery)expr, bindings);
        }
        if (expr instanceof FedXService) {
            return this.evaluateService((FedXService)expr, bindings);
        }
        if (expr instanceof FedXArbitraryLengthPath) {
            return this.evaluateArbitrayLengthPath((FedXArbitraryLengthPath)expr, bindings);
        }
        if (expr instanceof FedXZeroLengthPath) {
            return this.evaluateZeroLengthPath((FedXZeroLengthPath)expr, bindings);
        }
        if (expr instanceof EmptyResult) {
            return new EmptyIteration();
        }
        return super.evaluate(expr, bindings);
    }

    public QueryEvaluationStep precompile(TupleExpr expr, QueryEvaluationContext context) throws QueryEvaluationException {
        if (expr instanceof Join) {
            return QueryEvaluationStep.minimal((EvaluationStrategy)this, (TupleExpr)expr);
        }
        if (expr instanceof StatementTupleExpr) {
            return QueryEvaluationStep.minimal((EvaluationStrategy)this, (TupleExpr)expr);
        }
        if (expr instanceof NJoin) {
            return this.prepareNJoin((NJoin)expr, context);
        }
        if (expr instanceof NUnion) {
            return this.prepareNaryUnion((NUnion)expr, context);
        }
        if (expr instanceof ExclusiveGroup) {
            return QueryEvaluationStep.minimal((EvaluationStrategy)this, (TupleExpr)expr);
        }
        if (expr instanceof ExclusiveTupleExpr) {
            return this.prepareExclusiveTupleExpr((ExclusiveTupleExpr)expr, context);
        }
        if (expr instanceof FedXLeftJoin) {
            return this.prepareLeftJoin((FedXLeftJoin)expr, context);
        }
        if (expr instanceof SingleSourceQuery) {
            return QueryEvaluationStep.minimal((EvaluationStrategy)this, (TupleExpr)expr);
        }
        if (expr instanceof FedXService) {
            return QueryEvaluationStep.minimal((EvaluationStrategy)this, (TupleExpr)expr);
        }
        if (expr instanceof FedXArbitraryLengthPath) {
            return this.prepare((FedXArbitraryLengthPath)expr, context);
        }
        if (expr instanceof FedXZeroLengthPath) {
            return this.prepare((FedXZeroLengthPath)expr, context);
        }
        if (expr instanceof EmptyResult) {
            return QueryEvaluationStep.minimal((EvaluationStrategy)this, (TupleExpr)expr);
        }
        return super.precompile(expr, context);
    }

    public CloseableIteration<Statement> getStatements(QueryInfo queryInfo, Resource subj, IRI pred, Value obj, Resource ... contexts) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        List<Endpoint> members = this.federationContext.getFederation().getMembers();
        if (subj != null && pred != null && obj != null) {
            if (CacheUtils.checkCacheUpdateCache(this.cache, members, subj, pred, obj, queryInfo, contexts)) {
                return new SingletonIteration((Object)FedXUtil.valueFactory().createStatement(subj, pred, obj));
            }
            return new EmptyIteration();
        }
        List<StatementSource> sources = CacheUtils.checkCacheForStatementSourcesUpdateCache(this.cache, members, subj, pred, obj, queryInfo, contexts);
        if (sources.isEmpty()) {
            return new EmptyIteration();
        }
        if (sources.size() == 1) {
            Endpoint e = this.federationContext.getEndpointManager().getEndpoint(sources.get(0).getEndpointID());
            return e.getTripleSource().getStatements(subj, pred, obj, queryInfo, contexts);
        }
        SynchronousWorkerUnion<Statement> union = new SynchronousWorkerUnion<Statement>(queryInfo);
        for (StatementSource source : sources) {
            Endpoint e = this.federationContext.getEndpointManager().getEndpoint(source.getEndpointID());
            ParallelGetStatementsTask task = new ParallelGetStatementsTask(union, e, subj, pred, obj, queryInfo, contexts);
            union.addTask(task);
        }
        this.executor.execute(union);
        return union;
    }

    public CloseableIteration<BindingSet> evaluateService(FedXService service, BindingSet bindings) throws QueryEvaluationException {
        ParallelServiceExecutor pe = new ParallelServiceExecutor(service, this, bindings, this.federationContext);
        pe.run();
        return pe;
    }

    public CloseableIteration<BindingSet> evaluateSingleSourceQuery(SingleSourceQuery query, BindingSet bindings) throws QueryEvaluationException {
        try {
            Endpoint source = query.getSource();
            return source.getTripleSource().getStatements(query.getQueryString(), bindings, query.getQueryInfo().getQueryType(), query.getQueryInfo());
        }
        catch (MalformedQueryException | RepositoryException e) {
            throw new QueryEvaluationException(e);
        }
    }

    public CloseableIteration<BindingSet> evaluateNJoin(NJoin join, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(join).evaluate(bindings);
    }

    protected QueryEvaluationStep prepareNJoin(NJoin join, QueryEvaluationContext context) throws QueryEvaluationException {
        QueryEvaluationStep resultProvider = this.precompile(join.getArg(0), context);
        ControlledWorkerScheduler<BindingSet> joinScheduler = this.federationContext.getManager().getJoinScheduler();
        return bindings -> {
            CloseableIteration<BindingSet> result = null;
            try {
                result = resultProvider.evaluate(bindings);
                int n = join.getNumberOfArguments();
                for (int i = 1; i < n; ++i) {
                    result = this.executeJoin(joinScheduler, result, join.getArg(i), join.getJoinVariables(i), bindings, join.getQueryInfo());
                }
            }
            catch (Throwable t) {
                if (result != null) {
                    result.close();
                }
                throw t;
            }
            return result;
        };
    }

    protected CloseableIteration<BindingSet> evaluateArbitrayLengthPath(FedXArbitraryLengthPath alp, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(alp).evaluate(bindings);
    }

    protected QueryEvaluationStep prepare(FedXArbitraryLengthPath alp, QueryEvaluationContext context) throws QueryEvaluationException {
        return bindings -> new FedXPathIteration((EvaluationStrategy)this, alp.getScope(), alp.getSubjectVar(), alp.getPathExpression(), alp.getObjectVar(), alp.getContextVar(), alp.getMinLength(), bindings, alp.getQueryInfo());
    }

    protected CloseableIteration<BindingSet> evaluateZeroLengthPath(FedXZeroLengthPath zlp, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile((TupleExpr)zlp).evaluate(bindings);
    }

    protected QueryEvaluationStep prepare(FedXZeroLengthPath zlp, QueryEvaluationContext context) throws QueryEvaluationException {
        Var subjectVar = zlp.getSubjectVar();
        Var objVar = zlp.getObjectVar();
        Var contextVar = zlp.getContextVar();
        QueryValueEvaluationStep subPrep = this.precompile((ValueExpr)subjectVar, context);
        QueryValueEvaluationStep objPrep = this.precompile((ValueExpr)objVar, context);
        return new FedXZeroLengthPathEvaluationStep(subjectVar, objVar, contextVar, subPrep, objPrep, (EvaluationStrategy)this, context, () -> zlp.getStatementSources(), () -> zlp.getQueryInfo());
    }

    protected CloseableIteration<BindingSet> evaluateLeftJoin(FedXLeftJoin leftJoin, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile((TupleExpr)leftJoin).evaluate(bindings);
    }

    protected QueryEvaluationStep prepareLeftJoin(final FedXLeftJoin leftJoin, final QueryEvaluationContext context) throws QueryEvaluationException {
        if (TupleExprs.containsSubquery((TupleExpr)leftJoin.getRightArg())) {
            return new QueryEvaluationStep(){
                final QueryEvaluationStep leftES;
                final QueryEvaluationStep rightES;
                {
                    this.leftES = FederationEvalStrategy.this.precompile(leftJoin.getLeftArg(), context);
                    this.rightES = FederationEvalStrategy.this.precompile(leftJoin.getRightArg(), context);
                }

                public CloseableIteration<BindingSet> evaluate(BindingSet bindings) {
                    String[] hashJoinAttributeNames = HashJoinIteration.hashJoinAttributeNames((LeftJoin)leftJoin);
                    return new HashJoinIteration(this.leftES, this.rightES, bindings, true, hashJoinAttributeNames, context);
                }
            };
        }
        VarNameCollector optionalVarCollector = new VarNameCollector();
        leftJoin.getRightArg().visit((QueryModelVisitor)optionalVarCollector);
        if (leftJoin.hasCondition()) {
            leftJoin.getCondition().visit((QueryModelVisitor)optionalVarCollector);
        }
        Set leftBindingNames = leftJoin.getLeftArg().getBindingNames();
        Set<String> problemVars = this.retainAll(optionalVarCollector.getVarNames(), leftBindingNames);
        QueryEvaluationStep leftPrepared = this.precompile(leftJoin.getLeftArg(), context);
        ControlledWorkerScheduler<BindingSet> scheduler = this.federationContext.getManager().getLeftJoinScheduler();
        return bindings -> {
            if (problemVars.containsAll(bindings.getBindingNames())) {
                CloseableIteration leftIter = leftPrepared.evaluate(bindings);
                ControlledWorkerLeftJoin join = new ControlledWorkerLeftJoin(scheduler, this, (CloseableIteration<BindingSet>)leftIter, leftJoin, bindings, leftJoin.getQueryInfo());
                this.executor.execute(join);
                return join;
            }
            HashSet problemVarsClone = new HashSet(problemVars);
            problemVarsClone.retainAll(bindings.getBindingNames());
            return new BadlyDesignedLeftJoinIterator((EvaluationStrategy)this, (LeftJoin)leftJoin, bindings, problemVarsClone, context);
        };
    }

    private Set<String> retainAll(Set<String> problemVars, Set<String> leftBindingNames) {
        block4: {
            if (leftBindingNames.isEmpty() || problemVars.isEmpty()) break block4;
            if (leftBindingNames.size() > problemVars.size()) {
                for (String problemVar : problemVars) {
                    if (!leftBindingNames.contains(problemVar)) continue;
                    HashSet<String> ret = new HashSet<String>(problemVars);
                    ret.removeAll(leftBindingNames);
                    return ret;
                }
            } else {
                for (String leftBindingName : leftBindingNames) {
                    if (!problemVars.contains(leftBindingName)) continue;
                    HashSet<String> ret = new HashSet<String>(problemVars);
                    ret.removeAll(leftBindingNames);
                    return ret;
                }
            }
        }
        return problemVars;
    }

    public CloseableIteration<BindingSet> evaluateNaryUnion(NUnion union, BindingSet bindings) throws QueryEvaluationException {
        return this.precompile(union).evaluate(bindings);
    }

    public QueryEvaluationStep prepareNaryUnion(NUnion union, QueryEvaluationContext context) throws QueryEvaluationException {
        ControlledWorkerScheduler<BindingSet> unionScheduler = this.federationContext.getManager().getUnionScheduler();
        ControlledWorkerUnion<BindingSet> unionRunnable = new ControlledWorkerUnion<BindingSet>(unionScheduler, union.getQueryInfo());
        int numberOfArguments = union.getNumberOfArguments();
        QueryEvaluationStep[] args = new QueryEvaluationStep[numberOfArguments];
        for (int i = 0; i < numberOfArguments; ++i) {
            args[i] = this.precompile(union.getArg(i), context);
        }
        return bindings -> {
            for (int i = 0; i < numberOfArguments; ++i) {
                unionRunnable.addTask(new ParallelUnionOperatorTask(unionRunnable, args[i], bindings));
            }
            this.executor.execute(unionRunnable);
            return unionRunnable;
        };
    }

    protected abstract CloseableIteration<BindingSet> executeJoin(ControlledWorkerScheduler<BindingSet> var1, CloseableIteration<BindingSet> var2, TupleExpr var3, Set<String> var4, BindingSet var5, QueryInfo var6) throws QueryEvaluationException;

    public abstract CloseableIteration<BindingSet> evaluateExclusiveGroup(ExclusiveGroup var1, BindingSet var2) throws RepositoryException, MalformedQueryException, QueryEvaluationException;

    protected CloseableIteration<BindingSet> evaluateExclusiveTupleExpr(ExclusiveTupleExpr expr, BindingSet bindings) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        return this.precompile(expr).evaluate(bindings);
    }

    protected QueryEvaluationStep prepareExclusiveTupleExpr(ExclusiveTupleExpr expr, QueryEvaluationContext context) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        if (expr instanceof StatementTupleExpr) {
            return bindings -> ((StatementTupleExpr)((Object)expr)).evaluate(bindings);
        }
        if (!(expr instanceof ExclusiveTupleExprRenderer)) {
            return super.precompile((TupleExpr)expr);
        }
        Endpoint ownedEndpoint = this.federationContext.getEndpointManager().getEndpoint(expr.getOwner().getEndpointID());
        TripleSource t = ownedEndpoint.getTripleSource();
        return bindings -> {
            AtomicBoolean isEvaluated = new AtomicBoolean(false);
            FilterValueExpr filterValueExpr = null;
            try {
                String preparedQuery = QueryStringUtil.selectQueryString((ExclusiveTupleExprRenderer)expr, bindings, filterValueExpr, isEvaluated, expr.getQueryInfo().getDataset());
                return t.getStatements(preparedQuery, bindings, isEvaluated.get() ? null : filterValueExpr, expr.getQueryInfo());
            }
            catch (IllegalQueryException e) {
                if (t.hasStatements(expr, bindings)) {
                    return new SingleBindingSetIteration(bindings);
                }
                return new EmptyIteration();
            }
        };
    }

    public abstract CloseableIteration<BindingSet> evaluateBoundJoinStatementPattern(StatementTupleExpr var1, List<BindingSet> var2) throws QueryEvaluationException;

    public abstract CloseableIteration<BindingSet> evaluateGroupedCheck(CheckStatementPattern var1, List<BindingSet> var2) throws QueryEvaluationException;

    public CloseableIteration<BindingSet> evaluateService(FedXService service, List<BindingSet> bindings) throws QueryEvaluationException {
        Var serviceRef = service.getService().getServiceRef();
        if (!serviceRef.hasValue()) {
            return new ServiceJoinIterator((CloseableIteration)new CollectionIteration(bindings), service.getService(), EmptyBindingSet.getInstance(), (EvaluationStrategy)this);
        }
        String serviceUri = serviceRef.getValue().stringValue();
        FederatedService fs = this.getService(serviceUri);
        if (fs instanceof RepositoryFederatedService) {
            ((RepositoryFederatedService)fs).setBoundJoinBlockSize(0);
        }
        return fs.evaluate(service.getService(), (CloseableIteration)new CollectionIteration(bindings), service.getService().getBaseURI());
    }

    @Deprecated(forRemoval=true)
    public Value evaluate(ValueExpr expr, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        if (expr instanceof FilterExpr) {
            return this.evaluate((FilterExpr)expr, bindings);
        }
        if (expr instanceof ConjunctiveFilterExpr) {
            return this.evaluate((ConjunctiveFilterExpr)expr, bindings);
        }
        return super.evaluate(expr, bindings);
    }

    public QueryValueEvaluationStep precompile(ValueExpr expr, QueryEvaluationContext context) throws ValueExprEvaluationException, QueryEvaluationException {
        if (expr instanceof FilterExpr) {
            return this.prepare((FilterExpr)expr, context);
        }
        if (expr instanceof ConjunctiveFilterExpr) {
            return this.prepare((ConjunctiveFilterExpr)expr, context);
        }
        return super.precompile(expr, context);
    }

    public Value evaluate(FilterExpr node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        Value v = this.evaluate(node.getExpression(), bindings);
        return BooleanLiteral.valueOf((boolean)QueryEvaluationUtil.getEffectiveBooleanValue((Value)v));
    }

    protected QueryValueEvaluationStep prepare(FilterExpr node, QueryEvaluationContext context) throws ValueExprEvaluationException, QueryEvaluationException {
        QueryValueEvaluationStep expr = this.precompile(node.getExpression(), context);
        return bindings -> {
            Value v = expr.evaluate(bindings);
            return BooleanLiteral.valueOf((boolean)QueryEvaluationUtil.getEffectiveBooleanValue((Value)v));
        };
    }

    public Value evaluate(ConjunctiveFilterExpr node, BindingSet bindings) throws ValueExprEvaluationException, QueryEvaluationException {
        return this.prepare(node, (QueryEvaluationContext)new QueryEvaluationContext.Minimal(this.dataset)).evaluate(bindings);
    }

    protected QueryValueEvaluationStep prepare(ConjunctiveFilterExpr node, QueryEvaluationContext context) throws ValueExprEvaluationException, QueryEvaluationException {
        List collect = node.getExpressions().stream().map(e -> this.precompile((ValueExpr)e, context)).collect(Collectors.toList());
        return bindings -> {
            ValueExprEvaluationException error = null;
            try {
                for (QueryValueEvaluationStep ves : collect) {
                    Value v = ves.evaluate(bindings);
                    if (QueryEvaluationUtil.getEffectiveBooleanValue((Value)v)) continue;
                    return BooleanLiteral.FALSE;
                }
            }
            catch (ValueExprEvaluationException e) {
                error = e;
            }
            if (error != null) {
                throw error;
            }
            return BooleanLiteral.TRUE;
        };
    }

    public CloseableIteration<BindingSet> evaluate(DescribeOperator operator, BindingSet bindings) throws QueryEvaluationException {
        if (!(operator instanceof FederatedDescribeOperator)) {
            throw new FedXRuntimeException("Expected a FedXDescribeOperator Node. Found " + operator.getClass() + " instead.");
        }
        CloseableIteration<BindingSet> iter = null;
        try {
            iter = this.evaluate(operator.getArg(), bindings);
            return new FederatedDescribeIteration(iter, this, operator.getBindingNames(), bindings, ((FederatedDescribeOperator)operator).getQueryInfo());
        }
        catch (Throwable t) {
            if (iter != null) {
                iter.close();
            }
            throw t;
        }
    }

    protected QueryEvaluationStep prepare(DescribeOperator operator, QueryEvaluationContext context) throws QueryEvaluationException {
        if (!(operator instanceof FederatedDescribeOperator)) {
            throw new FedXRuntimeException("Expected a FedXDescribeOperator Node. Found " + operator.getClass() + " instead.");
        }
        QueryEvaluationStep child = this.precompile(operator.getArg(), context);
        return bs -> new FederatedDescribeIteration((CloseableIteration<BindingSet>)child.evaluate(bs), this, operator.getBindingNames(), bs, ((FederatedDescribeOperator)operator).getQueryInfo());
    }

    protected CloseableIteration<BindingSet> evaluateAtStatementSources(Object preparedQuery, List<StatementSource> statementSources, QueryInfo queryInfo) throws QueryEvaluationException {
        if (preparedQuery instanceof String) {
            return this.evaluateAtStatementSources((String)preparedQuery, statementSources, queryInfo);
        }
        if (preparedQuery instanceof TupleExpr) {
            return this.evaluateAtStatementSources((TupleExpr)preparedQuery, statementSources, queryInfo);
        }
        throw new RuntimeException("Unsupported type for prepared query: " + preparedQuery.getClass().getCanonicalName());
    }

    protected CloseableIteration<BindingSet> evaluateAtStatementSources(String preparedQuery, List<StatementSource> statementSources, QueryInfo queryInfo) throws QueryEvaluationException {
        try {
            WorkerUnionBase<BindingSet> result;
            if (statementSources.size() == 1) {
                Endpoint ownedEndpoint = this.federationContext.getEndpointManager().getEndpoint(statementSources.get(0).getEndpointID());
                TripleSource t = ownedEndpoint.getTripleSource();
                result = t.getStatements(preparedQuery, EmptyBindingSet.getInstance(), (FilterValueExpr)null, queryInfo);
            } else {
                WorkerUnionBase<BindingSet> union = this.federationContext.getManager().createWorkerUnion(queryInfo);
                for (StatementSource source : statementSources) {
                    Endpoint ownedEndpoint = this.federationContext.getEndpointManager().getEndpoint(source.getEndpointID());
                    union.addTask(new ParallelPreparedUnionTask(union, preparedQuery, ownedEndpoint, EmptyBindingSet.getInstance(), null, queryInfo));
                }
                union.run();
                result = union;
            }
            return result;
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new QueryEvaluationException((Throwable)e);
        }
    }

    protected CloseableIteration<BindingSet> evaluateAtStatementSources(TupleExpr preparedQuery, List<StatementSource> statementSources, QueryInfo queryInfo) throws QueryEvaluationException {
        try {
            WorkerUnionBase<BindingSet> result;
            if (statementSources.size() == 1) {
                Endpoint ownedEndpoint = this.federationContext.getEndpointManager().getEndpoint(statementSources.get(0).getEndpointID());
                TripleSource t = ownedEndpoint.getTripleSource();
                result = t.getStatements(preparedQuery, EmptyBindingSet.getInstance(), null, queryInfo);
            } else {
                WorkerUnionBase<BindingSet> union = this.federationContext.getManager().createWorkerUnion(queryInfo);
                for (StatementSource source : statementSources) {
                    Endpoint ownedEndpoint = this.federationContext.getEndpointManager().getEndpoint(source.getEndpointID());
                    union.addTask(new ParallelPreparedAlgebraUnionTask(union, preparedQuery, ownedEndpoint, EmptyBindingSet.getInstance(), null, queryInfo));
                }
                union.run();
                result = union;
            }
            return result;
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new QueryEvaluationException((Throwable)e);
        }
    }
}

