/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.resultio;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.QueryResultHandler;
import org.eclipse.rdf4j.query.resultio.QueryResultParser;
import org.eclipse.rdf4j.query.resultio.RDFStarDecodingQueryResultHandler;
import org.eclipse.rdf4j.rio.ParseErrorListener;
import org.eclipse.rdf4j.rio.ParseLocationListener;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;

public abstract class AbstractQueryResultParser
implements QueryResultParser {
    protected ValueFactory valueFactory;
    protected QueryResultHandler handler;
    private ParserConfig parserConfig;
    private ParseErrorListener errListener;
    private ParseLocationListener locationListener;

    protected AbstractQueryResultParser() {
        this((ValueFactory)SimpleValueFactory.getInstance());
    }

    protected AbstractQueryResultParser(ValueFactory valueFactory) {
        this.setValueFactory(valueFactory);
        this.setParserConfig(new ParserConfig());
    }

    @Override
    public QueryResultParser setValueFactory(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
        return this;
    }

    @Override
    public QueryResultParser setQueryResultHandler(QueryResultHandler handler) {
        if (((Boolean)this.getParserConfig().get((RioSetting)BasicParserSettings.PROCESS_ENCODED_RDF_STAR)).booleanValue()) {
            handler = new RDFStarDecodingQueryResultHandler((QueryResultHandler)handler);
        }
        this.handler = handler;
        return this;
    }

    @Override
    public QueryResultParser setParserConfig(ParserConfig config) {
        this.parserConfig = config;
        return this;
    }

    @Override
    public ParserConfig getParserConfig() {
        return this.parserConfig;
    }

    @Override
    public QueryResultParser setParseErrorListener(ParseErrorListener el) {
        this.errListener = el;
        return this;
    }

    public ParseErrorListener getParseErrorListener() {
        return this.errListener;
    }

    @Override
    public QueryResultParser setParseLocationListener(ParseLocationListener el) {
        this.locationListener = el;
        return this;
    }

    public ParseLocationListener getParseLocationListener() {
        return this.locationListener;
    }

    @Override
    public Collection<RioSetting<?>> getSupportedSettings() {
        return Collections.emptyList();
    }

    @Override
    public <T> QueryResultParser set(RioSetting<T> setting, T value) {
        this.getParserConfig().set(setting, value);
        return this;
    }
}

