/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sequencing;

import java.io.Serializable;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.DatasourcePlatform;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public abstract class Sequence
implements Serializable,
Cloneable {
    protected String name = "";
    protected int size = 50;
    protected Platform platform;
    protected int initialValue = 1;
    protected int depth;

    public Sequence() {
    }

    public Sequence(String name) {
        this();
        this.setName(name);
    }

    public Sequence(String name, int size) {
        this();
        this.setName(name);
        this.setPreallocationSize(size);
    }

    public Sequence(String name, int size, int initialValue) {
        this();
        this.setName(name);
        this.setPreallocationSize(size);
        this.setInitialValue(initialValue);
    }

    public boolean isNative() {
        return false;
    }

    public boolean isTable() {
        return false;
    }

    public boolean isUnaryTable() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPreallocationSize() {
        return this.size;
    }

    public void setPreallocationSize(int size) {
        this.size = size;
    }

    public int getInitialValue() {
        return this.initialValue;
    }

    public void setInitialValue(int initialValue) {
        this.initialValue = initialValue;
    }

    public Object clone() {
        try {
            Sequence clone = (Sequence)super.clone();
            if (this.isConnected()) {
                clone.depth = 1;
                clone.onDisconnect(this.getDatasourcePlatform());
            }
            return clone;
        }
        catch (Exception exception) {
            throw new InternalError("Clone failed");
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Sequence) {
            return Sequence.equalNameAndSize(this, (Sequence)obj);
        }
        return false;
    }

    public static boolean equalNameAndSize(Sequence seq1, Sequence seq2) {
        if (seq1 == seq2) {
            return true;
        }
        return seq1.getName().equals(seq2.getName()) && seq1.getPreallocationSize() == seq2.getPreallocationSize();
    }

    protected void setDatasourcePlatform(Platform platform) {
        this.platform = platform;
    }

    public Platform getDatasourcePlatform() {
        return this.platform;
    }

    public abstract boolean shouldAcquireValueAfterInsert();

    public boolean shouldUsePreallocation() {
        return !this.shouldAcquireValueAfterInsert();
    }

    public abstract boolean shouldUseTransaction();

    public abstract Object getGeneratedValue(Accessor var1, AbstractSession var2, String var3);

    public Object getGeneratedValue(Accessor accessor, AbstractSession writeSession) {
        return this.getGeneratedValue(accessor, writeSession, this.getName());
    }

    public abstract Vector getGeneratedVector(Accessor var1, AbstractSession var2, String var3, int var4);

    public Vector getGeneratedVector(Accessor accessor, AbstractSession writeSession) {
        return this.getGeneratedVector(accessor, writeSession, this.getName(), this.getPreallocationSize());
    }

    public void onConnect(Platform platform) {
        this.setDatasourcePlatform(platform);
        this.onConnect();
        ++this.depth;
    }

    protected abstract void onConnect();

    public void onDisconnect(Platform platform) {
        if (this.isConnected()) {
            --this.depth;
        }
    }

    protected abstract void onDisconnect();

    public boolean isConnected() {
        return this.platform != null;
    }

    protected void verifyPlatform(Platform otherPlatform) {
        if (this.getDatasourcePlatform() != otherPlatform) {
            String hashCode1 = Integer.toString(System.identityHashCode(this.getDatasourcePlatform()));
            String name1 = ((DatasourcePlatform)this.getDatasourcePlatform()).toString() + '(' + hashCode1 + ')';
            String hashCode2 = Integer.toString(System.identityHashCode(otherPlatform));
            String name2 = ((DatasourcePlatform)otherPlatform).toString() + '(' + hashCode2 + ')';
            throw ValidationException.sequenceCannotBeConnectedToTwoPlatforms(this.getName(), name1, name2);
        }
    }
}

