/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.modelgen.objects;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.internal.jpa.modelgen.CanonicalModelProperties;
import org.eclipse.persistence.internal.jpa.modelgen.MetadataMirrorFactory;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceUnit;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceXML;
import org.eclipse.persistence.internal.jpa.modelgen.objects.PersistenceXMLMappings;
import org.eclipse.persistence.oxm.XMLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitReader {
    protected List<PersistenceUnit> persistenceUnits = new ArrayList<PersistenceUnit>();

    public PersistenceUnitReader(MetadataMirrorFactory factory) throws IOException {
        this.initPersistenceUnits(factory);
    }

    public FileObject getFileObject(String filename, ProcessingEnvironment processingEnv) throws IOException {
        return processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", filename);
    }

    protected HashSet<String> getPersistenceUnitList(ProcessingEnvironment processingEnv) {
        String persistenceUnits = processingEnv.getOptions().get("eclipselink.persistenceunits");
        HashSet<String> persistenceUnitList = null;
        if (persistenceUnits != null) {
            persistenceUnitList = new HashSet<String>();
            StringTokenizer st = new StringTokenizer(persistenceUnits, ",");
            while (st.hasMoreTokens()) {
                persistenceUnitList.add(st.nextToken().trim());
            }
        }
        return persistenceUnitList;
    }

    public List<PersistenceUnit> getPersistenceUnits() {
        return this.persistenceUnits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initPersistenceUnits(MetadataMirrorFactory factory) {
        ProcessingEnvironment processingEnv = factory.getProcessingEnvironment();
        for (String optionKey : processingEnv.getOptions().keySet()) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.OTHER, "Found Option : " + optionKey + ", with value: " + processingEnv.getOptions().get(optionKey));
        }
        String filename = CanonicalModelProperties.getOption((String)"eclipselink.persistencexml", (String)"META-INF/persistence.xml", processingEnv.getOptions());
        HashSet<String> persistenceUnitList = this.getPersistenceUnitList(processingEnv);
        try {
            FileObject fileObject = this.getFileObject(filename, processingEnv);
            InputStream inStream = null;
            try {
                inStream = fileObject.openInputStream();
                XMLContext context = PersistenceXMLMappings.createXMLContext();
                PersistenceXML persistenceXML = (PersistenceXML)context.createUnmarshaller().unmarshal(inStream);
                for (SEPersistenceUnitInfo puInfo : persistenceXML.getPersistenceUnitInfos()) {
                    if (persistenceUnitList != null && !persistenceUnitList.contains(puInfo.getPersistenceUnitName())) continue;
                    this.persistenceUnits.add(new PersistenceUnit(puInfo, factory, this));
                }
            }
            finally {
                if (inStream != null) {
                    inStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load persistence.xml : " + e.getLocalizedMessage());
        }
    }
}

