/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.foundation;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.FieldTransformation;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.MethodBasedFieldTransformation;
import org.eclipse.persistence.internal.descriptors.TransformerBasedFieldTransformation;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.indirection.BasicIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.ContainerIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.NoIndirectionPolicy;
import org.eclipse.persistence.internal.indirection.UnitOfWorkTransformerValueHolder;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.TransformationMappingChangeRecord;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.transformers.AttributeTransformer;
import org.eclipse.persistence.mappings.transformers.FieldTransformer;
import org.eclipse.persistence.mappings.transformers.MethodBasedAttributeTransformer;
import org.eclipse.persistence.mappings.transformers.MethodBasedFieldTransformer;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.ObjectCopyingPolicy;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.remote.DistributedSession;
import org.eclipse.persistence.sessions.remote.RemoteSession;

public abstract class AbstractTransformationMapping
extends DatabaseMapping {
    protected String attributeTransformerClassName;
    protected AttributeTransformer attributeTransformer;
    protected Vector fieldTransformations = NonSynchronizedVector.newInstance();
    protected Vector fieldToTransformers = NonSynchronizedVector.newInstance();
    protected boolean isMutable;
    protected IndirectionPolicy indirectionPolicy;

    public AbstractTransformationMapping() {
        this.setIsMutable(true);
        this.dontUseIndirection();
    }

    public void addFieldTransformation(DatabaseField field, String methodName) {
        MethodBasedFieldTransformation transformation = new MethodBasedFieldTransformation();
        transformation.setField(field);
        transformation.setMethodName(methodName);
        this.getFieldTransformations().addElement(transformation);
    }

    public void addFieldTransformation(String fieldName, String methodName) {
        this.addFieldTransformation(new DatabaseField(fieldName), methodName);
    }

    public void addFieldTransformerClassName(String fieldName, String className) {
        this.addFieldTransformerClassName(new DatabaseField(fieldName), className);
    }

    public void addFieldTransformerClassName(DatabaseField field, String className) {
        TransformerBasedFieldTransformation transformation = new TransformerBasedFieldTransformation();
        transformation.setField(field);
        transformation.setTransformerClassName(className);
        this.getFieldTransformations().addElement(transformation);
    }

    public void addFieldTransformer(String fieldName, FieldTransformer transformer) {
        this.addFieldTransformer(new DatabaseField(fieldName), transformer);
    }

    public void addFieldTransformer(DatabaseField field, FieldTransformer transformer) {
        TransformerBasedFieldTransformation transformation = new TransformerBasedFieldTransformation(transformer);
        transformation.setField(field);
        this.getFieldTransformations().addElement(transformation);
    }

    protected boolean areObjectsToBeProcessedInstantiated(Object object) {
        return this.getIndirectionPolicy().objectIsInstantiated(this.getAttributeValueFromObject(object));
    }

    public void buildBackupClone(Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        if (this.isWriteOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(clone);
        if (!this.isMutable()) {
            this.setAttributeValueInObject(backup, attributeValue);
            return;
        }
        Object clonedAttributeValue = this.isReadOnly() ? attributeValue : this.getIndirectionPolicy().backupCloneAttribute(attributeValue, clone, backup, unitOfWork);
        this.setAttributeValueInObject(backup, clonedAttributeValue);
    }

    protected AbstractRecord buildPhantomRowFrom(Object domainObject, AbstractSession session) {
        DatabaseRecord row = new DatabaseRecord(this.getFieldToTransformers().size());
        Enumeration stream = this.getFieldToTransformers().elements();
        while (stream.hasMoreElements()) {
            Object[] pair = (Object[])stream.nextElement();
            DatabaseField field = (DatabaseField)pair[0];
            FieldTransformer transformer = (FieldTransformer)pair[1];
            Object fieldValue = this.invokeFieldTransformer(field, transformer, domainObject, session);
            row.put(field, fieldValue);
        }
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildShallowOriginalFromRow(AbstractRecord record, Object original, JoinedAttributeManager joinManager, ObjectBuildingQuery query, AbstractSession executionSession) {
        UnitOfWorkImpl unitOfWork = (UnitOfWorkImpl)query.getSession();
        query.setSession(unitOfWork.getParent());
        try {
            this.readFromRowIntoObject(record, joinManager, original, query, executionSession);
        }
        finally {
            query.setSession(unitOfWork);
        }
    }

    public Object buildBackupCloneForPartObject(Object attributeValue, Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        if (!this.isMutable()) {
            return attributeValue;
        }
        AbstractRecord row = this.buildPhantomRowFrom(clone, unitOfWork);
        return this.invokeAttributeTransformer(row, backup, unitOfWork);
    }

    public void buildClone(Object original, Object clone, UnitOfWorkImpl unitOfWork) {
        if (this.isWriteOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(original);
        Object clonedAttributeValue = this.isReadOnly() || !this.isMutable() ? attributeValue : this.getIndirectionPolicy().cloneAttribute(attributeValue, original, clone, unitOfWork, false);
        this.setAttributeValueInObject(clone, clonedAttributeValue);
    }

    public void buildCloneFromRow(AbstractRecord record, JoinedAttributeManager joinManager, Object clone, ObjectBuildingQuery sourceQuery, UnitOfWorkImpl unitOfWork, AbstractSession executionSession) {
        if (this.isWriteOnly()) {
            return;
        }
        Object attributeValue = this.readFromRowIntoObject(record, joinManager, clone, sourceQuery, executionSession);
        Object clonedAttributeValue = this.isReadOnly() || !this.isMutable() ? attributeValue : this.getIndirectionPolicy().cloneAttribute(attributeValue, null, clone, unitOfWork, true);
        this.setAttributeValueInObject(clone, clonedAttributeValue);
    }

    public Object buildCloneForPartObject(Object attributeValue, Object original, Object clone, UnitOfWorkImpl unitOfWork, boolean isExisting) {
        return this.buildBackupCloneForPartObject(attributeValue, original, clone, unitOfWork);
    }

    public void buildCopy(Object copy, Object original, ObjectCopyingPolicy policy) {
        Object clonedAttributeValue;
        if (this.isWriteOnly()) {
            return;
        }
        Object attributeValue = this.getAttributeValueFromObject(original);
        if (this.isReadOnly() || !this.isMutable()) {
            clonedAttributeValue = attributeValue;
        } else {
            AbstractRecord row = this.buildPhantomRowFrom(original, policy.getSession());
            clonedAttributeValue = this.invokeAttributeTransformer(row, copy, policy.getSession());
        }
        this.setAttributeValueInObject(copy, clonedAttributeValue);
    }

    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    public Object clone() {
        AbstractTransformationMapping clone = (AbstractTransformationMapping)super.clone();
        clone.setFieldToTransformers(NonSynchronizedVector.newInstance(this.getFieldToTransformers().size() + 1));
        Enumeration enumtr = this.getFieldToTransformers().elements();
        while (enumtr.hasMoreElements()) {
            Object[] transformation = new Object[2];
            Object[] pair = (Object[])enumtr.nextElement();
            transformation[0] = pair[0];
            transformation[1] = pair[1];
            clone.getFieldToTransformers().addElement(transformation);
        }
        clone.setIndirectionPolicy((IndirectionPolicy)this.indirectionPolicy.clone());
        return clone;
    }

    protected Vector collectFields() {
        Vector<Object> databaseFields = new Vector<Object>(this.getFieldToTransformers().size());
        Enumeration stream = this.getFieldToTransformers().elements();
        while (stream.hasMoreElements()) {
            databaseFields.addElement(((Object[])stream.nextElement())[0]);
        }
        return databaseFields;
    }

    public ChangeRecord compareForChange(Object clone, Object backUp, ObjectChangeSet owner, AbstractSession session) {
        if (this.isReadOnly() || this.isWriteOnly()) {
            return null;
        }
        Object cloneAttribute = this.getAttributeValueFromObject(clone);
        Object backUpAttribute = null;
        if (cloneAttribute != null && !this.getIndirectionPolicy().objectIsInstantiated(cloneAttribute)) {
            return null;
        }
        boolean difference = false;
        if (owner.isNew()) {
            difference = true;
        } else {
            if (backUp != null) {
                backUpAttribute = this.getAttributeValueFromObject(backUp);
            }
            boolean backUpIsInstantiated = backUpAttribute == null || this.getIndirectionPolicy().objectIsInstantiated(backUpAttribute);
            Enumeration stream = this.getFieldToTransformers().elements();
            while (stream.hasMoreElements()) {
                Object[] pair = (Object[])stream.nextElement();
                DatabaseField field = (DatabaseField)pair[0];
                FieldTransformer transformer = (FieldTransformer)pair[1];
                Object cloneFieldValue = null;
                Object backUpFieldValue = null;
                if (clone != null) {
                    cloneFieldValue = this.invokeFieldTransformer(field, transformer, clone, session);
                }
                if (backUpIsInstantiated && backUp != null) {
                    backUpFieldValue = this.invokeFieldTransformer(field, transformer, backUp, session);
                }
                if (cloneFieldValue == null && backUpFieldValue == null || cloneFieldValue != null && cloneFieldValue.equals(backUpFieldValue)) continue;
                difference = true;
                break;
            }
        }
        if (difference) {
            return this.buildChangeRecord(clone, owner, session);
        }
        return null;
    }

    public ChangeRecord buildChangeRecord(Object clone, ObjectChangeSet owner, AbstractSession session) {
        TransformationMappingChangeRecord changeRecord = new TransformationMappingChangeRecord(owner);
        changeRecord.setRow(this.buildPhantomRowFrom(clone, session));
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        return changeRecord;
    }

    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession databaseSession) {
        Enumeration stream = this.getFieldToTransformers().elements();
        while (stream.hasMoreElements()) {
            Object[] objects = (Object[])stream.nextElement();
            DatabaseField field = (DatabaseField)objects[0];
            FieldTransformer transformer = (FieldTransformer)objects[1];
            Object firstFieldValue = this.invokeFieldTransformer(field, transformer, firstObject, databaseSession);
            Object secondFieldValue = this.invokeFieldTransformer(field, transformer, secondObject, databaseSession);
            if (firstFieldValue == null && secondFieldValue == null) continue;
            if (firstFieldValue == null || secondFieldValue == null) {
                return false;
            }
            if (firstFieldValue.equals(secondFieldValue)) continue;
            return false;
        }
        return true;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Class attributeTransformerClass;
        block13: {
            super.convertClassNamesToClasses(classLoader);
            if (this.attributeTransformerClassName == null) {
                return;
            }
            attributeTransformerClass = null;
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        attributeTransformerClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.attributeTransformerClassName, true, classLoader));
                        break block13;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.attributeTransformerClassName, exception.getException());
                    }
                }
                attributeTransformerClass = PrivilegedAccessHelper.getClassForName(this.attributeTransformerClassName, true, classLoader);
            }
            catch (ClassNotFoundException exc) {
                throw ValidationException.classNotFoundWhileConvertingClassNames(this.attributeTransformerClassName, exc);
            }
        }
        this.setAttributeTransformerClass(attributeTransformerClass);
        Enumeration stream = this.getFieldTransformations().elements();
        while (stream.hasMoreElements()) {
            Class transformerClass;
            TransformerBasedFieldTransformation transformer;
            block14: {
                FieldTransformation transformation = (FieldTransformation)stream.nextElement();
                if (!(transformation instanceof TransformerBasedFieldTransformation)) continue;
                transformer = (TransformerBasedFieldTransformation)transformation;
                String transformerClassName = transformer.getTransformerClassName();
                if (transformerClassName == null) {
                    return;
                }
                transformerClass = null;
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            transformerClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(transformerClassName, true, classLoader));
                            break block14;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(transformerClassName, exception.getException());
                        }
                    }
                    transformerClass = PrivilegedAccessHelper.getClassForName(transformerClassName, true, classLoader);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(transformerClassName, exc);
                }
            }
            transformer.setTransformerClass(transformerClass);
        }
    }

    public UnitOfWorkValueHolder createUnitOfWorkValueHolder(ValueHolderInterface attributeValue, Object original, Object clone, AbstractRecord row, UnitOfWorkImpl unitOfWork, boolean buildDirectlyFromRow) {
        return new UnitOfWorkTransformerValueHolder(attributeValue, original, clone, this, unitOfWork);
    }

    public void dontUseIndirection() {
        this.setIndirectionPolicy(new NoIndirectionPolicy());
    }

    public void fixObjectReferences(Object object, Map objectDescriptors, Map processedObjects, ObjectLevelReadQuery query, RemoteSession session) {
        this.getIndirectionPolicy().fixObjectReferences(object, objectDescriptors, processedObjects, query, session);
    }

    public AttributeTransformer getAttributeTransformer() {
        return this.attributeTransformer;
    }

    public String getAttributeMethodName() {
        if (this.getAttributeTransformer() instanceof MethodBasedAttributeTransformer) {
            return ((MethodBasedAttributeTransformer)this.getAttributeTransformer()).getMethodName();
        }
        return null;
    }

    public Class getAttributeTransformerClass() {
        if (this.getAttributeTransformer() == null || this.getAttributeTransformer() instanceof MethodBasedAttributeTransformer) {
            return null;
        }
        return this.getAttributeTransformer().getClass();
    }

    public void setAttributeTransformerClass(Class attributeTransformerClass) {
        if (attributeTransformerClass == null) {
            return;
        }
        try {
            Object instance = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    instance = AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(attributeTransformerClass));
                }
                catch (PrivilegedActionException ex) {
                    throw (Exception)ex.getCause();
                }
            } else {
                instance = PrivilegedAccessHelper.newInstanceFromClass(attributeTransformerClass);
            }
            this.setAttributeTransformer((AttributeTransformer)instance);
        }
        catch (Exception ex) {
            throw DescriptorException.attributeTransformerClassInvalid(this.getAttributeTransformerClassName(), this, ex);
        }
    }

    public String getAttributeTransformerClassName() {
        return this.attributeTransformerClassName;
    }

    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        if (this.isWriteOnly()) {
            return null;
        }
        Object attributeValue = super.getAttributeValueFromObject(object);
        return this.getIndirectionPolicy().validateAttributeOfInstantiatedObject(attributeValue);
    }

    public Vector getFieldTransformations() {
        return this.fieldTransformations;
    }

    public Vector getFieldToTransformers() {
        return this.fieldToTransformers;
    }

    public IndirectionPolicy getIndirectionPolicy() {
        return this.indirectionPolicy;
    }

    public Object getRealAttributeValueFromAttribute(Object attributeValue, Object object, AbstractSession session) {
        return this.indirectionPolicy.getRealAttributeValueFromObject(object, attributeValue);
    }

    public void instantiateAttribute(Object object, AbstractSession session) {
        this.getIndirectionPolicy().instantiateObject(object, this.getAttributeValueFromObject(object));
    }

    public Object getValueFromRemoteValueHolder(RemoteValueHolder remoteValueHolder) {
        return this.getIndirectionPolicy().getValueFromRemoteValueHolder(remoteValueHolder);
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        this.initializeAttributeTransformer(session);
        this.initializeFieldToTransformers(session);
        this.setFields(this.collectFields());
        this.getIndirectionPolicy().initialize();
    }

    protected void initializeAttributeTransformer(AbstractSession databaseSession) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        this.getAttributeTransformer().initialize(this);
    }

    public Hashtable getFieldNameToMethodNames() {
        Hashtable<String, String> table = new Hashtable<String, String>(this.getFieldTransformations().size());
        for (FieldTransformation transformation : this.getFieldTransformations()) {
            if (!(transformation instanceof MethodBasedFieldTransformation)) continue;
            table.put(transformation.getField().getQualifiedName(), ((MethodBasedFieldTransformation)transformation).getMethodName());
        }
        return table;
    }

    protected void initializeFieldToTransformers(AbstractSession session) throws DescriptorException {
        Enumeration stream = this.getFieldToTransformers().elements();
        while (stream.hasMoreElements()) {
            Object[] pair = (Object[])stream.nextElement();
            pair[0] = this.getDescriptor().buildField((DatabaseField)pair[0]);
            ((FieldTransformer)pair[1]).initialize(this);
        }
        stream = this.getFieldTransformations().elements();
        while (stream.hasMoreElements()) {
            FieldTransformation transformation = (FieldTransformation)stream.nextElement();
            DatabaseField field = this.getDescriptor().buildField(transformation.getField());
            String transformerClassName = "MethodBasedFieldTransformer";
            FieldTransformer transformer = null;
            try {
                transformer = transformation.buildTransformer();
            }
            catch (ConversionException ex) {
                if (transformation instanceof TransformerBasedFieldTransformation) {
                    transformerClassName = ((TransformerBasedFieldTransformation)transformation).getTransformerClassName();
                }
                throw DescriptorException.fieldTransformerClassNotFound(transformerClassName, this, ex);
            }
            catch (Exception ex) {
                if (transformation instanceof TransformerBasedFieldTransformation) {
                    transformerClassName = ((TransformerBasedFieldTransformation)transformation).getTransformerClassName();
                }
                throw DescriptorException.fieldTransformerClassInvalid(transformerClassName, this, ex);
            }
            transformer.initialize(this);
            if (field.getType() == null) {
                if (transformer instanceof MethodBasedFieldTransformer) {
                    field.setType(((MethodBasedFieldTransformer)transformer).getFieldType());
                } else if (field.getColumnDefinition() != null && session.getDatasourcePlatform() instanceof DatabasePlatform) {
                    for (Map.Entry entry : session.getPlatform().getFieldTypes().entrySet()) {
                        if (!((FieldTypeDefinition)entry.getValue()).getName().equals(field.getColumnDefinition())) continue;
                        field.setType((Class)entry.getKey());
                        break;
                    }
                }
            }
            Object[] fieldToTransformer = new Object[]{field, transformer};
            this.getFieldToTransformers().addElement(fieldToTransformer);
        }
    }

    public Object invokeAttributeTransformer(AbstractRecord record, Object domainObject, AbstractSession session) throws DescriptorException {
        return this.getAttributeTransformer().buildAttributeValue(record, domainObject, session);
    }

    protected Object invokeFieldTransformer(DatabaseField field, FieldTransformer transformer, Object domainObject, AbstractSession session) throws DescriptorException {
        return transformer.buildFieldValue(domainObject, field.getName(), session);
    }

    protected Object invokeFieldTransformer(DatabaseField field, Object domainObject, AbstractSession session) {
        Enumeration transformers = this.getFieldToTransformers().elements();
        while (transformers.hasMoreElements()) {
            Object[] next = (Object[])transformers.nextElement();
            if (!field.equals(next[0])) continue;
            return this.invokeFieldTransformer(field, (FieldTransformer)next[1], domainObject, session);
        }
        return null;
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    public boolean isReadOnly() {
        if (super.isReadOnly()) {
            return true;
        }
        return this.getFieldTransformations().isEmpty() && this.getFieldToTransformers().isEmpty();
    }

    public boolean isTransformationMapping() {
        return true;
    }

    public boolean isWriteOnly() {
        return this.getAttributeName() == null && this.getAttributeTransformer() == null && this.getAttributeTransformerClassName() == null;
    }

    public void iterate(DescriptorIterator iterator) {
        Object attributeValue = this.getAttributeValueFromObject(iterator.getVisitedParent());
        this.getIndirectionPolicy().iterateOnAttributeValue(iterator, attributeValue);
    }

    public void iterateOnRealAttributeValue(DescriptorIterator iterator, Object realAttributeValue) {
        iterator.iteratePrimitiveForMapping(realAttributeValue, this);
    }

    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager) {
        if (this.isWriteOnly()) {
            return;
        }
        if (!this.isMutable()) {
            this.setRealAttributeValueInObject(target, this.getRealAttributeValueFromObject(source, mergeManager.getSession()));
            return;
        }
        AbstractRecord record = (AbstractRecord)((TransformationMappingChangeRecord)changeRecord).getRecord();
        Object attributeValue = this.invokeAttributeTransformer(record, target, mergeManager.getSession());
        this.setRealAttributeValueInObject(target, attributeValue);
    }

    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager) {
        if (this.isWriteOnly()) {
            return;
        }
        if (mergeManager.shouldRefreshRemoteObject() && this.usesIndirection()) {
            this.getIndirectionPolicy().mergeRemoteValueHolder(target, source, mergeManager);
            return;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy() ? !this.areObjectsToBeProcessedInstantiated(target) : !this.areObjectsToBeProcessedInstantiated(source)) {
            return;
        }
        if (isTargetUnInitialized && mergeManager.shouldMergeWorkingCopyIntoOriginal() && !this.areObjectsToBeProcessedInstantiated(source)) {
            this.setAttributeValueInObject(target, this.getIndirectionPolicy().getOriginalIndirectionObject(this.getAttributeValueFromObject(source), mergeManager.getSession()));
            return;
        }
        if (this.isReadOnly()) {
            this.setRealAttributeValueInObject(target, this.getRealAttributeValueFromObject(source, mergeManager.getSession()));
            return;
        }
        if (!this.isMutable()) {
            Object attribute = this.getRealAttributeValueFromObject(source, mergeManager.getSession());
            if (this.descriptor.getObjectChangePolicy().isObjectChangeTrackingPolicy()) {
                Object targetAttribute = this.getRealAttributeValueFromObject(target, mergeManager.getSession());
                if ((mergeManager.shouldMergeCloneIntoWorkingCopy() || mergeManager.shouldMergeCloneWithReferencesIntoWorkingCopy()) && (targetAttribute == null && attribute != null || targetAttribute != null && !targetAttribute.equals(attribute))) {
                    this.descriptor.getObjectChangePolicy().raiseInternalPropertyChangeEvent(target, this.getAttributeName(), targetAttribute, attribute);
                }
            }
            this.setRealAttributeValueInObject(target, attribute);
            return;
        }
        AbstractRecord row = this.buildPhantomRowFrom(source, mergeManager.getSession());
        Object attributeValue = this.invokeAttributeTransformer(row, source, mergeManager.getSession());
        AbstractRecord targetRow = this.buildPhantomRowFrom(target, mergeManager.getSession());
        this.setRealAttributeValueInObject(target, attributeValue);
        if (this.descriptor.getObjectChangePolicy().isObjectChangeTrackingPolicy()) {
            Enumeration keys = targetRow.keys();
            while (keys.hasMoreElements()) {
                Object field = keys.nextElement();
                if (!mergeManager.shouldMergeCloneIntoWorkingCopy() && !mergeManager.shouldMergeCloneWithReferencesIntoWorkingCopy() || row.get(field).equals(targetRow.get(field))) continue;
                this.descriptor.getObjectChangePolicy().raiseInternalPropertyChangeEvent(target, this.getAttributeName(), this.invokeAttributeTransformer(targetRow, source, mergeManager.getSession()), attributeValue);
                break;
            }
        }
    }

    public void preInitialize(AbstractSession session) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        super.preInitialize(session);
        if (this.getAttributeClassification() != null && (this.getAttributeClassification().isPrimitive() || Helper.isPrimitiveWrapper(this.getAttributeClassification()) || this.getAttributeClassification().equals(ClassConstants.STRING) || this.getAttributeClassification().equals(ClassConstants.BIGDECIMAL) || this.getAttributeClassification().equals(ClassConstants.NUMBER))) {
            this.setIsMutable(false);
        }
    }

    public Object readFromReturnRowIntoObject(AbstractRecord row, Object object, ReadObjectQuery query, Collection handledMappings) throws DatabaseException {
        DatabaseRecord transformationRow = new DatabaseRecord(this.getFields().size());
        for (int i = 0; i < this.getFields().size(); ++i) {
            DatabaseField field = this.getFields().elementAt(i);
            Object value = row.containsKey(field) ? row.get(field) : this.valueFromObject(object, field, query.getSession());
            transformationRow.add(field, value);
        }
        Object attributeValue = this.readFromRowIntoObject(transformationRow, null, object, query, query.getSession());
        if (handledMappings != null) {
            handledMappings.add(this);
        }
        return attributeValue;
    }

    public Object readFromRowIntoObject(AbstractRecord row, JoinedAttributeManager joinManager, Object object, ObjectBuildingQuery query, AbstractSession executionSession) throws DatabaseException {
        if (this.isWriteOnly()) {
            return null;
        }
        Object attributeValue = this.getIndirectionPolicy().valueFromMethod(object, row, query.getSession());
        try {
            this.getAttributeAccessor().setAttributeValueInObject(object, attributeValue);
        }
        catch (DescriptorException exception) {
            exception.setMapping(this);
            throw exception;
        }
        return attributeValue;
    }

    public Vector getFieldNameToMethodNameAssociations() {
        Vector<Association> associations = new Vector<Association>();
        for (FieldTransformation tf : this.getFieldTransformations()) {
            if (!(tf instanceof MethodBasedFieldTransformation)) continue;
            Association ass = new Association();
            ass.setKey(tf.getField().getQualifiedName());
            ass.setValue(((MethodBasedFieldTransformation)tf).getMethodName());
            associations.addElement(ass);
        }
        return associations;
    }

    public void setFieldNameToMethodNameAssociations(Vector associations) {
        this.setFieldTransformations(NonSynchronizedVector.newInstance(associations.size()));
        for (Association ass : associations) {
            MethodBasedFieldTransformation tf = new MethodBasedFieldTransformation();
            tf.setField(new DatabaseField((String)ass.getKey()));
            tf.setMethodName((String)ass.getValue());
            this.getFieldTransformations().addElement(tf);
        }
    }

    public void remoteInitialization(DistributedSession session) {
        this.setFieldToTransformers(new Vector());
        if (!this.isWriteOnly()) {
            super.remoteInitialization(session);
            this.initializeAttributeTransformer(session);
        }
        this.initializeFieldToTransformers(session);
    }

    public void setAttributeTransformer(AttributeTransformer transformer) {
        this.attributeTransformer = transformer;
        if (transformer != null && !(transformer instanceof MethodBasedAttributeTransformer)) {
            this.attributeTransformerClassName = transformer.getClass().getName();
        }
    }

    public void setAttributeTransformerClassName(String className) {
        this.attributeTransformerClassName = className;
    }

    public void setAttributeTransformation(String methodName) {
        if (methodName != null && methodName != "") {
            this.setAttributeTransformer(new MethodBasedAttributeTransformer(methodName));
        } else {
            this.setAttributeTransformer(null);
        }
    }

    public void setAttributeValueInObject(Object object, Object value) {
        if (this.isWriteOnly()) {
            return;
        }
        super.setAttributeValueInObject(object, value);
    }

    public void setIsMutable(boolean mutable) {
        this.isMutable = mutable;
    }

    public void setRealAttributeValueInObject(Object object, Object value) throws DescriptorException {
        if (this.isWriteOnly()) {
            return;
        }
        this.getIndirectionPolicy().setRealAttributeValueInObject(object, value);
    }

    public void setFieldTransformations(Vector fieldTransformations) {
        this.fieldTransformations = fieldTransformations;
    }

    protected void setFieldToTransformers(Vector aVector) {
        this.fieldToTransformers = aVector;
    }

    public void setIndirectionPolicy(IndirectionPolicy indirectionPolicy) {
        this.indirectionPolicy = indirectionPolicy;
        indirectionPolicy.setMapping(this);
    }

    public void setUsesIndirection(boolean usesIndirection) {
        if (usesIndirection) {
            this.useBasicIndirection();
        } else {
            this.dontUseIndirection();
        }
    }

    public boolean shouldMergeCascadeParts(MergeManager mergeManager) {
        return mergeManager.shouldCascadeAllParts() || mergeManager.shouldCascadePrivateParts() && this.isPrivateOwned();
    }

    protected boolean shouldMergeCascadeReference(MergeManager mergeManager) {
        if (mergeManager.shouldCascadeReferences()) {
            return true;
        }
        return this.shouldMergeCascadeParts(mergeManager);
    }

    public void updateChangeRecord(Object clone, Object newValue, Object oldValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) {
        TransformationMappingChangeRecord changeRecord = (TransformationMappingChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (!this.isWriteOnly()) {
            if (changeRecord == null) {
                objectChangeSet.addChange(this.buildChangeRecord(clone, objectChangeSet, uow));
            } else {
                changeRecord.setRow(this.buildPhantomRowFrom(clone, uow));
            }
        }
    }

    public boolean isChangeTrackingSupported(Project project) {
        return !this.isMutable();
    }

    public void useBasicIndirection() {
        this.setIndirectionPolicy(new BasicIndirectionPolicy());
    }

    public void useContainerIndirection(Class containerClass) {
        ContainerIndirectionPolicy policy = new ContainerIndirectionPolicy();
        policy.setContainerClass(containerClass);
        this.setIndirectionPolicy(policy);
    }

    public void useIndirection() {
        this.useBasicIndirection();
    }

    public boolean usesIndirection() {
        return this.getIndirectionPolicy().usesIndirection();
    }

    public void validateBeforeInitialization(AbstractSession session) throws DescriptorException {
        super.validateBeforeInitialization(session);
        if (this.isWriteOnly()) {
            return;
        }
        if (this.getAttributeTransformer() == null && this.getAttributeTransformerClassName() == null) {
            session.getIntegrityChecker().handleError(DescriptorException.noAttributeTransformationMethod(this));
        }
        if (this.getAttributeAccessor() instanceof InstanceVariableAttributeAccessor) {
            Class attributeType = ((InstanceVariableAttributeAccessor)this.getAttributeAccessor()).getAttributeType();
            this.getIndirectionPolicy().validateDeclaredAttributeType(attributeType, session.getIntegrityChecker());
        } else if (this.getAttributeAccessor().isMethodAttributeAccessor()) {
            Class returnType = ((MethodAttributeAccessor)this.getAttributeAccessor()).getGetMethodReturnType();
            this.getIndirectionPolicy().validateGetMethodReturnType(returnType, session.getIntegrityChecker());
            Class parameterType = ((MethodAttributeAccessor)this.getAttributeAccessor()).getSetMethodParameterType();
            this.getIndirectionPolicy().validateSetMethodParameterType(parameterType, session.getIntegrityChecker());
        }
    }

    public Object valueFromObject(Object object, DatabaseField field, AbstractSession session) {
        return this.invokeFieldTransformer(field, object, session);
    }

    public void writeFromObjectIntoRow(Object object, AbstractRecord row, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        Enumeration stream = this.getFieldToTransformers().elements();
        while (stream.hasMoreElements()) {
            Object[] next = (Object[])stream.nextElement();
            DatabaseField field = (DatabaseField)next[0];
            FieldTransformer transformer = (FieldTransformer)next[1];
            Object fieldValue = this.invokeFieldTransformer(field, transformer, object, session);
            row.put(field, fieldValue);
        }
    }

    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord row, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        Enumeration stream = this.getFieldToTransformers().elements();
        while (stream.hasMoreElements()) {
            Object[] next = (Object[])stream.nextElement();
            DatabaseField field = (DatabaseField)next[0];
            Object fieldValue = ((TransformationMappingChangeRecord)changeRecord).getRecord().get(field);
            row.put(field, fieldValue);
        }
    }

    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery query, AbstractRecord record) {
        if (!this.areObjectsToBeProcessedInstantiated(query.getObject())) {
            return;
        }
        if (query.getSession().isUnitOfWork() && this.compareObjects(query.getBackupClone(), query.getObject(), query.getSession())) {
            return;
        }
        this.writeFromObjectIntoRow(query.getObject(), record, query.getSession());
    }

    public void writeInsertFieldsIntoRow(AbstractRecord record, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        Enumeration entry = this.getFieldToTransformers().elements();
        while (entry.hasMoreElements()) {
            DatabaseField field = (DatabaseField)((Object[])entry.nextElement())[0];
            record.put(field, (Object)null);
        }
    }
}

