/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.io.IOException;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;

public final class SecurePreferencesUtility {
    private SecurePreferencesUtility() {
    }

    public static void storeCredentials(String path, String username, String password) throws StorageException, IOException {
        ISecurePreferences securePreferences = SecurePreferencesFactory.getDefault();
        ISecurePreferences node = securePreferences.node(path);
        node.put("username", username, false);
        node.put("password", password, true);
        securePreferences.flush();
    }

    public static String[] loadCredentials(String path) throws StorageException {
        ISecurePreferences securePreferences = SecurePreferencesFactory.getDefault();
        ISecurePreferences node = securePreferences.node(path);
        String username = node.get("username", null);
        String password = node.get("password", null);
        if (username != null && password != null) {
            return new String[]{username, password};
        }
        return null;
    }

    public static void removeCredentials(String path) throws IOException {
        ISecurePreferences securePreferences = SecurePreferencesFactory.getDefault();
        ISecurePreferences node = securePreferences.node(path);
        node.removeNode();
        securePreferences.flush();
    }
}

