/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Array;
import java.util.HashMap;
import org.eclipse.scout.commons.internal.Activator;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.osgi.framework.Bundle;

public class BundleObjectInputStream
extends ObjectInputStream {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BundleObjectInputStream.class);
    private static final HashMap<String, Class> PRIMITIVE_TYPES = new HashMap(8, 1.0f);
    private Bundle[] m_bundleList;

    static {
        PRIMITIVE_TYPES.put("boolean", Boolean.TYPE);
        PRIMITIVE_TYPES.put("byte", Byte.TYPE);
        PRIMITIVE_TYPES.put("char", Character.TYPE);
        PRIMITIVE_TYPES.put("short", Short.TYPE);
        PRIMITIVE_TYPES.put("int", Integer.TYPE);
        PRIMITIVE_TYPES.put("long", Long.TYPE);
        PRIMITIVE_TYPES.put("float", Float.TYPE);
        PRIMITIVE_TYPES.put("double", Double.TYPE);
        PRIMITIVE_TYPES.put("void", Void.TYPE);
        PRIMITIVE_TYPES.put("Z", Boolean.TYPE);
        PRIMITIVE_TYPES.put("B", Byte.TYPE);
        PRIMITIVE_TYPES.put("C", Character.TYPE);
        PRIMITIVE_TYPES.put("S", Short.TYPE);
        PRIMITIVE_TYPES.put("I", Integer.TYPE);
        PRIMITIVE_TYPES.put("J", Long.TYPE);
        PRIMITIVE_TYPES.put("F", Float.TYPE);
        PRIMITIVE_TYPES.put("D", Double.TYPE);
        PRIMITIVE_TYPES.put("V", Void.TYPE);
    }

    public BundleObjectInputStream(InputStream in, Bundle[] bundleList) throws IOException {
        super(in);
        this.m_bundleList = bundleList;
        this.enableResolveObject(true);
    }

    @Override
    public Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        return this.defaultResolveClass(desc.getName());
    }

    private Class<?> defaultResolveClass(String className) throws ClassNotFoundException, IOException {
        Class c = PRIMITIVE_TYPES.get(className);
        if (c != null) {
            return c;
        }
        try {
            int arrayDim = 0;
            while (className.startsWith("[")) {
                className = className.substring(1);
                ++arrayDim;
            }
            if (className.matches("L.*;")) {
                className = className.substring(1, className.length() - 1);
            }
            if (arrayDim <= 0) {
                Bundle b;
                Bundle[] bundleArray = this.m_bundleList;
                int n = this.m_bundleList.length;
                int n2 = 0;
                while (n2 < n) {
                    b = bundleArray[n2];
                    if (b.getState() == 32) {
                        try {
                            c = b.loadClass(className);
                            break;
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    }
                    ++n2;
                }
                if (c != null) {
                    return c;
                }
                bundleArray = this.m_bundleList;
                n = this.m_bundleList.length;
                n2 = 0;
                while (n2 < n) {
                    b = bundleArray[n2];
                    if (b.getState() == 4 && className.startsWith(b.getSymbolicName())) {
                        try {
                            c = b.loadClass(className);
                            break;
                        }
                        catch (ClassNotFoundException classNotFoundException) {}
                    }
                    ++n2;
                }
                if (c != null) {
                    return c;
                }
                bundleArray = this.m_bundleList;
                n = this.m_bundleList.length;
                n2 = 0;
                while (n2 < n) {
                    b = bundleArray[n2];
                    try {
                        c = b.loadClass(className);
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        ++n2;
                    }
                }
                if (c != null) {
                    return c;
                }
                if (Activator.getDefault() == null) {
                    c = Class.forName(className);
                    return c;
                }
                throw new ClassNotFoundException(className);
            }
            c = this.defaultResolveClass(className);
            int[] dimensions = new int[arrayDim];
            c = Array.newInstance(c, dimensions).getClass();
            return c;
        }
        catch (ClassNotFoundException e) {
            LOG.error("reading serialized object from http proxy tunnel: " + e.getMessage(), e);
            throw e;
        }
    }
}

