/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.xmlparser;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.scout.commons.Base64Utility;
import org.eclipse.scout.commons.osgi.ContextFinderBasedObjectInputStream;

public class SimpleXmlElement {
    private static final HashMap<String, String> ENTITIES = new HashMap();
    private static final HashMap<String, String> INVERSE_ENTITIES;
    private TreeMap<String, String> m_attributeMap;
    private ArrayList<String> m_attributeNames;
    private SimpleXmlElement m_parent;
    private ArrayList<SimpleXmlElement> m_children;
    private String m_name;
    private String m_contents;
    private int m_lineNr;
    private char m_charReadTooMuch;
    private Reader m_reader;
    private int m_parserLineNr;
    private boolean m_ignoreCase;
    private boolean m_ignoreWhitespace;

    static {
        ENTITIES.put("amp", "&");
        ENTITIES.put("quot", "\"");
        ENTITIES.put("apos", "'");
        ENTITIES.put("lt", "<");
        ENTITIES.put("gt", ">");
        ENTITIES.put("auml", "\ufffd");
        ENTITIES.put("ouml", "\ufffd");
        ENTITIES.put("uuml", "\ufffd");
        ENTITIES.put("Auml", "\ufffd");
        ENTITIES.put("Ouml", "\ufffd");
        ENTITIES.put("Uuml", "\ufffd");
        INVERSE_ENTITIES = new HashMap();
        INVERSE_ENTITIES.put("&", "&amp;");
        INVERSE_ENTITIES.put("\"", "&quot;");
        INVERSE_ENTITIES.put("'", "&apos;");
        INVERSE_ENTITIES.put("<", "&lt;");
        INVERSE_ENTITIES.put(">", "&gt;");
    }

    public SimpleXmlElement() {
        this((String)null);
    }

    public SimpleXmlElement(String name) {
        this(name, false, false);
    }

    public SimpleXmlElement(String name, boolean ignoreWhiteSpace, boolean ignoreCase) {
        this.m_name = name;
        this.m_ignoreCase = ignoreCase;
        this.m_ignoreWhitespace = ignoreWhiteSpace;
        this.m_contents = "";
        this.m_attributeMap = new TreeMap();
        this.m_attributeNames = new ArrayList();
        this.m_children = new ArrayList();
        this.m_lineNr = 0;
    }

    public SimpleXmlElement(SimpleXmlElement x) {
        this.m_name = x.m_name;
        this.m_ignoreCase = x.m_ignoreCase;
        this.m_ignoreWhitespace = x.m_ignoreWhitespace;
        this.m_contents = x.m_contents;
        this.m_attributeMap = new TreeMap<String, String>((SortedMap<String, String>)x.m_attributeMap);
        this.m_attributeNames = new ArrayList<String>(x.m_attributeNames);
        this.m_children = new ArrayList();
        this.m_lineNr = 0;
    }

    public void setIgnoreWhitespace(boolean b) {
        this.m_ignoreWhitespace = b;
    }

    public boolean isIgnoreWhitespace() {
        return this.m_ignoreWhitespace;
    }

    public void setIgnoreCase(boolean b) {
        this.m_ignoreCase = b;
    }

    public boolean isIgnoreCase() {
        return this.m_ignoreCase;
    }

    public void addChild(SimpleXmlElement child) {
        if (child.m_parent != null) {
            child.m_parent.removeChild(child);
        }
        this.m_children.add(child);
        child.m_parent = this;
    }

    public void addChild(SimpleXmlElement child, int pos) {
        this.m_children.add(pos, child);
        child.m_parent = this;
    }

    public void replaceChild(SimpleXmlElement oldChild, SimpleXmlElement newChild) {
        if (newChild == null) {
            throw new IllegalArgumentException("newChild must not be null");
        }
        int index = this.m_children.indexOf(oldChild);
        if (index < 0) {
            throw new IllegalArgumentException("oldChild " + oldChild + " does not exist");
        }
        this.m_children.set(index, newChild);
        newChild.m_parent = this;
        oldChild.m_parent = null;
    }

    public void setAttribute(String name, Object value) {
        if (this.m_ignoreCase) {
            name = name.toUpperCase();
        }
        this.setAttributeInternal(name, value != null ? value.toString() : null);
    }

    public void setIntAttribute(String name, int value) {
        if (this.m_ignoreCase) {
            name = name.toUpperCase();
        }
        this.setAttributeInternal(name, Integer.toString(value));
    }

    public void setDoubleAttribute(String name, double value) {
        if (this.m_ignoreCase) {
            name = name.toUpperCase();
        }
        this.setAttributeInternal(name, Double.toString(value));
    }

    public int countChildren() {
        return this.m_children.size();
    }

    public void clearAttributes() {
        this.m_attributeMap.clear();
        this.m_attributeNames.clear();
    }

    public void moveTo(int newIndex) {
        ArrayList<SimpleXmlElement> a;
        int i;
        if (this.m_parent != null && (i = (a = this.m_parent.m_children).indexOf(this)) >= 0 && i != newIndex) {
            newIndex = Math.min(Math.max(0, newIndex), a.size() - 1);
            a.remove(i);
            a.add(newIndex, this);
        }
    }

    public int getIndex() {
        if (this.m_parent != null) {
            ArrayList<SimpleXmlElement> a = this.m_parent.m_children;
            return a.indexOf(this);
        }
        return -1;
    }

    public ArrayList<String> getChildNames() {
        ArrayList<String> a = new ArrayList<String>();
        for (SimpleXmlElement e : this.getChildren()) {
            a.add(e.getName());
        }
        return a;
    }

    public ArrayList<SimpleXmlElement> getChildren() {
        return new ArrayList<SimpleXmlElement>(this.m_children);
    }

    public ArrayList<SimpleXmlElement> getChildren(String childrenName) {
        ArrayList<SimpleXmlElement> a = new ArrayList<SimpleXmlElement>();
        for (SimpleXmlElement c : this.m_children) {
            if (!c.getName().equalsIgnoreCase(childrenName)) continue;
            a.add(c);
        }
        return a;
    }

    public ArrayList<SimpleXmlElement> getChildrenRegEx(String childNameAsRegEx) {
        ArrayList<SimpleXmlElement> selectedChildren = new ArrayList<SimpleXmlElement>();
        for (SimpleXmlElement child : this.m_children) {
            if (!child.getName().matches(childNameAsRegEx)) continue;
            selectedChildren.add(child);
        }
        return selectedChildren;
    }

    public SimpleXmlElement getChild(String name) {
        for (SimpleXmlElement c : this.m_children) {
            if (!c.getName().equalsIgnoreCase(name)) continue;
            return c;
        }
        return null;
    }

    public SimpleXmlElement getChildRegEx(String childNameAsRegEx) {
        for (SimpleXmlElement child : this.m_children) {
            if (!child.getName().matches(childNameAsRegEx)) continue;
            return child;
        }
        return null;
    }

    public String getContent() {
        return this.m_contents;
    }

    public int getLineNr() {
        return this.m_lineNr;
    }

    public Object getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    public boolean hasAttribute(String name) {
        if (this.m_ignoreCase) {
            name = name.toUpperCase();
        }
        return this.m_attributeMap.containsKey(name);
    }

    public Map<String, String> getAttributes() {
        return new HashMap<String, String>(this.m_attributeMap);
    }

    public Object getAttributeRegEx(String attributeNameAsRegEx) {
        for (String attributeName : this.m_attributeMap.keySet()) {
            if (!attributeName.matches(attributeNameAsRegEx)) continue;
            return this.getAttribute(attributeName);
        }
        return null;
    }

    public Object getAttribute(String name, Object defaultValue) {
        Object value;
        if (this.m_ignoreCase) {
            name = name.toUpperCase();
        }
        if ((value = this.getAttributeInternal(name)) == null || ("" + value).length() == 0) {
            value = defaultValue;
        }
        return value;
    }

    public Object getAttribute(String name, HashMap<Object, Object> valueSet, String defaultKey, boolean allowLiterals) {
        Object result;
        String key;
        if (this.m_ignoreCase) {
            name = name.toUpperCase();
        }
        if ((key = this.getAttributeInternal(name)) == null) {
            key = defaultKey;
        }
        if ((result = valueSet.get(key)) == null) {
            if (allowLiterals) {
                result = key;
            } else {
                throw this.invalidValue(name, key);
            }
        }
        return result;
    }

    public String getStringAttribute(String name) {
        return this.getStringAttribute(name, null);
    }

    public String getStringAttribute(String name, String defaultValue) {
        return (String)this.getAttribute(name, defaultValue);
    }

    public String getStringAttribute(String name, HashMap<Object, Object> valueSet, String defaultKey, boolean allowLiterals) {
        return (String)this.getAttribute(name, valueSet, defaultKey, allowLiterals);
    }

    public int getIntAttribute(String name) {
        return this.getIntAttribute(name, 0);
    }

    public int getIntAttribute(String name, int defaultValue) {
        String value;
        if (this.m_ignoreCase) {
            name = name.toUpperCase();
        }
        if ((value = this.getAttributeInternal(name)) == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.invalidValue(name, value);
        }
    }

    public Long getLongAttribute(String name) {
        String value = this.getAttributeInternal(name);
        if (value == null) {
            return null;
        }
        return new Long(Long.parseLong(value));
    }

    public Object getObjectAttribute(String name, Object defaultValue) throws IOException, ClassNotFoundException {
        return this.getObjectAttribute(name, defaultValue, null);
    }

    public Object getObjectAttribute(String name, Object defaultValue, ClassLoader primaryLoader) throws IOException, ClassNotFoundException {
        String base64 = this.getStringAttribute(name, "");
        if (base64.length() <= 0) {
            return defaultValue;
        }
        byte[] raw = Base64Utility.decode(base64);
        ContextFinderBasedObjectInputStream oi = new ContextFinderBasedObjectInputStream(new ByteArrayInputStream(raw), primaryLoader);
        Object o = oi.readObject();
        if (o == null) {
            o = defaultValue;
        }
        oi.close();
        return o;
    }

    public void setObjectAttribute(String name, Object o) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bout);
        out.writeObject(o);
        out.close();
        String base64 = Base64Utility.encode(bout.toByteArray()).trim();
        this.setAttribute(name, base64);
    }

    public int getIntAttribute(String name, HashMap<Object, Integer> valueSet, String defaultKey, boolean allowLiteralNumbers) {
        Integer result;
        String key;
        if (this.m_ignoreCase) {
            name = name.toUpperCase();
        }
        if ((key = this.getAttributeInternal(name)) == null) {
            key = defaultKey;
        }
        try {
            result = valueSet.get(key);
        }
        catch (ClassCastException classCastException) {
            throw this.invalidValueSet(name);
        }
        if (result == null) {
            if (!allowLiteralNumbers) {
                throw this.invalidValue(name, key);
            }
            try {
                result = Integer.valueOf(key);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidValue(name, key);
            }
        }
        return result;
    }

    public double getDoubleAttribute(String name) {
        return this.getDoubleAttribute(name, 0.0);
    }

    public double getDoubleAttribute(String name, double defaultValue) {
        String value;
        if (this.m_ignoreCase) {
            name = name.toUpperCase();
        }
        if ((value = this.getAttributeInternal(name)) == null) {
            return defaultValue;
        }
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw this.invalidValue(name, value);
        }
    }

    public double getDoubleAttribute(String name, Map<Object, Double> valueSet, String defaultKey, boolean allowLiteralNumbers) {
        Double result;
        String key;
        if (this.m_ignoreCase) {
            name = name.toUpperCase();
        }
        if ((key = this.getAttributeInternal(name)) == null) {
            key = defaultKey;
        }
        try {
            result = valueSet.get(key);
        }
        catch (ClassCastException classCastException) {
            throw this.invalidValueSet(name);
        }
        if (result == null) {
            if (!allowLiteralNumbers) {
                throw this.invalidValue(name, key);
            }
            try {
                result = Double.valueOf(key);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidValue(name, key);
            }
        }
        return result;
    }

    public boolean getBooleanAttribute(String name, String trueValue, String falseValue, boolean defaultValue) {
        String value;
        if (this.m_ignoreCase) {
            name = name.toUpperCase();
        }
        if ((value = this.getAttributeInternal(name)) == null) {
            return defaultValue;
        }
        if (value.equals(trueValue)) {
            return true;
        }
        if (value.equals(falseValue)) {
            return false;
        }
        throw this.invalidValue(name, value);
    }

    public String getName() {
        return this.m_name;
    }

    public String getTagName() {
        return this.getName();
    }

    public void parseStream(InputStream in) throws IOException {
        this.parseStream(in, 1);
    }

    public void parseStream(InputStream input, int startingLineNr) throws IOException {
        this.parseStream(input, startingLineNr, true);
    }

    public void parseStream(InputStream input, int startingLineNr, boolean autoClose) throws IOException {
        this.removeChildren();
        BufferedInputStream bin = input instanceof BufferedInputStream ? (BufferedInputStream)input : new BufferedInputStream(input);
        bin.mark(1024);
        BufferedReader encodedReader = null;
        int ch = bin.read();
        while (ch >= 0 && (ch == 10 || ch == 9 || ch == 32 || ch == 13)) {
            ch = bin.read();
        }
        if (ch == 60 && (ch = bin.read()) == 63) {
            int m;
            String xmlLine;
            int k;
            StringBuffer buf = new StringBuffer("<?");
            ch = bin.read();
            while (ch >= 0 && ch != 63) {
                buf.append((char)ch);
                ch = bin.read();
            }
            if (ch == 63) {
                buf.append((char)ch);
            }
            if ((ch = bin.read()) == 62) {
                buf.append((char)ch);
            }
            if ((k = (xmlLine = buf.toString()).indexOf("encoding")) >= 0 && (k = xmlLine.indexOf(61, k)) >= 0 && (k = xmlLine.indexOf(34, k)) >= 0 && (m = xmlLine.indexOf(34, k + 1)) >= 0) {
                String encoding = xmlLine.substring(k + 1, m);
                bin.reset();
                encodedReader = new BufferedReader(new InputStreamReader((InputStream)bin, encoding));
            }
        }
        if (encodedReader == null) {
            bin.reset();
            encodedReader = new BufferedReader(new InputStreamReader(bin));
        }
        try {
            this.parseImpl(encodedReader, 1);
        }
        finally {
            if (autoClose) {
                encodedReader.close();
            }
        }
    }

    protected void parseImpl(Reader r, int startingLineNr) throws IOException {
        char ch;
        this.m_name = null;
        this.m_contents = "";
        this.m_attributeMap = new TreeMap();
        this.m_attributeNames = new ArrayList();
        this.m_children = new ArrayList();
        this.m_charReadTooMuch = '\u0000';
        this.m_reader = r;
        this.m_parserLineNr = startingLineNr;
        while (true) {
            if ((ch = this.scanWhitespace()) != '<') {
                throw this.expectedInput("<");
            }
            ch = this.readChar();
            if (ch != '!' && ch != '?') break;
            this.skipSpecialTag(0);
        }
        this.unreadChar(ch);
        this.scanElement(this);
    }

    public void parseReader(Reader r) throws IOException {
        this.parseImpl(r, 1);
    }

    public void parseString(String string) {
        try {
            this.parseImpl(new StringReader(string), 1);
        }
        catch (IOException iOException) {}
    }

    public void parseString(String string, int offset) {
        this.parseString(string.substring(offset));
    }

    public void parseString(String string, int offset, int end) {
        this.parseString(string.substring(offset, end));
    }

    public void parseString(String string, int offset, int end, int startingLineNr) {
        string = string.substring(offset, end);
        try {
            this.parseImpl(new StringReader(string), startingLineNr);
        }
        catch (IOException iOException) {}
    }

    public void parseCharArray(char[] input, int offset, int end) {
        this.parseCharArray(input, offset, end, 1);
    }

    public void parseCharArray(char[] input, int offset, int end, int startingLineNr) {
        try {
            CharArrayReader reader = new CharArrayReader(input, offset, end);
            this.parseImpl(reader, startingLineNr);
        }
        catch (IOException iOException) {}
    }

    public SimpleXmlElement getParent() {
        return this.m_parent;
    }

    public boolean isAncestorOf(SimpleXmlElement child) {
        SimpleXmlElement e = child;
        while (e != null) {
            if (e == this) {
                return true;
            }
            e = e.getParent();
        }
        return false;
    }

    public SimpleXmlElement getRoot() {
        if (this.m_parent == null) {
            return this;
        }
        return this.m_parent.getRoot();
    }

    public void removeChild(SimpleXmlElement child) {
        this.m_children.remove(child);
        child.m_parent = null;
    }

    public void removeChildren() {
        this.m_children.clear();
    }

    public void removeChildren(String tagName) {
        Iterator<SimpleXmlElement> it = this.m_children.iterator();
        while (it.hasNext()) {
            SimpleXmlElement e = it.next();
            if (!e.getName().equalsIgnoreCase(tagName)) continue;
            it.remove();
        }
    }

    public void removeAttribute(String name) {
        if (this.m_ignoreCase) {
            name = name.toUpperCase();
        }
        this.removeAttributeInternal(name);
    }

    protected SimpleXmlElement createAnotherElement() {
        return new SimpleXmlElement(null, this.m_ignoreWhitespace, this.m_ignoreCase);
    }

    public void setContent(String content) {
        this.m_contents = content;
    }

    public void setTagName(String name) {
        this.setName(name);
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<");
        buf.append(this.getName());
        for (String key : this.m_attributeNames) {
            String val = this.getAttributeInternal(key);
            buf.append(" ");
            buf.append(String.valueOf(key) + "=\"" + val + "\"");
        }
        buf.append("]");
        return buf.toString();
    }

    public void writeDocument(Writer w, String dtdName, String encoding) throws IOException {
        this.writeDocumentImpl(w, dtdName, encoding);
    }

    public void writeDocument(OutputStream out, String dtdName, String encoding) throws IOException {
        if (encoding != null) {
            this.writeDocumentImpl(new BufferedWriter(new OutputStreamWriter(out, encoding)), dtdName, encoding);
        } else {
            this.writeDocumentImpl(new BufferedWriter(new OutputStreamWriter(out)), dtdName, encoding);
        }
    }

    protected void writeDocumentImpl(Writer w, String dtdName, String encoding) throws IOException {
        try {
            if (encoding != null) {
                w.write("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\n");
            } else {
                w.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            }
            if (dtdName != null) {
                w.write("<!DOCTYPE app SYSTEM \"" + dtdName + "\">\n");
            }
            this.write(w, "");
        }
        finally {
            w.close();
        }
    }

    protected void write(Writer writer, String prefix) throws IOException {
        if (this.m_name == null) {
            this.writeEncoded(writer, this.m_contents);
            return;
        }
        writer.write(String.valueOf(prefix) + '<');
        writer.write(this.m_name);
        if (!this.m_attributeMap.isEmpty()) {
            for (String key : this.m_attributeNames) {
                String value = this.getAttributeInternal(key);
                if (value == null) continue;
                writer.write(32);
                writer.write(key);
                writer.write(61);
                writer.write(34);
                this.writeEncoded(writer, value);
                writer.write(34);
            }
        }
        if (!this.m_children.isEmpty()) {
            writer.write(62);
            writer.write("\n");
            for (SimpleXmlElement child : this.getChildren()) {
                child.write(writer, String.valueOf(prefix) + "  ");
            }
            writer.write(String.valueOf(prefix) + '<');
            writer.write(47);
            writer.write(this.m_name);
            writer.write(62);
            writer.write("\n");
        } else if (this.m_contents != null && this.m_contents.length() > 0) {
            writer.write(62);
            this.writeEncoded(writer, this.m_contents);
            writer.write(60);
            writer.write(47);
            writer.write(this.m_name);
            writer.write(62);
            writer.write("\n");
        } else {
            writer.write(47);
            writer.write(62);
            writer.write("\n");
        }
    }

    protected void writeEncoded(Writer writer, String str) throws IOException {
        if (str == null) {
            return;
        }
        int i = 0;
        while (i < str.length()) {
            String ch = "" + str.charAt(i);
            String escaped = INVERSE_ENTITIES.get(ch);
            if (escaped != null) {
                writer.write(escaped);
            } else {
                writer.write(ch);
            }
            ++i;
        }
    }

    protected void scanIdentifier(StringBuffer result) throws IOException {
        while (true) {
            char ch;
            if (!((ch = this.readChar()) >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9' || ch == '_' || ch == '.' || ch == ':' || ch == '-' || ch > '~')) {
                this.unreadChar(ch);
                return;
            }
            result.append(ch);
        }
    }

    protected char scanWhitespace() throws IOException {
        char ch;
        block3: while (true) {
            ch = this.readChar();
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
            }
            break;
        }
        return ch;
    }

    protected char scanWhitespace(StringBuffer result) throws IOException {
        char ch;
        block4: while (true) {
            ch = this.readChar();
            switch (ch) {
                case '\t': 
                case '\n': 
                case ' ': {
                    result.append(ch);
                }
                case '\r': {
                    continue block4;
                }
            }
            break;
        }
        return ch;
    }

    protected void scanString(StringBuffer string) throws IOException {
        char delimiter = this.readChar();
        if (delimiter != '\'' && delimiter != '\"') {
            throw this.expectedInput("' or \"");
        }
        char ch;
        while ((ch = this.readChar()) != delimiter) {
            if (ch == '&') {
                this.resolveEntity(string);
                continue;
            }
            string.append(ch);
        }
        return;
    }

    protected void scanPCData(StringBuffer data) throws IOException {
        while (true) {
            char ch;
            if ((ch = this.readChar()) == '<') {
                ch = this.readChar();
                if (ch == '!') {
                    this.checkCDATA(data);
                    continue;
                }
                this.unreadChar(ch);
                return;
            }
            if (ch == '&') {
                this.resolveEntity(data);
                continue;
            }
            data.append(ch);
        }
    }

    protected boolean checkCDATA(StringBuffer buf) throws IOException {
        char ch = this.readChar();
        if (ch != '[') {
            this.unreadChar(ch);
            this.skipSpecialTag(0);
            return false;
        }
        if (!this.checkLiteral("CDATA[")) {
            this.skipSpecialTag(1);
            return false;
        }
        int delimiterCharsSkipped = 0;
        while (delimiterCharsSkipped < 3) {
            ch = this.readChar();
            switch (ch) {
                case ']': {
                    if (delimiterCharsSkipped < 2) {
                        ++delimiterCharsSkipped;
                        break;
                    }
                    buf.append(']');
                    break;
                }
                case '>': {
                    int i;
                    if (delimiterCharsSkipped < 2) {
                        i = 0;
                        while (i < delimiterCharsSkipped) {
                            buf.append(']');
                            ++i;
                        }
                        delimiterCharsSkipped = 0;
                        buf.append('>');
                        break;
                    }
                    delimiterCharsSkipped = 3;
                    break;
                }
                default: {
                    int i = 0;
                    while (i < delimiterCharsSkipped) {
                        buf.append(']');
                        ++i;
                    }
                    buf.append(ch);
                    delimiterCharsSkipped = 0;
                }
            }
        }
        return true;
    }

    protected void skipComment() throws IOException {
        int dashesToRead = 2;
        while (dashesToRead > 0) {
            char ch = this.readChar();
            if (ch == '-') {
                --dashesToRead;
                continue;
            }
            dashesToRead = 2;
        }
        if (this.readChar() != '>') {
            throw this.expectedInput(">");
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void skipSpecialTag(int bracketLevel) throws IOException {
        block11: {
            block10: {
                block9: {
                    tagLevel = 1;
                    stringDelimiter = '\u0000';
                    if (bracketLevel != 0) ** GOTO lbl41
                    ch = this.readChar();
                    if (ch != '[') break block9;
                    ++bracketLevel;
                    ** GOTO lbl41
                }
                if (ch != '-') ** GOTO lbl41
                ch = this.readChar();
                if (ch != '[') break block10;
                ++bracketLevel;
                ** GOTO lbl41
            }
            if (ch != ']') break block11;
            --bracketLevel;
            ** GOTO lbl41
        }
        if (ch != '-') ** GOTO lbl41
        this.skipComment();
        return;
lbl-1000:
        // 1 sources

        {
            ch = this.readChar();
            if (stringDelimiter == '\u0000') {
                if (ch == '\"' || ch == '\'') {
                    stringDelimiter = ch;
                } else if (bracketLevel <= 0) {
                    if (ch == '<') {
                        ++tagLevel;
                    } else if (ch == '>') {
                        --tagLevel;
                    }
                }
                if (ch == '[') {
                    ++bracketLevel;
                    continue;
                }
                if (ch != ']') continue;
                --bracketLevel;
                continue;
            }
            if (ch != stringDelimiter) continue;
            stringDelimiter = '\u0000';
lbl41:
            // 11 sources

            ** while (tagLevel > 0)
        }
lbl42:
        // 1 sources

    }

    protected boolean checkLiteral(String literal) throws IOException {
        int length = literal.length();
        int i = 0;
        while (i < length) {
            if (this.readChar() != literal.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected char readChar() throws IOException {
        if (this.m_charReadTooMuch != '\u0000') {
            char ch = this.m_charReadTooMuch;
            this.m_charReadTooMuch = '\u0000';
            return ch;
        }
        int i = this.m_reader.read();
        if (i < 0) {
            throw this.unexpectedEndOfData();
        }
        if (i == 10) {
            ++this.m_parserLineNr;
            return '\n';
        }
        return (char)i;
    }

    protected void scanElement(SimpleXmlElement elt) throws IOException {
        char ch;
        String eltName;
        StringBuffer buf;
        block24: {
            buf = new StringBuffer();
            this.scanIdentifier(buf);
            eltName = buf.toString();
            elt.setName(eltName);
            ch = this.scanWhitespace();
            while (ch != '>' && ch != '/') {
                buf.setLength(0);
                this.unreadChar(ch);
                this.scanIdentifier(buf);
                String key = buf.toString();
                ch = this.scanWhitespace();
                if (ch != '=') {
                    throw this.expectedInput("=");
                }
                this.unreadChar(this.scanWhitespace());
                buf.setLength(0);
                this.scanString(buf);
                elt.setAttribute(key, buf);
                ch = this.scanWhitespace();
            }
            if (ch == '/') {
                ch = this.readChar();
                if (ch != '>') {
                    throw this.expectedInput(">");
                }
                return;
            }
            buf.setLength(0);
            ch = this.scanWhitespace(buf);
            if (ch != '<') {
                this.unreadChar(ch);
                this.scanPCData(buf);
            } else {
                while ((ch = this.readChar()) == '!') {
                    if (this.checkCDATA(buf)) {
                        this.scanPCData(buf);
                    } else {
                        ch = this.scanWhitespace(buf);
                        if (ch == '<') continue;
                        this.unreadChar(ch);
                        this.scanPCData(buf);
                    }
                    break block24;
                }
                if (ch != '/' || this.m_ignoreWhitespace) {
                    buf.setLength(0);
                }
                if (ch == '/') {
                    this.unreadChar(ch);
                }
            }
        }
        if (buf.length() == 0) {
            while (ch != '/') {
                if (ch == '!') {
                    ch = this.readChar();
                    if (ch != '-') {
                        throw this.expectedInput("Comment or Element");
                    }
                    ch = this.readChar();
                    if (ch != '-') {
                        throw this.expectedInput("Comment or Element");
                    }
                    this.skipComment();
                } else {
                    this.unreadChar(ch);
                    SimpleXmlElement child = this.createAnotherElement();
                    this.scanElement(child);
                    elt.addChild(child);
                }
                ch = this.scanWhitespace();
                if (ch != '<') {
                    throw this.expectedInput("<");
                }
                ch = this.readChar();
            }
            this.unreadChar(ch);
        } else if (this.m_ignoreWhitespace) {
            elt.setContent(buf.toString().trim());
        } else {
            elt.setContent(buf.toString());
        }
        ch = this.readChar();
        if (ch != '/') {
            throw this.expectedInput("/");
        }
        this.unreadChar(this.scanWhitespace());
        if (!this.checkLiteral(eltName)) {
            throw this.expectedInput(eltName);
        }
        if (this.scanWhitespace() != '>') {
            throw this.expectedInput(">");
        }
    }

    protected void resolveEntity(StringBuffer buf) throws IOException {
        char ch = '\u0000';
        StringBuffer keyBuf = new StringBuffer();
        while ((ch = this.readChar()) != ';') {
            keyBuf.append(ch);
        }
        String key = keyBuf.toString();
        if (key.charAt(0) == '#') {
            try {
                ch = key.charAt(1) == 'x' ? (char)Integer.parseInt(key.substring(2), 16) : (char)Integer.parseInt(key.substring(1), 10);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.unknownEntity(key);
            }
            buf.append(ch);
        } else {
            String value = ENTITIES.get(key);
            if (value == null) {
                System.out.println(String.valueOf(this.getClass().getSimpleName()) + ": unknownEntity " + key);
                value = "?";
            }
            buf.append(value);
        }
    }

    protected void unreadChar(char ch) {
        this.m_charReadTooMuch = ch;
    }

    protected IllegalArgumentException invalidValueSet(String name) {
        String msg = "Invalid value set (entity name = \"" + name + "\")";
        return new IllegalArgumentException(String.valueOf(this.getName()) + ": " + msg);
    }

    protected IllegalArgumentException invalidValue(String name, String value) {
        String msg = "Attribute \"" + name + "\" does not contain a valid " + "value (\"" + value + "\")";
        return new IllegalArgumentException(String.valueOf(this.getName()) + ": " + msg);
    }

    protected IOException unexpectedEndOfData() {
        String msg = "Unexpected end of data reached";
        return new IOException(String.valueOf(this.getName()) + ": " + msg);
    }

    protected IOException syntaxError(String context) {
        String msg = "Syntax error while parsing " + context;
        return new IOException(String.valueOf(this.getName()) + ": " + msg);
    }

    protected IOException expectedInput(String charSet) {
        String msg = "Expected: " + charSet;
        return new IOException(String.valueOf(this.getName()) + ": " + msg);
    }

    protected IOException unknownEntity(String name) {
        String msg = "Unknown or invalid entity: &" + name + ";";
        return new IOException(String.valueOf(this.getName()) + ": " + msg);
    }

    private void setAttributeInternal(String name, String val) {
        if (!this.m_attributeNames.contains(name)) {
            this.m_attributeNames.add(name);
        }
        this.m_attributeMap.put(name, val);
    }

    private String getAttributeInternal(String name) {
        return this.m_attributeMap.get(name);
    }

    private void removeAttributeInternal(String name) {
        this.m_attributeNames.remove(name);
        this.m_attributeMap.remove(name);
    }
}

