/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.jdt;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class JavaFileInputReader {
    public static final int TYPE_NONE = -1;
    public static final int TYPE_MULTILINE_COMMENT = 1;
    public static final int TYPE_SINGLELINE_COMMENT = 2;
    private int m_type = -1;
    private int m_counter = 0;
    private char[] m_buf = new char[2];
    private String m_startMulti = "/*";
    private String m_endMulti = "*/";
    private String m_startSingle = "//";
    private String m_endSingle = "\n";
    private InputStream m_inputStream;

    public JavaFileInputReader(IFile file) throws CoreException {
        this.m_inputStream = file.getContents();
    }

    public int read() throws IOException {
        int in = this.m_inputStream.read();
        this.m_buf[this.m_counter % 2] = (char)in;
        ++this.m_counter;
        this.m_type = this.checkComment();
        return in;
    }

    public boolean isCommentBlock() {
        return this.m_type == 1 || this.m_type == 2;
    }

    public void close() throws IOException {
        this.m_inputStream.close();
    }

    private int checkComment() {
        String inSt = new String(this.m_buf);
        if (inSt.equals(this.m_startMulti)) {
            return 1;
        }
        if (inSt.equals(this.m_endMulti)) {
            return -1;
        }
        if (inSt.equals(this.m_startSingle)) {
            return 2;
        }
        if (inSt.contains(this.m_endSingle)) {
            return -1;
        }
        return -1;
    }
}

