/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.model;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.util.concurrent.UiRunnable;
import org.eclipse.swt.widgets.Shell;

public class NlsResources {
    private static NlsResources s_instance;
    private HashMap<String, List<P_ResourceListener>> m_listeners = new HashMap();
    private P_InternalResourceListener listener = new P_InternalResourceListener();

    private NlsResources() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.listener);
    }

    protected void finalize() throws Throwable {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.listener);
        super.finalize();
    }

    public static final NlsResources getInstance() {
        if (s_instance == null) {
            s_instance = new NlsResources();
        }
        return s_instance;
    }

    public void addResourceListener(IResource resource, IResourceChangeListener listener) {
        this.addResourceListener(resource, listener, null);
    }

    public void addResourceListener(IResource resource, IResourceChangeListener listener, Shell shell) {
        List<P_ResourceListener> list = this.getOrCreateFor(resource);
        list.add(new P_ResourceListener(listener, shell));
    }

    public void removeResourceListener(IResource resource, IResourceChangeListener listener) {
        List<P_ResourceListener> list = this.getOrCreateFor(resource);
        list.remove(new WeakReference<IResourceChangeListener>(listener));
    }

    private List<P_ResourceListener> getOrCreateFor(IResource resource) {
        List<P_ResourceListener> list = this.m_listeners.get(resource);
        if (list == null) {
            list = new ArrayList<P_ResourceListener>(2);
            this.m_listeners.put(resource.toString(), list);
        }
        return list;
    }

    private class P_InternalResourceListener
    implements IResourceChangeListener {
        private P_InternalResourceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) {
                            IResource resource = delta.getResource();
                            P_InternalResourceListener.this.asyncStructureChanged(resource, delta);
                            return true;
                        }
                    });
                }
            }
            catch (CoreException e) {
                NlsCore.logWarning(e);
            }
        }

        public void asyncStructureChanged(IResource resource, IResourceDelta delta) {
            List list = (List)NlsResources.this.m_listeners.get(resource.toString());
            if (list != null) {
                ArrayList<P_ResourceListener> toRemove = new ArrayList<P_ResourceListener>(2);
                for (P_ResourceListener reference : list) {
                    IResourceChangeListener listener = reference.getListener();
                    if (listener == null) {
                        toRemove.add(reference);
                        continue;
                    }
                    P_ResourceChangedEvent event = new P_ResourceChangedEvent(resource, delta, -1);
                    if (reference.getShell() != null && !reference.getShell().isDisposed()) {
                        reference.getShell().getDisplay().asyncExec((Runnable)new UiRunnable(new Object[]{listener, event}){

                            @Override
                            public void run() {
                                try {
                                    ((IResourceChangeListener)this.p_args[0]).resourceChanged((IResourceChangeEvent)this.p_args[1]);
                                }
                                catch (Throwable e) {
                                    NlsCore.logError("listener throwed an Exception", e);
                                }
                            }
                        });
                    }
                    try {
                        listener.resourceChanged((IResourceChangeEvent)event);
                    }
                    catch (Throwable e) {
                        NlsCore.logError("listener throwed an Exception", e);
                    }
                }
                for (P_ResourceListener reference : toRemove) {
                    list.remove(reference);
                }
            }
        }
    }

    private class P_ResourceChangedEvent
    implements IResourceChangeEvent {
        private IResource m_resource;
        private IResourceDelta m_delta;
        private int m_type;

        public P_ResourceChangedEvent(IResource resource, IResourceDelta delta, int type) {
            this.m_resource = resource;
            this.m_delta = delta;
            this.m_type = type;
        }

        public IMarkerDelta[] findMarkerDeltas(String type, boolean includeSubtypes) {
            return null;
        }

        public int getBuildKind() {
            return this.m_delta.getKind();
        }

        public IResourceDelta getDelta() {
            return this.m_delta;
        }

        public IResource getResource() {
            return this.m_resource;
        }

        public Object getSource() {
            return NlsResources.this;
        }

        public int getType() {
            return this.m_type;
        }
    }

    private class P_ResourceListener {
        private Shell m_shell;
        private WeakReference<IResourceChangeListener> m_listener;

        public P_ResourceListener(IResourceChangeListener listener, Shell shell) {
            this.m_shell = shell;
            this.m_listener = new WeakReference<IResourceChangeListener>(listener);
        }

        IResourceChangeListener getListener() {
            return (IResourceChangeListener)this.m_listener.get();
        }

        Shell getShell() {
            return this.m_shell;
        }
    }
}

