/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.model.workspace.manifest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.model.workspace.manifest.ManifestElement;
import org.eclipse.scout.nls.sdk.internal.model.workspace.manifest.ManifestEntry;

public abstract class AbstractManifest {
    List<String> m_entryOrder = new LinkedList<String>();
    HashMap<String, ManifestEntry> m_parsedEntries = new HashMap();

    public AbstractManifest(String symbolicBundleName, InputStream stream) {
        try {
            this.parseManifest(stream);
        }
        catch (CoreException e) {
            NlsCore.logError("could not parse manifest of bundle " + symbolicBundleName);
            NlsCore.logWarning(e);
        }
        catch (IOException iOException) {
            NlsCore.logError("could not parse manifest of bundle " + symbolicBundleName);
        }
    }

    protected void parseManifest(InputStream input) throws CoreException, IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        String line = reader.readLine();
        while (line != null) {
            if (line.startsWith("#")) {
                line = reader.readLine();
                continue;
            }
            if (line.equals("")) {
                line = reader.readLine();
                continue;
            }
            String[] args = line.split(": ", 2);
            if (args.length != 2) {
                System.err.println("could not parse manifest entry: " + line);
                line = reader.readLine();
                continue;
            }
            String key = args[0].trim();
            String value = args[1].trim();
            line = reader.readLine();
            while (line != null && line.startsWith(" ")) {
                value = String.valueOf(value) + line.trim();
                line = reader.readLine();
            }
            ManifestEntry entry = new ManifestEntry(key);
            entry.parseElements(value);
            this.m_parsedEntries.put(key, entry);
            this.m_entryOrder.add(key);
        }
    }

    public void addElement(ManifestEntry newEntry) {
        ManifestEntry entry = this.m_parsedEntries.get(newEntry.getKey());
        if (entry != null) {
            for (ManifestElement element : newEntry.getElements()) {
                entry.addElement(element);
            }
        } else {
            this.m_parsedEntries.put(newEntry.getKey(), newEntry);
            this.m_entryOrder.add(newEntry.getKey());
        }
    }

    public boolean hasElement(String name) {
        return this.m_parsedEntries.containsKey(name);
    }

    public ManifestEntry getAttribute(String property) {
        ManifestEntry value = this.m_parsedEntries.get(property);
        return value;
    }

    public abstract boolean isWriteable();

    public abstract IStatus store(IProgressMonitor var1);
}

