/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.search;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.search.DefaultNlsKeySearchRequestor;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.search.ui.text.Match;

public class NlsFindReferencesJob
extends Job {
    private final INlsProject m_project;
    private IType m_nlsType;
    private DefaultNlsKeySearchRequestor m_searchRequstor;

    public NlsFindReferencesJob(INlsProject project, String text) {
        super(text);
        this.m_project = project;
        this.m_nlsType = project.getNlsType().getType();
        this.m_searchRequstor = new DefaultNlsKeySearchRequestor(this.getProject());
    }

    public IStatus run(IProgressMonitor monitor) {
        SearchEngine.getDefaultSearchParticipant();
        LinkedList<IJavaProject> jProjects = new LinkedList<IJavaProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        try {
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature") && project.hasNature("org.eclipse.pde.PluginNature")) {
                    jProjects.add(JavaCore.create((IProject)project));
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {
            NlsCore.logError("Could not create java projects for nls search.");
        }
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])jProjects.toArray(new IJavaElement[jProjects.size()]), (boolean)true);
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)this.getProject().getNlsType().getType(), (int)2);
        SearchEngine engine = new SearchEngine();
        try {
            engine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)this.m_searchRequstor, monitor);
        }
        catch (CoreException e) {
            NlsCore.logError("NLS search failed.", e);
        }
        return Status.OK_STATUS;
    }

    public Map<String, List<Match>> getMatches() {
        if (this.getState() != 0) {
            throw new IllegalAccessError("job has not finished yet.");
        }
        return this.m_searchRequstor.getAllMatches();
    }

    public Match[] getMatches(String key) {
        if (this.getState() != 0) {
            throw new IllegalAccessError("job has not finished yet.");
        }
        return this.m_searchRequstor.getMatches(key);
    }

    public INlsProject getProject() {
        return this.m_project;
    }

    public DefaultNlsKeySearchRequestor getSearchRequstor() {
        return this.m_searchRequstor;
    }

    public IType getNlsType() {
        return this.m_nlsType;
    }
}

