/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.dialog.importexport;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.importexport.NlsExportDialogModel;
import org.eclipse.scout.nls.sdk.internal.ui.fields.FileChooserField;
import org.eclipse.scout.nls.sdk.internal.ui.fields.IInputChangedListener;
import org.eclipse.scout.nls.sdk.util.concurrent.UiRunnable;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class NlsExportDialog
extends TitleAreaDialog {
    private Composite m_rootArea;
    private FileChooserField m_selectCsv;
    private NlsExportDialogModel m_model;
    private Button m_selectedOnly;

    public NlsExportDialog(Shell parentShell, NlsExportDialogModel desc) {
        super(parentShell);
        this.m_model = desc;
        this.m_model.addPropertyChangeListener(new P_PropertyChangedListener());
    }

    public NlsExportDialogModel getModel() {
        return this.m_model;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Import NLS Entries");
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.revalidate();
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        this.m_rootArea = new Composite(parent, 0);
        this.m_selectCsv = new FileChooserField(this.m_rootArea, "Select XLS-File to export the data to..");
        this.m_selectCsv.setButtonText("Browse...");
        this.m_selectCsv.setExtendsionFilter(new String[]{"*.xls"});
        this.m_selectCsv.setLabelText("XLS-File:");
        this.m_selectCsv.addInputChangedListener(24, new IInputChangedListener<String>(){

            @Override
            public void inputChanged(String input) {
                NlsExportDialog.this.m_model.setExportFile(input);
            }
        });
        this.attachGridData((Control)this.m_selectCsv);
        this.m_selectedOnly = new Button(this.m_rootArea, 32);
        this.m_selectedOnly.setText("Export only selected Items");
        this.m_selectedOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NlsExportDialog.this.m_model.setExportSelectedItems(NlsExportDialog.this.m_selectedOnly.getSelection());
            }
        });
        this.m_rootArea.setLayout((Layout)new GridLayout(1, true));
        return this.m_rootArea;
    }

    private void attachGridData(Control c) {
        GridData d = new GridData();
        d.grabExcessHorizontalSpace = true;
        d.horizontalAlignment = 4;
        c.setLayoutData((Object)d);
    }

    private void revalidate() {
        boolean valid = false;
        if (this.m_model.getExportFile() == null || this.m_model.getExportFile().equals("")) {
            this.setMessage("The export file must be set.", 2);
        } else {
            valid = true;
            this.setMessage(null);
        }
        this.m_selectedOnly.setEnabled(this.m_model.getSelectedEntries() != null);
        this.getButton(0).setEnabled(valid);
    }

    private class P_PropertyChangedListener
    implements PropertyChangeListener {
        private P_PropertyChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (NlsExportDialog.this.getContents() != null && !NlsExportDialog.this.getContents().isDisposed()) {
                NlsExportDialog.this.getContents().getDisplay().asyncExec((Runnable)new UiRunnable(new Object[]{evt}){

                    @Override
                    public void run() {
                        P_PropertyChangedListener.this.syncPropertyChange((PropertyChangeEvent)this.p_args[0]);
                    }
                });
            }
        }

        private void syncPropertyChange(PropertyChangeEvent evt) {
            NlsExportDialog.this.revalidate();
        }
    }
}

