/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.dialog.language;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.scout.nls.sdk.internal.jdt.INlsFolder;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.language.CountrySmartFieldModel;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.language.LanguageSmartFieldModel;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.language.TranslationFileNewModel;
import org.eclipse.scout.nls.sdk.internal.ui.smartfield.ISmartFieldListener;
import org.eclipse.scout.nls.sdk.internal.ui.smartfield.SmartField;
import org.eclipse.scout.nls.sdk.internal.ui.wizard.TranslationLocationSmartFieldModel;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TranslationFileNewDialog
extends TitleAreaDialog {
    private SmartField m_languageChooser;
    private Composite m_rootArea;
    private SmartField m_folderSelection;
    private final TranslationFileNewModel m_model;
    private SmartField m_languageCountryChooser;

    public TranslationFileNewDialog(Shell parentShell, TranslationFileNewModel model) {
        super(parentShell);
        this.m_model = model;
        this.m_model.addPropertyChangeListener(new P_ModelPropertyListener());
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.revalidate();
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        this.m_rootArea = new Composite(parent, 0);
        this.m_languageChooser = new SmartField(this.m_rootArea, 0);
        this.m_languageChooser.setLabel("Language");
        this.m_languageChooser.setSmartFieldModel(new LanguageSmartFieldModel());
        this.m_languageChooser.addSmartFieldListener(new ISmartFieldListener(){

            @Override
            public void itemSelected(Object item) {
                String languageIso = null;
                if (item != null) {
                    languageIso = ((Locale)item).getLanguage();
                }
                TranslationFileNewDialog.this.m_model.setLanguageIso(languageIso);
            }
        });
        this.m_languageCountryChooser = new SmartField(this.m_rootArea, 0);
        this.m_languageCountryChooser.setLabel("Country");
        this.m_languageCountryChooser.setSmartFieldModel(new CountrySmartFieldModel());
        this.m_languageCountryChooser.addSmartFieldListener(new ISmartFieldListener(){

            @Override
            public void itemSelected(Object item) {
                String countryIso = null;
                if (item != null) {
                    countryIso = ((Locale)item).getCountry();
                }
                TranslationFileNewDialog.this.m_model.setCountryIso(countryIso);
            }
        });
        this.attachGridData((Control)this.m_languageCountryChooser);
        this.m_folderSelection = new SmartField(this.m_rootArea, 0);
        this.m_folderSelection.setLabel("Location");
        this.m_folderSelection.setSmartFieldModel(new TranslationLocationSmartFieldModel(this.m_model.getProject(), this.m_model.getPath()));
        this.m_folderSelection.addSmartFieldListener(new ISmartFieldListener(){

            @Override
            public void itemSelected(Object item) {
                TranslationFileNewDialog.this.m_model.setFolder((INlsFolder)item);
                TranslationFileNewDialog.this.revalidate();
            }
        });
        this.attachGridData((Control)this.m_folderSelection);
        this.m_rootArea.setLayout((Layout)new GridLayout(1, true));
        GridData data = new GridData(300, -1);
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.m_languageChooser.setLayoutData(data);
        return this.m_rootArea;
    }

    private void revalidate() {
        String variant;
        boolean valid = false;
        String langIso = this.m_model.getLanguageIso();
        if (langIso == null) {
            this.setMessage("Specify a language to add to the project.", 2);
            return;
        }
        String countryIso = this.m_model.getCountryIso();
        if (countryIso == null) {
            countryIso = "";
        }
        if ((variant = this.m_model.getCountryIso()) == null) {
            variant = "";
        }
        Language lang = new Language(new Locale(langIso, countryIso, variant));
        if (this.m_model.getNlsProject().containsLanguage(lang)) {
            this.setMessage("Language already exists.", 2);
        } else if (this.m_model.getFolder() == null) {
            this.setMessage("Folder to place the translation file not found.", 2);
        } else {
            this.setMessage(null);
            valid = true;
        }
        this.getButton(0).setEnabled(valid);
    }

    private void attachGridData(Control c) {
        GridData d = new GridData();
        d.grabExcessHorizontalSpace = true;
        d.horizontalAlignment = 4;
        c.setLayoutData((Object)d);
    }

    protected void handlePropertyChanged(String propertyName, Object oldVal, Object newVal) {
        this.revalidate();
    }

    private class P_ModelPropertyListener
    implements PropertyChangeListener {
        private P_ModelPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TranslationFileNewDialog.this.handlePropertyChanged(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }
}

