/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.dialog.translationfile.directorychooser;

import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.nlsDirChooser.AbstractNlsTreeItem;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.translationfile.directorychooser.CompareableFolder;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.translationfile.directorychooser.CompareableProject;
import org.eclipse.swt.graphics.Image;

public class NlsTranlationFolderChooserDialogModel
implements ITreeContentProvider,
ILabelProvider {
    private TreeSet<AbstractNlsTreeItem> m_rootFolders;
    private List<IJavaProject> m_projects;

    public NlsTranlationFolderChooserDialogModel(List<IProject> projects) {
        try {
            this.m_projects = new LinkedList<IJavaProject>();
            for (IProject iProject : projects) {
                if (!iProject.hasNature("org.eclipse.pde.PluginNature") || !iProject.hasNature("org.eclipse.jdt.core.javanature") || !iProject.isOpen()) continue;
                this.m_projects.add(JavaCore.create((IProject)iProject));
            }
            this.m_rootFolders = new TreeSet();
            for (IJavaProject iJavaProject : this.m_projects) {
                CompareableProject comp = new CompareableProject(iJavaProject.getProject());
                this.m_rootFolders.add(comp);
                this.load(comp);
            }
        }
        catch (CoreException coreException) {
            NlsCore.logWarning(coreException);
        }
    }

    private void load(CompareableProject project) throws CoreException {
        IResource[] resources;
        IResource[] iResourceArray = resources = project.getProject().members();
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            AbstractNlsTreeItem item = this.isRelevant(resource);
            if (item != null) {
                project.addChild(item);
            }
            ++n2;
        }
    }

    private List<AbstractNlsTreeItem> getSubfolders(CompareableFolder path) throws CoreException {
        LinkedList<AbstractNlsTreeItem> paths = new LinkedList<AbstractNlsTreeItem>();
        if (path.getFolder().exists()) {
            IResource[] resources;
            IResource[] iResourceArray = resources = path.getFolder().members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                AbstractNlsTreeItem item = this.isRelevant(resource);
                if (item != null) {
                    paths.add(item);
                }
                ++n2;
            }
        }
        return paths;
    }

    private AbstractNlsTreeItem isRelevant(IResource resource) throws CoreException {
        if (resource instanceof IFolder) {
            IJavaProject project = JavaCore.create((IProject)resource.getProject());
            IFolder folder = (IFolder)resource;
            String outputFolder = project.getOutputLocation().toString().replace(project.getProject().getName(), "").replace("/", "");
            if (outputFolder.equals(folder.getProjectRelativePath().segment(0))) {
                return null;
            }
            if (folder.getProjectRelativePath().segment(0).equals("META-INF")) {
                return null;
            }
            return new CompareableFolder(folder);
        }
        return null;
    }

    private void ensureLoaded(CompareableFolder path) {
        if (!path.isLoaded()) {
            try {
                List<AbstractNlsTreeItem> children = this.getSubfolders(path);
                for (AbstractNlsTreeItem newPath : children) {
                    path.addChild(newPath);
                }
                path.setLoaded(true);
            }
            catch (CoreException e) {
                NlsCore.logWarning(e);
            }
        }
    }

    public Object[] getChildren(Object parentElement) {
        return ((AbstractNlsTreeItem)parentElement).getChildren().toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof CompareableProject) {
            return ((CompareableProject)element).hasChildren();
        }
        CompareableFolder path = (CompareableFolder)element;
        this.ensureLoaded(path);
        return path.getChildren().size() > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.m_rootFolders.toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getImage(Object element) {
        return ((AbstractNlsTreeItem)element).getImage();
    }

    public String getText(Object element) {
        return ((AbstractNlsTreeItem)element).getText();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

