/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.editor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.nls.sdk.ui.IStructuredInputValidator;

public class NlsTableInputValidator
implements IStructuredInputValidator {
    private final INlsProject m_project;
    private String m_regexp = "\\b[A-Za-z][a-zA-Z0-9_]{0,200}\\b";

    public NlsTableInputValidator(INlsProject project) {
        this.m_project = project;
    }

    @Override
    public IStatus validate(String input, int column) {
        switch (column) {
            case 1: {
                if (!input.matches(this.m_regexp)) {
                    return new Status(4, "org.eclipse.scout.nls.sdk", 32, "Ensure input is a valid java field name.", null);
                }
                if (this.m_project.getEntry(input) == null) break;
                return new Status(4, "org.eclipse.scout.nls.sdk", 32, "A key " + input + " already exists!", null);
            }
        }
        return Status.OK_STATUS;
    }
}

