/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.ui.action;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.nls.sdk.NlsCore;
import org.eclipse.scout.nls.sdk.internal.ui.dialog.NlsEntryNewDialog;
import org.eclipse.scout.nls.sdk.model.workspace.NlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.nls.sdk.ui.action.AbstractWorkspaceAction;
import org.eclipse.swt.widgets.Display;

public class NlsEntryNewAction
extends AbstractWorkspaceAction {
    private NlsEntry m_entry;
    private final INlsProject m_project;
    private NlsEntry m_initialEntry;

    public NlsEntryNewAction(boolean interactWithUi, INlsProject project) {
        this(null, interactWithUi, project);
    }

    public NlsEntryNewAction(NlsEntry entry, boolean interactWithUi, INlsProject project) {
        super("New Entry...", interactWithUi);
        this.m_initialEntry = entry;
        this.m_project = project;
        this.setImageDescriptor(NlsCore.getImageDescriptor("text_add"));
    }

    @Override
    protected boolean interactWithUi() {
        this.m_entry = this.m_initialEntry == null ? new NlsEntry("", this.m_project) : this.m_initialEntry;
        NlsEntryNewDialog dialog = new NlsEntryNewDialog(Display.getDefault().getActiveShell(), "New Entry", this.m_entry, this.m_project);
        this.m_entry = dialog.show();
        return this.m_entry != null;
    }

    @Override
    protected void execute(IProgressMonitor monitor) {
        if (this.getEntry() != null) {
            this.m_project.updateRow(this.getEntry(), monitor);
        }
    }

    public NlsEntry getEntry() {
        return this.m_entry;
    }
}

