/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client;

import java.beans.PropertyChangeListener;
import java.security.Principal;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.nls.DynamicNls;
import org.eclipse.scout.commons.prefs.UserScope;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.IMemoryPolicy;
import org.eclipse.scout.rt.client.LargeMemoryPolicy;
import org.eclipse.scout.rt.client.MediumMemoryPolicy;
import org.eclipse.scout.rt.client.SmallMemoryPolicy;
import org.eclipse.scout.rt.client.services.common.clientnotification.ClientNotificationConsumerEvent;
import org.eclipse.scout.rt.client.services.common.clientnotification.IClientNotificationConsumerListener;
import org.eclipse.scout.rt.client.services.common.clientnotification.IClientNotificationConsumerService;
import org.eclipse.scout.rt.client.servicetunnel.IServiceTunnel;
import org.eclipse.scout.rt.client.ui.DataChangeListener;
import org.eclipse.scout.rt.client.ui.IIconLocator;
import org.eclipse.scout.rt.client.ui.IconLocator;
import org.eclipse.scout.rt.client.ui.desktop.DesktopListener;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.internal.VirtualDesktop;
import org.eclipse.scout.rt.shared.OfflineState;
import org.eclipse.scout.rt.shared.services.common.context.SharedContextChangedNotification;
import org.eclipse.scout.rt.shared.services.common.context.SharedVariableMap;
import org.eclipse.scout.rt.shared.services.common.security.ILogoutService;
import org.eclipse.scout.rt.shared.services.common.security.SimplePrincipal;
import org.eclipse.scout.service.SERVICES;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public abstract class AbstractClientSession
implements IClientSession {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractClientSession.class);
    private Bundle m_bundle;
    private final Object m_stateLock;
    private boolean m_active;
    private Throwable m_loadError;
    private int m_exitCode = IApplication.EXIT_OK;
    private IDesktop m_desktop;
    private VirtualDesktop m_virtualDesktop;
    private IServiceTunnel m_serviceTunnel;
    private Subject m_offlineSubject;
    private final SharedVariableMap m_sharedVariableMap;
    private boolean m_singleThreadSession;
    private String m_webSessionId;
    private IMemoryPolicy m_memoryPolicy;
    private IIconLocator m_iconLocator;
    private final HashMap<String, Object> m_clientSessionData = new HashMap();

    public AbstractClientSession(boolean autoInitConfig) {
        this.m_stateLock = new Object();
        this.m_sharedVariableMap = new SharedVariableMap();
        if (autoInitConfig) {
            this.initConfig();
        }
    }

    @Deprecated
    protected boolean getConfiguredWebSession() {
        return this.getConfiguredSingleThreadSession();
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=100.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredSingleThreadSession() {
        return false;
    }

    @Override
    public String getUserId() {
        return this.getSharedContextVariable("userId", String.class);
    }

    @Override
    public DynamicNls getNlsTexts() {
        return null;
    }

    @Override
    public Subject getOfflineSubject() {
        return this.m_offlineSubject;
    }

    protected void setOfflineSubject(Subject offlineSubject) {
        this.m_offlineSubject = offlineSubject;
    }

    @Override
    public Bundle getBundle() {
        return this.m_bundle;
    }

    @Override
    public boolean isActive() {
        return this.m_active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setActive(boolean b) {
        Object object = this.m_stateLock;
        synchronized (object) {
            this.m_active = b;
            this.m_stateLock.notifyAll();
        }
    }

    @Override
    public boolean isLoaded() {
        return this.m_active;
    }

    @Override
    public Map<String, Object> getSharedVariableMap() {
        return Collections.unmodifiableMap(this.m_sharedVariableMap);
    }

    protected <T> T getSharedContextVariable(String name, Class<T> type) {
        Object o = this.m_sharedVariableMap.get((Object)name);
        return (T)TypeCastUtility.castValue((Object)o, type);
    }

    @Override
    public final Throwable getLoadError() {
        return this.m_loadError;
    }

    @Override
    public final Object getStateLock() {
        return this.m_stateLock;
    }

    protected void initConfig() {
        this.m_singleThreadSession = this.getConfiguredWebSession();
        this.m_virtualDesktop = new VirtualDesktop();
        this.setMemoryPolicy(new LargeMemoryPolicy());
        IClientNotificationConsumerService clientNotificationConsumerService = (IClientNotificationConsumerService)SERVICES.getService(IClientNotificationConsumerService.class);
        if (clientNotificationConsumerService != null) {
            clientNotificationConsumerService.addClientNotificationConsumerListener(this, new IClientNotificationConsumerListener(){

                @Override
                public void handleEvent(final ClientNotificationConsumerEvent e, boolean sync) {
                    if (e.getClientNotification().getClass() == SharedContextChangedNotification.class) {
                        if (sync) {
                            try {
                                AbstractClientSession.this.updateSharedVariableMap(((SharedContextChangedNotification)e.getClientNotification()).getSharedVariableMap());
                            }
                            catch (Throwable t) {
                                LOG.error("update of shared contex", t);
                            }
                        } else {
                            new ClientSyncJob("Update shared context", ClientSyncJob.getCurrentSession()){

                                @Override
                                protected void runVoid(IProgressMonitor monitor) throws Throwable {
                                    AbstractClientSession.this.updateSharedVariableMap(((SharedContextChangedNotification)e.getClientNotification()).getSharedVariableMap());
                                }
                            }.schedule();
                        }
                    }
                }
            });
        }
    }

    private void updateSharedVariableMap(SharedVariableMap newMap) {
        this.m_sharedVariableMap.updateInternal(newMap);
    }

    @Override
    public final void startSession(Bundle bundle) {
        this.m_bundle = bundle;
        if (this.isActive()) {
            throw new IllegalStateException("session is active");
        }
        try {
            String policy = bundle.getBundleContext().getProperty("org.eclipse.scout.memory");
            if ("small".equals(policy)) {
                this.setMemoryPolicy(new SmallMemoryPolicy());
            } else if ("medium".equals(policy)) {
                this.setMemoryPolicy(new MediumMemoryPolicy());
            }
            this.m_iconLocator = this.createIconLocator();
            this.execLoadSession();
            this.setActive(true);
        }
        catch (Throwable t) {
            this.m_loadError = t;
            LOG.error("load session", t);
        }
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execLoadSession() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execStoreSession() throws ProcessingException {
    }

    @Override
    public IDesktop getVirtualDesktop() {
        return this.m_desktop != null ? this.m_desktop : this.m_virtualDesktop;
    }

    @Override
    public IDesktop getDesktop() {
        return this.m_desktop;
    }

    @Override
    public void setDesktop(IDesktop a) throws ProcessingException {
        if (a == null) {
            throw new IllegalArgumentException("argument must not be null");
        }
        if (this.m_desktop != null) {
            throw new IllegalStateException("desktop is active");
        }
        this.m_desktop = a;
        if (this.m_desktop != null) {
            if (this.m_virtualDesktop != null) {
                EventListener listener;
                int n;
                int n2;
                EventListener[] eventListenerArray;
                EventListenerList list;
                DesktopListener[] desktopListenerArray = this.m_virtualDesktop.getDesktopListeners();
                int n3 = desktopListenerArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    DesktopListener desktopListener = desktopListenerArray[n4];
                    this.m_desktop.addDesktopListener(desktopListener);
                    ++n4;
                }
                for (Map.Entry<String, EventListenerList> entry : this.m_virtualDesktop.getPropertyChangeListenerMap().entrySet()) {
                    String propName = entry.getKey();
                    list = entry.getValue();
                    if (propName == null) {
                        eventListenerArray = (PropertyChangeListener[])list.getListeners(PropertyChangeListener.class);
                        n2 = eventListenerArray.length;
                        n = 0;
                        while (n < n2) {
                            listener = eventListenerArray[n];
                            this.m_desktop.addPropertyChangeListener((PropertyChangeListener)listener);
                            ++n;
                        }
                        continue;
                    }
                    eventListenerArray = (PropertyChangeListener[])list.getListeners(PropertyChangeListener.class);
                    n2 = eventListenerArray.length;
                    n = 0;
                    while (n < n2) {
                        listener = eventListenerArray[n];
                        this.m_desktop.addPropertyChangeListener(propName, (PropertyChangeListener)listener);
                        ++n;
                    }
                }
                for (Map.Entry<Object, EventListenerList> entry : this.m_virtualDesktop.getDataChangeListenerMap().entrySet()) {
                    Object dataType = entry.getKey();
                    list = entry.getValue();
                    if (dataType == null) {
                        eventListenerArray = (DataChangeListener[])list.getListeners(DataChangeListener.class);
                        n2 = eventListenerArray.length;
                        n = 0;
                        while (n < n2) {
                            listener = eventListenerArray[n];
                            this.m_desktop.addDataChangeListener((DataChangeListener)listener, new Object[0]);
                            ++n;
                        }
                        continue;
                    }
                    eventListenerArray = (DataChangeListener[])list.getListeners(DataChangeListener.class);
                    n2 = eventListenerArray.length;
                    n = 0;
                    while (n < n2) {
                        listener = eventListenerArray[n];
                        this.m_desktop.addDataChangeListener((DataChangeListener)listener, dataType);
                        ++n;
                    }
                }
                this.m_virtualDesktop = null;
            }
            this.m_desktop.initDesktop();
        } else {
            this.m_virtualDesktop = new VirtualDesktop();
        }
    }

    @Override
    public void stopSession() {
        this.stopSession(IApplication.EXIT_OK);
    }

    @Override
    public void stopSession(int exitCode) {
        this.m_exitCode = exitCode;
        try {
            this.execStoreSession();
        }
        catch (Throwable t) {
            LOG.error("store session", t);
        }
        if (this.m_desktop != null) {
            try {
                this.m_desktop.closeInternal();
            }
            catch (Throwable t) {
                LOG.error("close desktop", t);
            }
            this.m_desktop = null;
        }
        try {
            if (this.getServiceTunnel() != null) {
                ((ILogoutService)SERVICES.getService(ILogoutService.class)).logout();
            }
        }
        catch (Throwable t) {
            LOG.info("logout on server", t);
        }
        this.setActive(false);
        if (LOG.isInfoEnabled()) {
            LOG.info("end session event loop");
        }
    }

    @Override
    public int getExitCode() {
        return this.m_exitCode;
    }

    @Override
    public IServiceTunnel getServiceTunnel() {
        return this.m_serviceTunnel;
    }

    protected void setServiceTunnel(IServiceTunnel tunnel) {
        this.m_serviceTunnel = tunnel;
    }

    @Override
    public IMemoryPolicy getMemoryPolicy() {
        return this.m_memoryPolicy;
    }

    @Override
    public void setMemoryPolicy(IMemoryPolicy p) {
        if (this.m_memoryPolicy != null) {
            this.m_memoryPolicy.removeNotify();
        }
        this.m_memoryPolicy = p;
        if (this.m_memoryPolicy != null) {
            this.m_memoryPolicy.addNotify();
        }
    }

    public void goOnline() throws ProcessingException {
        if (OfflineState.isOfflineDefault()) {
            OfflineState.setOfflineDefault((boolean)false);
        }
    }

    @Override
    public void goOffline() throws ProcessingException {
        IEclipsePreferences pref = new UserScope().getNode("org.eclipse.scout.rt.client");
        if (this.getUserId() != null && OfflineState.isOnlineDefault()) {
            try {
                pref.put("offline.user", this.getUserId());
                pref.flush();
            }
            catch (BackingStoreException backingStoreException) {
                LOG.error("Could not write userId to preferences!");
            }
        }
        String offlineUser = pref.get("offline.user", "anonymous");
        this.m_offlineSubject = new Subject();
        this.m_offlineSubject.getPrincipals().add((Principal)new SimplePrincipal(offlineUser));
        OfflineState.setOfflineDefault((boolean)true);
    }

    @Override
    public boolean isWebSession() {
        return this.isSingleThreadSession();
    }

    @Override
    public boolean isSingleThreadSession() {
        return this.m_singleThreadSession;
    }

    @Override
    public String getWebSessionId() {
        return this.m_webSessionId;
    }

    @Override
    public void setWebSessionId(String sessionId) {
        this.m_webSessionId = sessionId;
    }

    protected IIconLocator createIconLocator() {
        return new IconLocator(this);
    }

    @Override
    public IIconLocator getIconLocator() {
        return this.m_iconLocator;
    }

    @Override
    public void setData(String key, Object data) {
        if (data == null) {
            this.m_clientSessionData.remove(key);
        } else {
            this.m_clientSessionData.put(key, data);
        }
    }

    @Override
    public Object getData(String key) {
        return this.m_clientSessionData.get(key);
    }
}

