/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.platform;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.prefs.UserScope;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.services.common.platform.IPlatformService;
import org.eclipse.scout.rt.client.ui.basic.filechooser.FileChooser;
import org.eclipse.scout.service.AbstractService;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

@Priority(value=-1.0f)
public class PlatformService
extends AbstractService
implements IPlatformService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(PlatformService.class);
    private IEclipsePreferences m_props = null;

    private Bundle getBundle() {
        return ClientSyncJob.getCurrentSession().getBundle();
    }

    @Override
    public boolean setProperty(String key, String value) {
        if (this.m_props == null) {
            this.m_props = new UserScope().getNode(this.getBundle().getSymbolicName());
        }
        String oldValue = this.m_props.get(key, null);
        if (value == null) {
            this.m_props.remove(key);
        } else {
            this.m_props.put(key, value);
            try {
                this.m_props.flush();
            }
            catch (BackingStoreException e) {
                LOG.warn("storing property: " + key + "=" + value, (Throwable)e);
            }
        }
        return !CompareUtility.equals((Object)oldValue, (Object)value);
    }

    @Override
    public String getProperty(String key, String def) {
        if (this.m_props == null) {
            this.m_props = new UserScope().getNode(this.getBundle().getSymbolicName());
        }
        return this.m_props.get(key, def);
    }

    @Override
    public String getFile() {
        return this.getFile(null, true);
    }

    @Override
    public String getFile(String ext, boolean open) {
        return this.getFile(ext, open, null);
    }

    @Override
    public String getFile(String ext, boolean open, String curPath) {
        return this.getFile(ext, open, curPath, false);
    }

    @Override
    public String getFile(String ext, boolean open, String curPath, boolean folderMode) {
        if (curPath == null && (curPath = FileChooser.getCurrentDirectory()) == null) {
            try {
                curPath = Platform.getStateLocation((Bundle)this.getBundle()).toFile().getCanonicalPath();
            }
            catch (IOException iOException) {
                curPath = null;
            }
        }
        File f = null;
        File[] a = new FileChooser(new File(curPath), new String[]{ext}, open).startChooser();
        if (a != null && a.length > 0) {
            f = a[0];
        }
        if (f != null) {
            if (f.isDirectory() != folderMode) {
                f = null;
            } else if (f.getAbsolutePath().indexOf("*") >= 0) {
                f = null;
            }
        }
        if (f != null) {
            FileChooser.setCurrentDirectory(f.getParent());
            return f.getAbsolutePath();
        }
        return null;
    }
}

