/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.useractivity;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientAsyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.services.common.clientnotification.ClientNotificationConsumerEvent;
import org.eclipse.scout.rt.client.services.common.clientnotification.IClientNotificationConsumerListener;
import org.eclipse.scout.rt.client.services.common.clientnotification.IClientNotificationConsumerService;
import org.eclipse.scout.rt.client.services.common.useractivity.UserActivityEvent;
import org.eclipse.scout.rt.client.services.common.useractivity.UserActivityListener;
import org.eclipse.scout.rt.shared.services.common.useractivity.IUserActivityProvider;
import org.eclipse.scout.rt.shared.services.common.useractivity.IUserActivityStateService;
import org.eclipse.scout.rt.shared.services.common.useractivity.UserActivityClientNotification;
import org.eclipse.scout.rt.shared.services.common.useractivity.UserStatusMap;
import org.eclipse.scout.service.SERVICES;

public class UserActivityManager {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(UserActivityManager.class);
    private final IClientSession m_clientSession;
    private final PropertyChangeListener m_userActivityProviderListener;
    private final IClientNotificationConsumerListener m_clientNotificationConsumerListener;
    private IUserActivityProvider m_provider;
    private final EventListenerList m_listenerList;
    private boolean m_started;
    private int m_currentState = 1;
    private UserStatusMap m_statusMap;

    public UserActivityManager(IClientSession clientSession) {
        this.m_clientSession = clientSession;
        this.m_clientNotificationConsumerListener = new IClientNotificationConsumerListener(){

            @Override
            public void handleEvent(ClientNotificationConsumerEvent e, boolean sync) {
                if (e.getClientNotification() instanceof UserActivityClientNotification) {
                    UserActivityManager.this.updateCache(((UserActivityClientNotification)e.getClientNotification()).getUserStatusMap());
                }
            }
        };
        this.m_userActivityProviderListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                UserActivityManager.this.providerStateChanged((Boolean)e.getNewValue() != false ? 2 : 3);
            }
        };
        this.m_listenerList = new EventListenerList();
    }

    public void addUserActivityListener(UserActivityListener listener) {
        this.m_listenerList.add(UserActivityListener.class, (EventListener)listener);
    }

    public void removeUserActivityListener(UserActivityListener listener) {
        this.m_listenerList.remove(UserActivityListener.class, (EventListener)listener);
    }

    public void start() {
        if (this.m_started) {
            return;
        }
        this.m_started = true;
        IUserActivityStateService[] iUserActivityStateServiceArray = (IUserActivityStateService[])SERVICES.getServices(IUserActivityStateService.class);
        int n = iUserActivityStateServiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IUserActivityStateService s = iUserActivityStateServiceArray[n2];
            try {
                this.updateCache(s.getUserStatusMap());
            }
            catch (Throwable t) {
                LOG.error("service " + s.getClass().getName(), t);
            }
            ++n2;
        }
        ((IClientNotificationConsumerService)SERVICES.getService(IClientNotificationConsumerService.class)).addClientNotificationConsumerListener(this.m_clientSession, this.m_clientNotificationConsumerListener);
        try {
            this.m_provider = (IUserActivityProvider)SERVICES.getService(IUserActivityProvider.class);
            if (this.m_provider != null) {
                this.m_provider.addPropertyChangeListener("active", this.m_userActivityProviderListener);
            }
        }
        catch (Throwable t) {
            LOG.error("provider " + this.m_provider, t);
        }
        this.providerStateChanged(2);
    }

    public void stop() {
        if (!this.m_started) {
            return;
        }
        this.m_started = false;
        ((IClientNotificationConsumerService)SERVICES.getService(IClientNotificationConsumerService.class)).removeClientNotificationConsumerListener(this.m_clientSession, this.m_clientNotificationConsumerListener);
        if (this.m_provider != null) {
            this.m_provider.removePropertyChangeListener("active", this.m_userActivityProviderListener);
        }
        this.m_provider = null;
        this.providerStateChanged(1);
    }

    public UserStatusMap getUserStatusMap() {
        return this.m_statusMap;
    }

    private void updateCache(UserStatusMap statusMap) {
        this.m_statusMap = statusMap;
        this.fireUserActivityEvent(new UserActivityEvent(this, this.m_statusMap));
    }

    private void fireUserActivityEvent(UserActivityEvent e) {
        UserActivityListener[] userActivityListenerArray = (UserActivityListener[])this.m_listenerList.getListeners(UserActivityListener.class);
        int n = userActivityListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            UserActivityListener listener = userActivityListenerArray[n2];
            try {
                listener.stateChanged(e);
            }
            catch (Throwable t) {
                LOG.error("listener " + listener.getClass().getName(), t);
            }
            ++n2;
        }
    }

    private void providerStateChanged(final int newStatus) {
        if (newStatus != this.m_currentState) {
            this.m_currentState = newStatus;
            new ClientAsyncJob("user activity " + newStatus, this.m_clientSession){

                @Override
                protected void runVoid(IProgressMonitor monitor) throws Throwable {
                    IUserActivityStateService[] iUserActivityStateServiceArray = (IUserActivityStateService[])SERVICES.getServices(IUserActivityStateService.class);
                    int n = iUserActivityStateServiceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IUserActivityStateService s = iUserActivityStateServiceArray[n2];
                        try {
                            s.setStatus(newStatus);
                        }
                        catch (Throwable t) {
                            LOG.error("service " + s.getClass().getName(), t);
                        }
                        ++n2;
                    }
                }
            }.schedule();
        }
    }
}

