/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.test;

import org.eclipse.scout.commons.runtime.BundleBrowser;
import org.eclipse.scout.rt.client.services.common.test.AbstractClientTest;
import org.eclipse.scout.rt.client.services.common.test.ClientTestUtility;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;
import org.osgi.framework.Bundle;

public class LengthStringFieldsUnitTest
extends AbstractClientTest {
    public void run() throws Exception {
        Bundle clientBundle = ClientTestUtility.getClientBundle();
        BundleBrowser b = new BundleBrowser(clientBundle.getSymbolicName(), ClientTestUtility.getFormsPackage());
        String[] stringArray = b.getClasses(false, false);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            Class c = clientBundle.loadClass(className);
            try {
                IForm form = (IForm)c.newInstance();
                IFormField[] iFormFieldArray = form.getAllFields();
                int n3 = iFormFieldArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IFormField field = iFormFieldArray[n4];
                    if (field instanceof IStringField) {
                        this.setSubTitle(String.valueOf(form.getTitle()) + " > " + field.getLabel() + " [" + form.getClass().getSimpleName() + "." + field.getClass().getSimpleName() + "]");
                        int length = ((IStringField)field).getMaxLength();
                        int area = field.getGridData().h * field.getGridData().w;
                        if (length < area * 30) {
                            this.addErrorStatus("length<area*30");
                        } else if (length > area * 300) {
                            this.addErrorStatus("length>area*300");
                        } else if (length < 10 && area > 1) {
                            this.addWarningStatus("length<10 but area>1");
                        } else if (length > 1000000) {
                            this.addWarningStatus("length>1'000'000");
                        } else {
                            this.addOkStatus("length=" + length + ", area=" + area);
                        }
                    }
                    ++n4;
                }
            }
            catch (Exception e) {
                this.addErrorStatus("analyzing form " + c, e);
            }
            ++n2;
        }
    }

    protected String getConfiguredTitle() {
        return "string fields: size to length comparison";
    }
}

