/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;

public final class TestMemoryUsage {
    private final Cell[] mv;

    private TestMemoryUsage(int rows, int cols) throws ProcessingException {
        this.mv = new Cell[rows * cols];
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols) {
                Cell v = new Cell();
                String s = "Hello World " + r + "," + c;
                v.setText(s);
                v.setValue(new Long(r * cols + c));
                this.mv[r * cols + c] = v;
                ++c;
            }
            ++r;
        }
    }

    public static void main(String[] args) throws ProcessingException {
        System.gc();
        long max0 = Runtime.getRuntime().maxMemory();
        long total0 = Runtime.getRuntime().totalMemory();
        long free0 = Runtime.getRuntime().freeMemory();
        int rows = 100000;
        int cols = 10;
        int cells = rows * cols;
        new TestMemoryUsage(rows, cols);
        System.gc();
        long max1 = Runtime.getRuntime().maxMemory();
        long total1 = Runtime.getRuntime().totalMemory();
        long free1 = Runtime.getRuntime().freeMemory();
        System.out.println("DELTA   max/total/consumed=" + (max1 - max0) + "/" + (total1 - total0) + "/" + (free0 - free1));
        System.out.println("DELTA/N max/total/consumed=" + (max1 - max0) / (long)cells + "/" + (total1 - total0) / (long)cells + "/" + (free0 - free1) / (long)cells);
        System.out.println("DELTA   total+consumed=" + (max1 - max0 + (total1 - total0) + (free0 - free1)));
        long d = (max1 - max0 + (total1 - total0) + (free0 - free1)) / (long)cells;
        System.out.println("DELTA/N total+consumed=43+" + (d - 43L));
        System.exit(0);
    }
}

