/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ISmartColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.AbstractSmartField;
import org.eclipse.scout.rt.shared.services.common.code.CODES;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.lookup.CodeLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;

public abstract class AbstractSmartColumn<T>
extends AbstractColumn<T>
implements ISmartColumn<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractSmartColumn.class);
    private Class<? extends ICodeType> m_codeTypeClass;
    private LookupCall m_lookupCall;
    private boolean m_sortCodesByDisplayText;

    @ConfigProperty(value="LOOKUP_CALL")
    @Order(value=140.0)
    @ConfigPropertyValue(value="null")
    protected Class<? extends LookupCall> getConfiguredLookupCall() {
        return null;
    }

    @ConfigProperty(value="CODE_TYPE")
    @Order(value=150.0)
    @ConfigPropertyValue(value="null")
    protected Class<? extends ICodeType> getConfiguredCodeType() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=160.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredSortCodesByDisplayText() {
        return false;
    }

    @ConfigOperation
    @Order(value=140.0)
    protected void execPrepareLookup(LookupCall call, ITableRow row) {
    }

    @Override
    protected void initConfig() {
        Class<LookupCall> lookupCallClass;
        super.initConfig();
        this.setSortCodesByDisplayText(this.getConfiguredSortCodesByDisplayText());
        if (this.getConfiguredCodeType() != null) {
            this.setCodeTypeClass(this.getConfiguredCodeType());
        }
        if ((lookupCallClass = this.getConfiguredLookupCall()) != null) {
            try {
                LookupCall call = lookupCallClass.newInstance();
                this.setLookupCall(call);
            }
            catch (InstantiationException e) {
                LOG.warn(null, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOG.warn(null, (Throwable)e);
            }
        }
    }

    @Override
    public Class<? extends ICodeType> getCodeTypeClass() {
        return this.m_codeTypeClass;
    }

    @Override
    public void setCodeTypeClass(Class<? extends ICodeType> codeTypeClass) {
        this.m_codeTypeClass = codeTypeClass;
        this.m_lookupCall = null;
        if (this.m_codeTypeClass != null) {
            this.m_lookupCall = new CodeLookupCall(this.m_codeTypeClass);
        }
    }

    @Override
    public LookupCall getLookupCall() {
        return this.m_lookupCall;
    }

    @Override
    public void setLookupCall(LookupCall call) {
        this.m_lookupCall = call;
    }

    @Override
    public boolean isSortCodesByDisplayText() {
        return this.m_sortCodesByDisplayText;
    }

    @Override
    public void setSortCodesByDisplayText(boolean b) {
        this.m_sortCodesByDisplayText = b;
    }

    @Override
    public LookupCall prepareLookupCall(ITableRow row) {
        if (this.getLookupCall() != null) {
            LookupCall call = (LookupCall)this.getLookupCall().clone();
            call.setKey(this.getValue(row));
            call.setText(null);
            call.setAll(null);
            call.setRec(null);
            this.execPrepareLookup(call, row);
            return call;
        }
        return null;
    }

    @Override
    protected T parseValueInternal(ITableRow row, Object rawValue) throws ProcessingException {
        Object validValue = null;
        if (rawValue == null) {
            validValue = null;
        } else if (this.getDataType().isAssignableFrom(rawValue.getClass())) {
            validValue = rawValue;
        } else {
            try {
                validValue = TypeCastUtility.castValue((Object)rawValue, this.getDataType());
            }
            catch (Exception exception) {
                throw new ProcessingException("invalid " + this.getDataType().getSimpleName() + " value in column '" + this.getClass().getName() + "': " + rawValue + " class=" + rawValue.getClass());
            }
        }
        return (T)validValue;
    }

    @Override
    protected IFormField prepareEditInternal(final ITableRow row) throws ProcessingException {
        AbstractSmartField f = new AbstractSmartField<T>(){

            @Override
            public Class<T> getHolderType() {
                return AbstractSmartColumn.this.getDataType();
            }

            @Override
            protected void execPrepareLookup(LookupCall call) throws ProcessingException {
                AbstractSmartColumn.this.execPrepareLookup(call, row);
            }
        };
        f.setLookupCall(this.getLookupCall());
        return f;
    }

    @Override
    public int compareTableRows(ITableRow r1, ITableRow r2) {
        LookupCall call;
        ICodeType codeType = this.getCodeTypeClass() != null ? CODES.getCodeType(this.getCodeTypeClass()) : null;
        LookupCall lookupCall = call = this.getLookupCall() != null ? this.getLookupCall() : null;
        if (codeType != null) {
            if (this.isSortCodesByDisplayText()) {
                String s1 = this.getDisplayText(r1);
                String s2 = this.getDisplayText(r2);
                return StringUtility.compareIgnoreCase((String)s1, (String)s2);
            }
            Object t1 = this.getValue(r1);
            Object t2 = this.getValue(r2);
            Integer sort1 = t1 != null ? codeType.getCodeIndex(t1) : -1;
            Integer sort2 = t2 != null ? codeType.getCodeIndex(t2) : -1;
            int c = sort1.compareTo(sort2);
            return c;
        }
        if (call != null) {
            String s1 = this.getDisplayText(r1);
            String s2 = this.getDisplayText(r2);
            return StringUtility.compareIgnoreCase((String)s1, (String)s2);
        }
        return super.compareTableRows(r1, r2);
    }
}

