/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.desktop.navigation.internal;

import java.util.List;
import org.eclipse.scout.commons.annotations.Priority;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.desktop.navigation.INavigationHistoryService;
import org.eclipse.scout.rt.client.ui.desktop.navigation.NavigationHistoryListener;
import org.eclipse.scout.rt.client.ui.desktop.navigation.internal.UserNavigationHistory;
import org.eclipse.scout.rt.shared.services.common.bookmark.Bookmark;
import org.eclipse.scout.service.AbstractService;

@Priority(value=-1.0f)
public class NavigationHistoryService
extends AbstractService
implements INavigationHistoryService {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(NavigationHistoryService.class);

    @Override
    public Bookmark addStep(int level, String name, String iconId) {
        return this.getUserNavigationHistory().addStep(level, name, iconId);
    }

    @Override
    public Bookmark getActiveBookmark() {
        return this.getUserNavigationHistory().getActiveBookmark();
    }

    @Override
    public List<Bookmark> getBookmarks() {
        return this.getUserNavigationHistory().getBookmarks();
    }

    @Override
    public List<Bookmark> getBackwardBookmarks() {
        return this.getUserNavigationHistory().getBackwardBookmarks();
    }

    @Override
    public boolean hasBackwardBookmarks() {
        return this.getUserNavigationHistory().hasBackwardBookmarks();
    }

    @Override
    public List<Bookmark> getForwardBookmarks() {
        return this.getUserNavigationHistory().getForwardBookmarks();
    }

    @Override
    public boolean hasForwardBookmarks() {
        return this.getUserNavigationHistory().hasForwardBookmarks();
    }

    @Override
    public void stepForward() throws ProcessingException {
        this.getUserNavigationHistory().stepForward();
    }

    @Override
    public void stepBackward() throws ProcessingException {
        this.getUserNavigationHistory().stepBackward();
    }

    @Override
    public void stepTo(Bookmark b) throws ProcessingException {
        this.getUserNavigationHistory().stepTo(b);
    }

    @Override
    public IMenu[] getMenus() {
        return this.getUserNavigationHistory().getMenus();
    }

    @Override
    public int getSize() {
        return this.getUserNavigationHistory().getSize();
    }

    @Override
    public int getIndex() {
        return this.getUserNavigationHistory().getIndex();
    }

    @Override
    public void addNavigationHistoryListener(NavigationHistoryListener listener) {
        this.getUserNavigationHistory().addNavigationHistoryListener(listener);
    }

    @Override
    public void removeNavigationHistoryListener(NavigationHistoryListener listener) {
        this.getUserNavigationHistory().removeNavigationHistoryListener(listener);
    }

    private UserNavigationHistory getUserNavigationHistory() {
        IClientSession session = ClientJob.getCurrentSession();
        if (session == null) {
            throw new IllegalStateException("null client session in current job context");
        }
        UserNavigationHistory data = (UserNavigationHistory)session.getData("navigationHistoryServiceData");
        if (data == null) {
            data = new UserNavigationHistory();
            session.setData("navigationHistoryServiceData", data);
        }
        return data;
    }
}

