/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal;

import java.util.ArrayList;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal.GridCell;
import org.eclipse.scout.rt.client.ui.form.fields.internal.GridDataBuilder;

public class GroupBoxBodyGrid {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(GroupBoxBodyGrid.class);
    private final IGroupBox m_groupBox;
    private IFormField[] m_fieldsExceptProcessButtons;
    private int m_gridColumns;
    private int m_gridRows;

    public GroupBoxBodyGrid(IGroupBox groupBox) {
        this.m_groupBox = groupBox;
    }

    public void validate() {
        boolean isContainingXAndY;
        this.m_gridRows = 0;
        this.m_gridColumns = -1;
        IGroupBox tmp = this.m_groupBox;
        while (this.m_gridColumns < 0 && tmp != null) {
            this.m_gridColumns = tmp.getGridColumnCountHint();
            tmp = tmp.getParentGroupBox();
        }
        if (this.m_gridColumns < 0) {
            this.m_gridColumns = 2;
        }
        int containingGridXYCount = 0;
        int notContainingGridXYCount = 0;
        ArrayList<IFormField> fieldsExceptProcessButtons = new ArrayList<IFormField>();
        IFormField[] fields = this.m_groupBox.getFields();
        int i = 0;
        while (i < fields.length) {
            IFormField f = fields[i];
            if (f.isVisible()) {
                if (!(f instanceof IButton) || !((IButton)f).isProcessButton()) {
                    fieldsExceptProcessButtons.add(f);
                    GridData hints = f.getGridDataHints();
                    if (hints.x >= 0 && hints.y >= 0) {
                        ++containingGridXYCount;
                    } else {
                        ++notContainingGridXYCount;
                    }
                }
            } else {
                GridData data = GridDataBuilder.createFromHints(f, 1);
                f.setGridDataInternal(data);
            }
            ++i;
        }
        this.m_fieldsExceptProcessButtons = fieldsExceptProcessButtons.toArray(new IFormField[0]);
        boolean bl = isContainingXAndY = containingGridXYCount > 0 && notContainingGridXYCount == 0;
        if (isContainingXAndY) {
            this.layoutAllStatic();
        } else {
            this.layoutAllDynamic();
        }
    }

    private void layoutAllStatic() {
        GridData hints;
        IFormField f;
        int totalGridW = 1;
        int totalGridH = 0;
        int i = 0;
        while (i < this.m_fieldsExceptProcessButtons.length) {
            f = this.m_fieldsExceptProcessButtons[i];
            hints = GridDataBuilder.createFromHints(f, 1);
            totalGridW = Math.max(totalGridW, hints.x + hints.w);
            totalGridH = Math.max(totalGridH, hints.y + hints.h);
            ++i;
        }
        i = 0;
        while (i < this.m_fieldsExceptProcessButtons.length) {
            f = this.m_fieldsExceptProcessButtons[i];
            hints = GridDataBuilder.createFromHints(f, totalGridW);
            f.setGridDataInternal(hints);
            ++i;
        }
        this.m_gridColumns = totalGridW;
        this.m_gridRows = totalGridH;
    }

    private void layoutAllDynamic() {
        GridCell main = null;
        if ((main = this.layoutControls(main)) != null) {
            main.calculateGridLayout(0, 0);
            this.m_gridRows = main.getMaxY();
            this.m_gridColumns = main.getMaxCols();
        }
    }

    private GridCell layoutControls(GridCell main) {
        GridCell part = null;
        int i = 0;
        while (i < this.m_fieldsExceptProcessButtons.length) {
            IFormField f = this.m_fieldsExceptProcessButtons[i];
            GridCell c = new GridCell(f, this.m_gridColumns);
            if (c.data.w >= this.m_gridColumns) {
                c.data.w = this.m_gridColumns;
                if (part != null) {
                    if (this.m_gridColumns > 1) {
                        int k = this.m_gridColumns;
                        GridCell splitRoot = part;
                        while (k >= 2) {
                            int maxWeight = splitRoot.getMaxWeight();
                            GridCell split = splitRoot.getSplitCell(0, maxWeight, k);
                            if (split == null || split == splitRoot) break;
                            split.getUp().setDown(null);
                            int splitOffMaxCols = Math.max(1, splitRoot.getMaxCols());
                            splitRoot.setRight(split);
                            splitRoot = split;
                            k -= splitOffMaxCols;
                        }
                    }
                    if (main == null) {
                        main = part;
                    } else {
                        main.addBottomCell(part);
                    }
                    part = null;
                }
                if (main == null) {
                    main = c;
                } else {
                    main.addBottomCell(c);
                }
            } else if (part == null) {
                part = c;
            } else {
                part.addBottomCell(c);
            }
            ++i;
        }
        if (part != null) {
            if (this.m_gridColumns > 1) {
                int k = this.m_gridColumns;
                GridCell splitRoot = part;
                while (k >= 2) {
                    int maxWeight = splitRoot.getMaxWeight();
                    GridCell split = splitRoot.getSplitCell(0, maxWeight, k);
                    if (split == null || split == splitRoot) break;
                    split.getUp().setDown(null);
                    int splitOffMaxCols = Math.max(1, splitRoot.getMaxCols());
                    splitRoot.setRight(split);
                    splitRoot = split;
                    k -= splitOffMaxCols;
                }
            }
            if (main == null) {
                main = part;
            } else {
                main.addBottomCell(part);
            }
            part = null;
        }
        return main;
    }

    public int getGridColumnCount() {
        return this.m_gridColumns;
    }

    public int getGridRowCount() {
        return this.m_gridRows;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.getGridRowCount() + " " + this.getGridColumnCount() + "]";
    }
}

