/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.groupbox.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.button.IButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.IGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.internal.GridDataBuilder;

public class GroupBoxProcessButtonGrid {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(GroupBoxProcessButtonGrid.class);
    private IGroupBox m_groupBox = null;
    private boolean m_includeSystemButtons;
    private boolean m_includeCustomButtons;
    private IButton[] m_buttons;

    public GroupBoxProcessButtonGrid(IGroupBox groupBox, boolean includeCustomButtons, boolean includeSystemButtons) {
        this.m_groupBox = groupBox;
        this.m_includeCustomButtons = includeCustomButtons;
        this.m_includeSystemButtons = includeSystemButtons;
    }

    public void validate() {
        ArrayList<IButton> buttonList = new ArrayList<IButton>();
        if (this.m_includeCustomButtons) {
            buttonList.addAll(Arrays.asList(this.m_groupBox.getCustomProcessButtons()));
        }
        if (this.m_includeSystemButtons) {
            buttonList.addAll(Arrays.asList(this.m_groupBox.getSystemProcessButtons()));
        }
        Iterator it = buttonList.iterator();
        while (it.hasNext()) {
            IButton b = (IButton)it.next();
            if (b.isVisible()) continue;
            GridData data = GridDataBuilder.createFromHints(b, 1);
            b.setGridDataInternal(data);
            it.remove();
        }
        this.m_buttons = buttonList.toArray(new IButton[0]);
        this.layoutStatic();
    }

    private void layoutStatic() {
        int i = 0;
        while (i < this.m_buttons.length) {
            GridData data = GridDataBuilder.createFromHints(this.m_buttons[i], 1);
            data.x = i;
            data.y = 0;
            this.m_buttons[i].setGridDataInternal(data);
            ++i;
        }
    }
}

