/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.snapbox.internal;

import java.util.ArrayList;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.GridData;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.internal.GridDataBuilder;
import org.eclipse.scout.rt.client.ui.form.fields.snapbox.ISnapBox;

public class SnapBoxGrid {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SnapBoxGrid.class);
    private ISnapBox m_snapBox = null;
    private IFormField[] m_fields;
    private int m_gridColumns;
    private int m_gridRows;

    public SnapBoxGrid(ISnapBox snapBox) {
        this.m_snapBox = snapBox;
    }

    public void validate() {
        this.m_gridColumns = 0;
        this.m_gridRows = 0;
        ArrayList<IFormField> list = new ArrayList<IFormField>();
        IFormField[] iFormFieldArray = this.m_snapBox.getFields();
        int n = iFormFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormField f = iFormFieldArray[n2];
            if (f.isVisible()) {
                list.add(f);
            } else {
                GridData data = GridDataBuilder.createFromHints(f, 1);
                f.setGridDataInternal(data);
            }
            ++n2;
        }
        this.m_fields = list.toArray(new IFormField[list.size()]);
        this.layoutStatic();
    }

    private void layoutStatic() {
        int y = 0;
        int i = 0;
        while (i < this.m_fields.length) {
            GridData data = GridDataBuilder.createFromHints(this.m_fields[i], 1);
            data.x = 0;
            data.y = y;
            this.m_fields[i].setGridDataInternal(data);
            y += data.h;
            this.m_gridColumns = Math.max(this.m_gridColumns, data.w);
            ++i;
        }
        this.m_gridRows = y;
    }

    public int getGridColumnCount() {
        return this.m_gridColumns;
    }

    public int getGridRowCount() {
        return this.m_gridRows;
    }
}

