/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.wizard;

import java.beans.PropertyChangeListener;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.FormEvent;
import org.eclipse.scout.rt.client.ui.form.FormListener;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.wizard.IWizard;
import org.eclipse.scout.rt.client.ui.wizard.IWizardStep;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractWizardStep<T extends IForm>
extends AbstractPropertyObserver
implements IWizardStep<T>,
IPropertyObserver {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractWizardStep.class);
    private IWizard m_wizard;
    private T m_form;
    private FormListener m_formListener;
    private int m_activationCounter;
    private boolean m_initialized;

    public AbstractWizardStep() {
        this(true);
    }

    public AbstractWizardStep(boolean callInitializer) {
        if (callInitializer) {
            this.callInitializer();
        }
    }

    protected void callInitializer() {
        if (!this.m_initialized) {
            this.initConfig();
            this.m_initialized = true;
        }
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=10.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredEnabled() {
        return true;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=20.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredTitle() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=30.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredTooltipText() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=35.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredTitleHtml() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=38.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredDescriptionHtml() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=40.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=50.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredDoc() {
        return null;
    }

    @Order(value=10.0)
    @ConfigOperation
    protected void execActivate(int stepKind) throws ProcessingException {
    }

    @Order(value=20.0)
    @ConfigOperation
    protected void execDeactivate(int stepKind) throws ProcessingException {
    }

    @Order(value=30.0)
    @ConfigOperation
    protected void execDispose() throws ProcessingException {
        T f = this.getForm();
        if (f != null) {
            f.doClose();
        }
    }

    @Order(value=40.0)
    @ConfigOperation
    protected void execFormStored(boolean activation) throws ProcessingException {
    }

    @Order(value=50.0)
    @ConfigOperation
    protected void execFormDiscarded(boolean activation) throws ProcessingException {
    }

    @Order(value=60.0)
    @ConfigOperation
    protected void execFormClosed(boolean activation) throws ProcessingException {
        if (!activation && this.getForm().isFormStored()) {
            this.getWizard().doNextStep();
        }
    }

    protected void initConfig() {
        this.setTitle(this.getConfiguredTitle());
        this.setTooltipText(this.getConfiguredTooltipText());
        this.setTitleHtml(this.getConfiguredTitleHtml());
        this.setDescriptionHtml(this.getConfiguredDescriptionHtml());
        this.setIconId(this.getConfiguredIconId());
        this.setEnabled(this.getConfiguredEnabled());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propName, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(propName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propName, PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(propName, listener);
    }

    @Override
    public T getForm() {
        return this.m_form;
    }

    @Override
    public void setForm(T f) {
        if (this.m_form != null && this.m_formListener != null) {
            this.m_form.removeFormListener(this.m_formListener);
        }
        this.m_form = f;
        if (this.m_form != null) {
            if (this.m_formListener == null) {
                this.m_formListener = new FormListener(){

                    @Override
                    public void formChanged(FormEvent e) throws ProcessingException {
                        try {
                            switch (e.getType()) {
                                case 2020: {
                                    AbstractWizardStep.this.execFormStored(AbstractWizardStep.this.m_activationCounter > 0);
                                    break;
                                }
                                case 3000: {
                                    AbstractWizardStep.this.execFormDiscarded(AbstractWizardStep.this.m_activationCounter > 0);
                                    break;
                                }
                                case 3010: {
                                    AbstractWizardStep.this.execFormClosed(AbstractWizardStep.this.m_activationCounter > 0);
                                }
                            }
                        }
                        catch (ProcessingException pe) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(pe);
                        }
                        catch (Throwable t) {
                            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
                        }
                        switch (e.getType()) {
                            case 3010: {
                                AbstractWizardStep.this.setForm(null);
                            }
                        }
                    }
                };
            }
            this.m_form.addFormListener(this.m_formListener);
        }
    }

    @Override
    public IWizard getWizard() {
        return this.m_wizard;
    }

    @Override
    public void setWizardInternal(IWizard w) {
        this.m_wizard = w;
    }

    @Override
    public String getIconId() {
        return this.propertySupport.getPropertyString("iconId");
    }

    @Override
    public void setIconId(String s) {
        this.propertySupport.setPropertyString("iconId", s);
    }

    @Override
    public String getTitle() {
        return this.propertySupport.getPropertyString("title");
    }

    @Override
    public void setTitle(String s) {
        this.propertySupport.setPropertyString("title", s);
    }

    @Override
    public String getTooltipText() {
        return this.propertySupport.getPropertyString("tooltipText");
    }

    @Override
    public void setTooltipText(String s) {
        this.propertySupport.setPropertyString("tooltipText", s);
    }

    @Override
    public String getTitleHtml() {
        return this.propertySupport.getPropertyString("titleHtml");
    }

    @Override
    public void setTitleHtml(String s) {
        this.propertySupport.setPropertyString("titleHtml", s);
    }

    @Override
    public String getDescriptionHtml() {
        return this.propertySupport.getPropertyString("descriptionHtml");
    }

    @Override
    public void setDescriptionHtml(String s) {
        this.propertySupport.setPropertyString("descriptionHtml", s);
    }

    @Override
    public boolean isEnabled() {
        return this.propertySupport.getPropertyBool("enabled");
    }

    @Override
    public void setEnabled(boolean b) {
        this.propertySupport.setPropertyBool("enabled", b);
    }

    @Override
    public void activate(int stepKind) throws ProcessingException {
        try {
            ++this.m_activationCounter;
            this.execActivate(stepKind);
        }
        finally {
            --this.m_activationCounter;
        }
    }

    @Override
    public void deactivate(int stepKind) throws ProcessingException {
        try {
            ++this.m_activationCounter;
            this.execDeactivate(stepKind);
        }
        finally {
            --this.m_activationCounter;
        }
    }

    @Override
    public void dispose() throws ProcessingException {
        try {
            ++this.m_activationCounter;
            this.execDispose();
        }
        finally {
            --this.m_activationCounter;
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.getTitle() + "]";
    }
}

