/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.ui.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.sphinx.emf.validation.ui.views.ConcreteMarker;
import org.eclipse.sphinx.emf.validation.ui.views.IField;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerGroupingEntry;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerMessages;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerNode;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerType;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerTypesModel;
import org.eclipse.sphinx.emf.validation.ui.views.Util;
import org.eclipse.swt.graphics.Image;

public class FieldMarkerGroup
implements IField {
    private static MarkerGroupingEntry undefinedEntry = new MarkerGroupingEntry(MarkerMessages.FieldCategory_Uncategorized, null, 0);
    private String title;
    private String id;
    private Map typesToMappings = new HashMap();
    private boolean showing;

    public FieldMarkerGroup(String name, String identifier) {
        this.title = name;
        this.id = identifier;
    }

    public String getDescription() {
        return this.title;
    }

    public Image getDescriptionImage() {
        return null;
    }

    public String getColumnHeaderText() {
        return this.title;
    }

    public Image getColumnHeaderImage() {
        return null;
    }

    public String getValue(Object obj) {
        MarkerNode node = (MarkerNode)obj;
        if (node.isConcrete()) {
            MarkerGroupingEntry groupingEntry = this.getMapping((ConcreteMarker)node);
            return groupingEntry.getLabel();
        }
        return node.getDescription();
    }

    private MarkerGroupingEntry getMapping(ConcreteMarker marker) {
        if (marker.getGroup() == null) {
            marker.setGroup(this.findGroupValue(marker));
        }
        return (MarkerGroupingEntry)marker.getGroup();
    }

    private MarkerGroupingEntry findGroupValue(ConcreteMarker marker) {
        if (this.typesToMappings.containsKey(marker.getType())) {
            EntryMapping defaultMapping = null;
            for (EntryMapping mapping : (Collection)this.typesToMappings.get(marker.getType())) {
                if (mapping.hasAttributes()) {
                    MarkerGroupingEntry entry = mapping.testAttribute(marker);
                    if (entry == null) continue;
                    return entry;
                }
                defaultMapping = mapping;
            }
            if (defaultMapping != null) {
                return defaultMapping.groupingEntry;
            }
        }
        return undefinedEntry;
    }

    public Image getImage(Object obj) {
        return null;
    }

    public int compare(Object obj1, Object obj2) {
        MarkerGroupingEntry entry1 = this.getMapping(((MarkerNode)obj1).getConcreteRepresentative());
        MarkerGroupingEntry entry2 = this.getMapping(((MarkerNode)obj2).getConcreteRepresentative());
        return entry2.getPriority() - entry1.getPriority();
    }

    public int getDefaultDirection() {
        return 1;
    }

    public int getPreferredWidth() {
        return 75;
    }

    public boolean isShowing() {
        return this.showing;
    }

    public void setShowing(boolean showing) {
        this.showing = showing;
    }

    public void setAsDefault(String markerType, MarkerGroupingEntry entry) {
        this.addEntry(markerType, new EntryMapping(entry));
    }

    private void addEntry(String markerType, EntryMapping entry) {
        MarkerType[] allDerived;
        MarkerType[] markerTypeArray = allDerived = this.getMarkerTypes(markerType);
        int n = allDerived.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerType type = markerTypeArray[n2];
            Collection<EntryMapping> entries = new HashSet<EntryMapping>();
            entries = this.typesToMappings.containsKey(type.getId()) ? (Collection)this.typesToMappings.get(markerType) : new HashSet();
            entries.add(entry);
            this.typesToMappings.put(type.getId(), entries);
            ++n2;
        }
    }

    private MarkerType[] getMarkerTypes(String markerType) {
        MarkerTypesModel model = MarkerTypesModel.getInstance();
        HashSet<MarkerType> types = new HashSet<MarkerType>();
        MarkerType type = model.getType(markerType);
        if (type != null) {
            MarkerType[] subs;
            types.add(type);
            MarkerType[] markerTypeArray = subs = type.getAllSubTypes();
            int n = subs.length;
            int n2 = 0;
            while (n2 < n) {
                MarkerType sub = markerTypeArray[n2];
                types.add(sub);
                ++n2;
            }
        }
        if (types.isEmpty()) {
            return new MarkerType[0];
        }
        MarkerType[] typesArray = new MarkerType[types.size()];
        types.toArray(typesArray);
        return typesArray;
    }

    public void mapAttribute(String markerType, String attribute, String attributeValue, MarkerGroupingEntry entry) {
        this.addEntry(markerType, new AttributeMapping(entry, attribute, attributeValue));
    }

    public String getId() {
        return this.id;
    }

    public void remove(MarkerGroupingEntry entry) {
        Iterator entries = this.typesToMappings.values().iterator();
        ArrayList<EntryMapping> removeCollection = new ArrayList<EntryMapping>();
        while (entries.hasNext()) {
            Collection mappings = (Collection)entries.next();
            for (EntryMapping next : mappings) {
                if (!next.groupingEntry.equals(entry)) continue;
                removeCollection.add(next);
            }
            mappings.removeAll(removeCollection);
            removeCollection.clear();
        }
    }

    class AttributeMapping
    extends EntryMapping {
        String attribute;
        String attributeValue;

        AttributeMapping(MarkerGroupingEntry entry, String attributeName, String value) {
            super(entry);
            this.attribute = attributeName;
            this.attributeValue = value;
        }

        public boolean hasAttributes() {
            return true;
        }

        public MarkerGroupingEntry testAttribute(ConcreteMarker marker) {
            Object value;
            if (!marker.getMarker().exists()) {
                return null;
            }
            try {
                value = marker.getMarker().getAttribute(this.attribute);
            }
            catch (CoreException e) {
                Util.log(e);
                return null;
            }
            if (value != null && this.attributeValue.equals(value.toString())) {
                return this.groupingEntry;
            }
            return null;
        }
    }

    class EntryMapping {
        MarkerGroupingEntry groupingEntry;

        EntryMapping(MarkerGroupingEntry entry) {
            this.groupingEntry = entry;
        }

        public boolean hasAttributes() {
            return false;
        }

        public MarkerGroupingEntry testAttribute(ConcreteMarker marker) {
            return null;
        }
    }
}

