/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.ui.groups;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.internal.xtend.xtend.ast.Extension;
import org.eclipse.internal.xtend.xtend.ast.ExtensionFile;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.platform.ui.fields.ComboField;
import org.eclipse.sphinx.platform.ui.fields.IField;
import org.eclipse.sphinx.platform.ui.fields.IFieldListener;
import org.eclipse.sphinx.platform.ui.fields.StringButtonField;
import org.eclipse.sphinx.platform.ui.fields.StringField;
import org.eclipse.sphinx.platform.ui.fields.adapters.IButtonAdapter;
import org.eclipse.sphinx.platform.ui.groups.AbstractGroup;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.xtendxpand.XtendEvaluationRequest;
import org.eclipse.sphinx.xtendxpand.ui.internal.messages.Messages;
import org.eclipse.sphinx.xtendxpand.util.XtendXpandUtil;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.core.IXtendXpandProject;
import org.eclipse.xtend.shared.ui.core.IXtendXpandResource;
import org.eclipse.xtend.typesystem.Callable;
import org.eclipse.xtend.typesystem.Type;

public class ExtensionGroup
extends AbstractGroup {
    protected static final String M2M_TRANSFORM_SECTION = String.valueOf(org.eclipse.sphinx.xtendxpand.ui.internal.Activator.getPlugin().getSymbolicName()) + ".M2M_TRANSFORM_SECTION";
    protected static final String STORE_EXTENSION_FILE = "EXTENSION_FILE$";
    protected static final String STORE_SELECTED_FUNCTION = "SELECTED_FUNCTION";
    protected StringButtonField extensionFileField;
    protected ComboField functionField;
    protected StringField extensionNameField;
    protected EObject modelObject;
    protected TypeSystem typeSystem;
    private List<Extension> extensions;

    public ExtensionGroup(String groupName, EObject modelObject, TypeSystem typeSystem) {
        this(groupName, modelObject, typeSystem, null);
    }

    public ExtensionGroup(String groupName, EObject modelObject, TypeSystem typeSystem, IDialogSettings dialogSettings) {
        super(groupName, dialogSettings);
        Assert.isNotNull((Object)typeSystem);
        this.modelObject = modelObject;
        this.typeSystem = typeSystem;
    }

    protected void doCreateContent(final Composite parent, int numColumns) {
        parent.setLayout((Layout)new GridLayout(numColumns, false));
        this.extensionFileField = new StringButtonField(new IButtonAdapter(){

            public void changeControlPressed(IField field) {
                IFile file;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(parent.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle(Messages.label_extensionSelection);
                dialog.setMessage(Messages.msg_chooseExtension);
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                IFile modelFile = EcorePlatformUtil.getFile((EObject)ExtensionGroup.this.modelObject);
                if (modelFile != null) {
                    dialog.setInitialSelection((Object)modelFile.getProject());
                }
                dialog.setComparator((ViewerComparator)new ResourceComparator(1));
                dialog.addFilter(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        if (element instanceof IFile) {
                            return "ext".equals(((IFile)element).getFileExtension());
                        }
                        if (element instanceof IResource) {
                            return !ExtendedPlatform.isPlatformPrivateResource((IResource)((IResource)element));
                        }
                        return true;
                    }
                });
                dialog.setValidator(new ISelectionStatusValidator(){

                    public IStatus validate(Object[] selection) {
                        IFile selectedFile;
                        int nSelected = selection.length;
                        String pluginId = org.eclipse.sphinx.xtendxpand.ui.internal.Activator.getPlugin().getSymbolicName();
                        if (nSelected == 1 && selection[0] instanceof IFile && (selectedFile = (IFile)selection[0]).exists() && "ext".equals(selectedFile.getFileExtension())) {
                            return Status.OK_STATUS;
                        }
                        return new Status(4, pluginId, 4, Messages.msg_chooseExtensionError, null);
                    }
                });
                if (dialog.open() == 0 && (file = (IFile)dialog.getFirstResult()) != null) {
                    ExtensionGroup.this.extensionFileField.setText(file.getFullPath().makeRelative().toString());
                    ExtensionGroup.this.updateFunctionFieldItems(file);
                }
            }
        });
        this.extensionFileField.setButtonLabel(Messages.label_browse);
        this.extensionFileField.setLabelText(Messages.label_extensionFile);
        this.extensionFileField.fillIntoGrid(parent, numColumns);
        this.extensionFileField.addFieldListener(new IFieldListener(){

            public void dialogFieldChanged(IField field) {
                ExtensionGroup.this.updateFunctionFieldItems(ExtensionGroup.this.getFile(ExtensionGroup.this.extensionFileField.getText()));
                ExtensionGroup.this.updateExtensionNameField();
                ExtensionGroup.this.notifyGroupChanged((IField)ExtensionGroup.this.extensionFileField);
            }
        });
        this.functionField = new ComboField(true);
        this.functionField.setLabelText(Messages.label_functionFieldName);
        this.functionField.fillIntoGrid(parent, numColumns);
        this.functionField.addFieldListener(new IFieldListener(){

            public void dialogFieldChanged(IField field) {
                ExtensionGroup.this.updateExtensionNameField();
                ExtensionGroup.this.notifyGroupChanged((IField)ExtensionGroup.this.extensionFileField);
            }
        });
        this.extensionNameField = new StringField();
        this.extensionNameField.setLabelText(Messages.label_extensionName);
        this.extensionNameField.setEditable(false);
        this.extensionNameField.fillIntoGrid(parent, numColumns);
    }

    public void updateFunctionFieldItems(IFile templateFile) {
        ExtensionFile extensionFile = this.loadExtensionFile(templateFile);
        if (extensionFile != null) {
            this.extensions = extensionFile.getExtensions();
            this.functionField.setItems(this.createFunctionFieldItems(this.extensions));
            return;
        }
        this.functionField.setItems(new String[0]);
    }

    protected String[] createFunctionFieldItems(List<Extension> extensions) {
        ArrayList<String> result = new ArrayList<String>();
        Type type = this.typeSystem.getType((Object)this.modelObject);
        if (type != null) {
            for (Callable extension : XtendXpandUtil.getApplicableFeatures(extensions, Extension.class, null, Arrays.asList(type))) {
                result.add(((Extension)extension).getName());
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public String getExtensionName() {
        String selectedFunction = this.getSelectedFunctionFieldItem();
        if (selectedFunction != null) {
            return XtendXpandUtil.getQualifiedName((IFile)this.getFile(this.getExtensionFileField().getText()), (String)selectedFunction);
        }
        return "";
    }

    protected void updateExtensionNameField() {
        IFile templateFile = this.getFile(this.extensionFileField.getText());
        if (templateFile != null) {
            this.extensionNameField.setText(this.getExtensionName());
        } else {
            this.extensionNameField.setText("...");
        }
    }

    protected ExtensionFile loadExtensionFile(IFile extensionFile) {
        IXtendXpandResource resource;
        IXtendXpandProject project;
        if (extensionFile != null && extensionFile.exists() && "ext".equals(extensionFile.getFileExtension()) && (project = Activator.getExtXptModelManager().findProject((IResource)extensionFile)) != null && (resource = project.findXtendXpandResource((IStorage)extensionFile)) != null) {
            return (ExtensionFile)resource.getExtXptResource();
        }
        return null;
    }

    public boolean isGroupComplete() {
        IFile extensionFile = this.getFile(this.getExtensionFileField().getText());
        if (extensionFile != null) {
            return extensionFile.exists() && this.getFunctionField().getSelectionIndex() != -1;
        }
        return false;
    }

    protected IFile getFile(String fullPath) {
        Path path;
        if (fullPath != null && fullPath.length() > 0 && (path = new Path(fullPath)).segmentCount() > 1) {
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        return null;
    }

    public String getSelectedFunctionFieldItem() {
        if (this.functionField != null && !this.functionField.getComboControl().isDisposed()) {
            String[] items = this.functionField.getItems();
            int selectionIndex = this.functionField.getSelectionIndex();
            if (items.length > 0 && selectionIndex != -1) {
                return items[selectionIndex];
            }
        }
        return null;
    }

    public StringButtonField getExtensionFileField() {
        return this.extensionFileField;
    }

    public ComboField getFunctionField() {
        return this.functionField;
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }

    public Collection<XtendEvaluationRequest> getXtendEvaluationRequests() {
        String extensionName;
        ArrayList<XtendEvaluationRequest> requests = new ArrayList<XtendEvaluationRequest>();
        if (this.modelObject != null && (extensionName = this.getExtensionName()) != null && extensionName.length() > 0) {
            requests.add(new XtendEvaluationRequest(extensionName, (Object)this.modelObject));
        }
        return requests;
    }

    protected void loadGroupSettings() {
        String extensionFile = this.getExtensionFileFromDialogSettings();
        if (extensionFile != null) {
            this.extensionFileField.setText(extensionFile);
            this.updateFunctionFieldItems(this.getFile(extensionFile));
            String functionName = this.getFunctionFromDialogSettings();
            if (functionName != null) {
                this.functionField.selectItem(functionName);
            }
        }
    }

    public String getExtensionFileFromDialogSettings() {
        IFile extensionFile;
        String extensionFilePath;
        String result = null;
        String key = this.getExtensionFileDialogSettingsKey(this.modelObject);
        IDialogSettings extensionFileSection = this.getExtensionFileSection();
        if (extensionFileSection != null && (extensionFilePath = extensionFileSection.get(key)) != null && (extensionFile = this.getFile(extensionFilePath)) != null && extensionFile.exists()) {
            result = extensionFilePath;
        }
        return result;
    }

    public String getFunctionFromDialogSettings() {
        String result = null;
        IDialogSettings extensionFileSection = this.getExtensionFileSection();
        if (extensionFileSection != null) {
            result = extensionFileSection.get(STORE_SELECTED_FUNCTION);
        }
        return result;
    }

    protected IDialogSettings getExtensionFileSection() {
        IDialogSettings result = null;
        String key = this.getExtensionFileDialogSettingsKey(this.modelObject);
        IDialogSettings section = this.getDialogSettings().getSection(M2M_TRANSFORM_SECTION);
        if (section != null) {
            result = section.getSection(key);
        }
        return result;
    }

    public void saveGroupSettings() {
        IDialogSettings settings = this.getDialogSettings();
        String extensionFileDialogSettingsKey = this.getExtensionFileDialogSettingsKey(this.modelObject);
        if (settings != null) {
            IDialogSettings topLevelSection = settings.getSection(M2M_TRANSFORM_SECTION);
            if (topLevelSection == null) {
                topLevelSection = settings.addNewSection(M2M_TRANSFORM_SECTION);
            }
            if (this.extensionFileField.getText().trim().length() != 0) {
                IDialogSettings extensionFileSection = topLevelSection.getSection(extensionFileDialogSettingsKey);
                if (extensionFileSection == null) {
                    extensionFileSection = topLevelSection.addNewSection(extensionFileDialogSettingsKey);
                }
                extensionFileSection.put(extensionFileDialogSettingsKey, this.extensionFileField.getText());
                String[] items = this.functionField.getItems();
                int selectionIndex = this.functionField.getSelectionIndex();
                if (items.length > 0 && selectionIndex != -1) {
                    extensionFileSection.put(STORE_SELECTED_FUNCTION, items[selectionIndex]);
                }
            }
        }
    }

    protected String getExtensionFileDialogSettingsKey(EObject object) {
        Assert.isNotNull((Object)object);
        return STORE_EXTENSION_FILE + EcoreResourceUtil.getURI((EObject)object).toString();
    }
}

