/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.check.operations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sphinx.emf.check.internal.messages.Messages;
import org.eclipse.sphinx.emf.check.services.CheckProblemMarkerService;
import org.eclipse.sphinx.platform.operations.AbstractWorkspaceOperation;

public class BasicCheckValidationOperation
extends AbstractWorkspaceOperation {
    private List<Object> modelObjects;
    private Map<Object, Object> options;

    public BasicCheckValidationOperation(List<Object> modelObjects, Map<Object, Object> options) {
        super(Messages.operation_checkValidation_label);
        Assert.isNotNull(modelObjects);
        this.options = options != null ? options : Collections.emptyMap();
        this.modelObjects = modelObjects;
    }

    public ISchedulingRule getRule() {
        return null;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    for (Object modelObject : BasicCheckValidationOperation.this.modelObjects) {
                        BasicCheckValidationOperation.this.validate(modelObject, BasicCheckValidationOperation.this.options);
                    }
                }
            };
            TransactionalEditingDomain editingDomain = this.getEditingDomain(this.modelObjects.get(0));
            if (editingDomain != null) {
                editingDomain.runExclusive(runnable);
            } else {
                runnable.run();
            }
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InterruptedException interruptedException) {}
    }

    protected void validate(Object modelObject, Map<Object, Object> contextEntries) {
        if (modelObject instanceof EObject) {
            Diagnostic diagnostic = Diagnostician.INSTANCE.validate((EObject)modelObject, contextEntries);
            this.updateProblemMarkers((EObject)modelObject, diagnostic);
        }
    }

    protected TransactionalEditingDomain getEditingDomain(Object input) {
        return TransactionUtil.getEditingDomain((Object)input);
    }

    protected Set<EPackage> getEPacakges(EObject input) {
        HashSet<EPackage> result = new HashSet<EPackage>();
        List<EObject> objectsToValidate = this.getObjectsToValidate(input);
        for (EObject obj : objectsToValidate) {
            result.add(obj.eClass().getEPackage());
        }
        return result;
    }

    protected List<EObject> getObjectsToValidate(EObject input) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        result.add(input);
        TreeIterator iter = input.eAllContents();
        while (iter.hasNext()) {
            result.add((EObject)iter.next());
        }
        return result;
    }

    protected void updateProblemMarkers(EObject eObject, Diagnostic diagnostic) {
        CheckProblemMarkerService.INSTANCE.updateProblemMarkers(eObject, diagnostic);
    }
}

