/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.eclient.graphics;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class FontManager {
    private static final int[] R2SWT_STYLE;
    private static final int R_STYLE_COUNT = 4;
    private static final int HR_FONTSIZE = 60;
    private static final double HR_FACTOR = 60.0;
    private static final int HR_MIN_FONTSIZE = 30;
    private final Display display;
    private final Object testGCLock = new Object();
    private TestGC testGC;
    private boolean disposed;
    private final Map<String, FontFamily> fontFamilies = new HashMap<String, FontFamily>();

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        R2SWT_STYLE = nArray;
    }

    public FontManager(Display display) {
        this.display = display;
    }

    public synchronized FontFamily getFamily(String family) {
        FontFamily fontFamily = this.fontFamilies.get(family);
        if (fontFamily == null) {
            fontFamily = new FontFamily(family);
            this.fontFamilies.put(family, fontFamily);
        }
        return fontFamily;
    }

    protected final Object getTestLock() {
        return this.testGCLock;
    }

    protected final TestGC getTestGC() {
        if (this.testGC == null) {
            this.display.syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!FontManager.this.disposed) {
                        FontManager.this.testGC = new TestGC((Device)FontManager.this.display);
                    }
                }
            });
        }
        return this.testGC;
    }

    public void dispose() {
        this.disposed = true;
        for (FontFamily fontFamily : this.fontFamilies.values()) {
            fontFamily.dispose();
        }
        this.fontFamilies.clear();
        if (this.testGC != null) {
            this.testGC.dispose();
            this.testGC = null;
        }
    }

    public final class FontFamily {
        private static final double POLISH_SMALL_MAX_FACTOR = 0.4;
        private static final double POLISH_SMALL_ADD_CORR = 0.04;
        private static final double POLISH_ADD_CONST = 0.05;
        private static final double POLISH_ADD_REL = 0.1;
        private static final int METRIC_IDX_ADVWIDTH = 0;
        private static final int METRIC_IDX_ASCENT = 1;
        private static final int METRIC_IDX_DESCENT = 2;
        private static final int METRIC_COUNT = 3;
        final String name;
        final FontInstance[][] fonts = new FontInstance[4][];

        private FontFamily(String name) {
            this.name = name;
        }

        private FontInstance get(int style, int size) {
            int idx;
            FontInstance[] styleFonts = this.fonts[style];
            if (styleFonts == null) {
                styleFonts = new FontInstance[4];
                this.fonts[style] = styleFonts;
            }
            if (size == 60) {
                idx = 0;
            } else {
                idx = styleFonts.length;
                int i = 1;
                while (i < styleFonts.length) {
                    if (styleFonts[i] != null) {
                        if (styleFonts[i].size == size) {
                            idx = i;
                            break;
                        }
                    } else {
                        idx = i;
                        break;
                    }
                    ++i;
                }
                if (idx >= styleFonts.length) {
                    this.fonts[style] = new FontInstance[styleFonts.length + 4];
                    System.arraycopy(styleFonts, 0, this.fonts[style], 0, styleFonts.length);
                    styleFonts = this.fonts[style];
                }
            }
            if (styleFonts[idx] == null) {
                FontData fontData = new FontData(this.name, size, R2SWT_STYLE[style]);
                styleFonts[idx] = new FontInstance(size, new Font((Device)FontManager.this.display, fontData));
            }
            return styleFonts[idx];
        }

        public synchronized Font getSWTFont(int style, int size) {
            return this.get((int)style, (int)size).swtFont;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized double[] getCharMetrics(int style, int size, int ch) {
            FontInstance font = this.get(style, 60);
            double factor = (double)size / 60.0;
            int chIdx = font.checkChar(ch) * 3;
            double[] answer = new double[3];
            if (chIdx >= font.charMetrics.length || font.charMetrics[chIdx] == 0.0) {
                Object object = FontManager.this.getTestLock();
                synchronized (object) {
                    TestGC gc = FontManager.this.getTestGC();
                    gc.setFont(font);
                    if (font.charMetrics.length == 0) {
                        font.charMetrics = new double[Math.max(1536, chIdx + 384)];
                        ((FontInstance)font).charMetrics[96] = ((double)gc.testGC.getAdvanceWidth('m') * 0.2 + (double)gc.testGC.getAdvanceWidth(' ') * 1.0) / 2.0;
                        ((FontInstance)font).charMetrics[97] = 0.0;
                        ((FontInstance)font).charMetrics[98] = 0.0;
                        font.ascentUp = this.checkCharAscentMean(gc, new char[]{'A', 'M', 'O', 'E'});
                        font.ascentLow = this.checkCharAscentMean(gc, new char[]{'a', 'm', 'p', 'w'});
                        ((FontInstance)font).charMetrics[0] = font.charMetrics[231];
                        ((FontInstance)font).charMetrics[1] = font.ascentUp > 0.0 ? font.ascentUp : 0.0;
                        ((FontInstance)font).charMetrics[2] = 0.0;
                    } else if (chIdx >= font.charMetrics.length) {
                        double[] newArray = new double[chIdx + 384];
                        System.arraycopy(font.charMetrics, 0, newArray, 0, font.charMetrics.length);
                        font.charMetrics = newArray;
                    }
                    if (font.charMetrics[chIdx] == 0.0) {
                        this.computeCharHeights(gc, ch, chIdx);
                    }
                }
            }
            answer[0] = this.polish(font.charMetrics[chIdx + 1] + 1.01 / factor, factor);
            answer[1] = this.polish(font.charMetrics[chIdx + 2], factor);
            answer[2] = this.polish(font.charMetrics[chIdx + 0], factor);
            return answer;
        }

        private void computeCharHeights(TestGC gc, int ch, int idx) {
            FontInstance font = gc.getFont();
            ((FontInstance)font).charMetrics[idx + 0] = gc.testGC.getAdvanceWidth((char)ch);
            String s = String.valueOf((char)ch);
            gc.clearImage();
            gc.drawText(s);
            int firstLine = gc.findFirstLine();
            if (firstLine >= 0) {
                double ascent = font.baseLine - firstLine;
                if (Math.abs(ascent - font.ascentUp) <= font.metricTolerance) {
                    ascent = font.ascentUp;
                } else if (Math.abs(ascent - font.ascentLow) <= font.metricTolerance) {
                    ascent = font.ascentLow;
                }
                int descent = gc.findLastLine() - font.baseLine + 1;
                if ((double)Math.abs(descent) <= font.metricTolerance) {
                    descent = 0;
                }
                ((FontInstance)font).charMetrics[idx + 1] = ascent;
                ((FontInstance)font).charMetrics[idx + 2] = descent;
            } else {
                ((FontInstance)font).charMetrics[idx + 1] = 0.0;
                ((FontInstance)font).charMetrics[idx + 2] = 0.0;
            }
            if (idx / 3 < font.strWidth.length && font.strWidth[idx / 3] == 0.0) {
                ((FontInstance)font).strWidth[idx / 3] = gc.getStringWidth(s);
            }
        }

        private double checkCharAscentMean(TestGC gc, char[] chars) {
            FontInstance font = gc.getFont();
            double mean = 0.0;
            int i = 0;
            while (i < chars.length) {
                this.computeCharHeights(gc, chars[i], chars[i] * 3);
                mean += font.charMetrics[chars[i] * 3 + 1];
                gc.testGC.setFont(font.swtFont);
                ++i;
            }
            mean /= (double)chars.length;
            mean = this.polish(mean * 2.0, 1.0) / 2.0;
            i = 0;
            while (i < chars.length) {
                if (Math.abs(mean - font.charMetrics[chars[i] * 3 + 1]) > font.metricTolerance) {
                    return -2.147483648E9;
                }
                ++i;
            }
            i = 0;
            while (i < chars.length) {
                ((FontInstance)font).charMetrics[chars[i] * 3 + 1] = mean;
                ++i;
            }
            return mean;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized double[] getStringWidth(int style, int size, String text) {
            int chIdx;
            double factor;
            FontInstance font;
            if (size < 30 && text.length() == 1) {
                font = this.get(style, 60);
                factor = (double)size / 60.0;
                chIdx = font.checkChar(text.charAt(0));
            } else {
                font = this.get(style, size);
                factor = 1.0;
                chIdx = -1;
            }
            double[] answer = new double[]{8 * text.length()};
            if (chIdx < 0 || chIdx >= font.strWidth.length || font.strWidth[chIdx] == 0.0) {
                Object object = FontManager.this.getTestLock();
                synchronized (object) {
                    double width;
                    TestGC gc = FontManager.this.getTestGC();
                    gc.setFont(font);
                    answer[0] = width = (double)gc.getStringWidth(text);
                    if (chIdx >= 0) {
                        if (font.strWidth.length == 0) {
                            font.strWidth = new double[Math.max(512, chIdx + 256)];
                        } else if (chIdx >= font.strWidth.length) {
                            double[] newWidth = new double[chIdx + 128];
                            System.arraycopy(font.strWidth, 0, newWidth, 0, font.strWidth.length);
                            font.strWidth = newWidth;
                        }
                        ((FontInstance)font).strWidth[chIdx] = width;
                    }
                }
            } else {
                answer[0] = font.strWidth[chIdx];
            }
            if (factor != 1.0) {
                answer[0] = this.polish(answer[0], factor);
            }
            return answer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized double[] getSWTFontProperties(int style, int size) {
            FontInstance font = this.get(style, size);
            if (font.swtFontProperties == null) {
                Object object = FontManager.this.getTestLock();
                synchronized (object) {
                    TestGC gc = FontManager.this.getTestGC();
                    gc.setFont(font);
                }
            }
            return font.swtFontProperties;
        }

        private double polish(double p, double factor) {
            double add;
            if (p == 0.0) {
                return 0.0;
            }
            double d = add = factor < 0.4 ? 0.04 / factor + 0.05 : 0.15;
            if (p > 0.0) {
                return Math.round((p + 0.1) * factor + add);
            }
            return Math.round((p - 0.1) * factor - add);
        }

        public void dispose() {
            int style = 0;
            while (style < 4) {
                FontInstance[] styleFonts = this.fonts[style];
                if (styleFonts != null) {
                    int i = 0;
                    while (i < styleFonts.length) {
                        if (styleFonts[i] != null && styleFonts[i].swtFont != null) {
                            if (!styleFonts[i].swtFont.isDisposed()) {
                                styleFonts[i].swtFont.dispose();
                            }
                            styleFonts[i] = null;
                        }
                        ++i;
                    }
                }
                ++style;
            }
        }
    }

    private static final class FontInstance {
        private static final double[] UNINITIALIZED = new double[0];
        public final int size;
        public final Font swtFont;
        private double[] swtFontProperties;
        private int baseLine;
        private double metricTolerance = 0.0;
        private double ascentUp = -2.147483648E9;
        private double ascentLow = -2.147483648E9;
        private int[] charAbove255;
        private double[] charMetrics = UNINITIALIZED;
        private double[] strWidth = UNINITIALIZED;

        public FontInstance(int size, Font font) {
            this.size = size;
            this.swtFont = font;
        }

        public void init(GC gc) {
            FontMetrics fontMetrics = gc.getFontMetrics();
            this.baseLine = fontMetrics.getLeading() + fontMetrics.getAscent();
            this.metricTolerance = (double)fontMetrics.getAscent() * 0.05;
            this.swtFontProperties = new double[]{this.baseLine};
        }

        public int checkChar(int ch) {
            if (ch <= 0) {
                return 0;
            }
            if (ch <= 255) {
                return ch;
            }
            if (this.charAbove255 == null) {
                this.charAbove255 = new int[256];
                this.charAbove255[0] = ch;
                return 256;
            }
            int i = 0;
            while (i < this.charAbove255.length) {
                int c = this.charAbove255[i];
                if (c == 0) {
                    this.charAbove255[i] = c;
                    return 256 + i;
                }
                if (c == ch) {
                    return 256 + i;
                }
                ++i;
            }
            int[] newChar = new int[this.charAbove255.length + 256];
            System.arraycopy(this.charAbove255, 0, newChar, 0, this.charAbove255.length);
            newChar[this.charAbove255.length] = ch;
            this.charAbove255 = newChar;
            return this.charAbove255.length - 256;
        }
    }

    private static final class TestGC {
        private final GC testGC;
        private FontInstance font;
        private final Image image;
        private final int imageWidth;
        private final int imageHeigth;
        private final int imagePixelBytes;
        private final int imageLineBytes;
        private final byte imageBlankData;
        private ImageData imageData;

        public TestGC(Device device) {
            GC tempGC = new GC((Drawable)device);
            Font tempFont = new Font(device, new FontData(device.getSystemFont().getFontData()[0].getName(), 60, 0));
            tempGC.setFont(tempFont);
            this.imageHeigth = (int)((double)tempGC.getFontMetrics().getHeight() * 1.5);
            this.imageWidth = this.imageHeigth * 2;
            tempGC.dispose();
            tempFont.dispose();
            this.image = new Image(device, this.imageWidth, this.imageHeigth);
            this.testGC = new GC((Drawable)this.image);
            this.testGC.setAdvanced(true);
            this.testGC.setAntialias(1);
            this.testGC.setTextAntialias(1);
            this.testGC.setInterpolation(2);
            this.testGC.setAlpha(255);
            this.testGC.setBackground(device.getSystemColor(1));
            this.testGC.setForeground(device.getSystemColor(2));
            this.testGC.setFont(null);
            this.font = null;
            this.clearImage();
            this.imageData = this.image.getImageData();
            this.imageLineBytes = this.imageData.bytesPerLine;
            this.imagePixelBytes = Math.max(this.imageData.bytesPerLine / this.imageData.width, 1);
            this.imageBlankData = this.imageData.data[0];
        }

        public void setFont(FontInstance font) {
            this.font = font;
            this.testGC.setFont(font.swtFont);
            if (this.font.baseLine == 0) {
                this.font.init(this.testGC);
                this.testGC.setFont(font.swtFont);
            }
        }

        public FontInstance getFont() {
            return this.font;
        }

        public int getStringWidth(String txt) {
            return this.testGC.stringExtent((String)txt).x;
        }

        public void clearImage() {
            this.testGC.fillRectangle(0, 0, this.imageWidth, this.imageHeigth);
            this.imageData = null;
        }

        private void drawText(String txt) {
            this.testGC.drawString(txt, 0, 0, true);
        }

        public int findFirstLine() {
            if (this.imageData == null) {
                this.imageData = this.image.getImageData();
            }
            byte[] data = this.imageData.data;
            int i = 0;
            while (i < data.length) {
                if (data[i] != this.imageBlankData) {
                    return i / this.imageLineBytes;
                }
                i += this.imagePixelBytes;
            }
            return -1;
        }

        public int findLastLine() {
            if (this.imageData == null) {
                this.imageData = this.image.getImageData();
            }
            byte[] data = this.imageData.data;
            int i = data.length - this.imagePixelBytes;
            while (i >= 0) {
                if (data[i] != this.imageBlankData) {
                    return i / this.imageLineBytes;
                }
                i -= this.imagePixelBytes;
            }
            return -1;
        }

        public void dispose() {
            if (!this.testGC.isDisposed()) {
                this.testGC.dispose();
            }
            if (!this.image.isDisposed()) {
                this.image.dispose();
            }
        }
    }
}

