/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.IOException;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.REnvironment;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.AbstractRObject;
import org.eclipse.statet.rj.data.impl.ExternalizableRObject;
import org.eclipse.statet.rj.data.impl.RCharacter32Store;
import org.eclipse.statet.rj.data.impl.RUniqueCharacterHash32Store;

public class REnvironmentImpl
extends AbstractRObject
implements REnvironment,
ExternalizableRObject {
    private byte specialType;
    private String className1;
    private String environmentName;
    private long handle;
    private int length;
    private RObject[] components;
    private RCharacter32Store namesAttribute;

    protected REnvironmentImpl(String name, long handle, RObject[] initialComponents, String[] initialNames, int length, byte specialType, String className1) {
        this.environmentName = name;
        this.handle = handle;
        this.components = initialComponents;
        this.length = length;
        if (initialNames == null) {
            initialNames = new String[length];
        }
        this.namesAttribute = new RCharacter32Store(initialNames, length);
        this.specialType = specialType;
        this.className1 = className1;
    }

    public REnvironmentImpl(RJIO io, RObjectFactory factory) throws IOException {
        this.readExternal(io, factory);
    }

    public void readExternal(RJIO io, RObjectFactory factory) throws IOException {
        int options = io.readInt();
        this.specialType = (byte)(options >>> 24 & 0xFF);
        this.className1 = (options & 0x10) != 0 ? io.readString() : "environment";
        this.handle = io.readLong();
        this.environmentName = io.readString();
        int l = this.length = (int)io.readVULong((byte)(options & 7));
        if ((options & 0x20) != 0) {
            this.namesAttribute = null;
            this.components = null;
        } else {
            this.namesAttribute = new RUniqueCharacterHash32Store(io, l);
            this.components = new RObject[l];
            int i = 0;
            while (i < l) {
                this.components[i] = factory.readObject(io);
                ++i;
            }
        }
        if ((options & 8) != 0) {
            this.setAttributes(factory.readAttributeList(io));
        }
    }

    @Override
    public void writeExternal(RJIO io, RObjectFactory factory) throws IOException {
        RList attributes;
        boolean customClass;
        int l = this.length;
        int options = io.getVULongGrade(l);
        options |= this.specialType << 24;
        boolean bl = customClass = !this.className1.equals("environment");
        if (customClass) {
            options |= 0x10;
        }
        RList rList = attributes = (io.flags & 2) != 0 ? this.getAttributes() : null;
        if (attributes != null) {
            options |= 8;
        }
        if (this.components == null) {
            options |= 0x20;
        }
        io.writeInt(options);
        if (customClass) {
            io.writeString(this.className1);
        }
        io.writeLong(this.handle);
        io.writeString(this.environmentName);
        io.writeVULong((byte)(options & 7), l);
        if (this.components != null) {
            this.namesAttribute.writeExternal(io);
            int i = 0;
            while (i < l) {
                factory.writeObject(this.components[i], io);
                ++i;
            }
        }
        if (attributes != null) {
            factory.writeAttributeList(attributes, io);
        }
    }

    @Override
    public final byte getRObjectType() {
        return 8;
    }

    @Override
    public String getRClassName() {
        return this.className1;
    }

    @Override
    public int getSpecialType() {
        return this.specialType;
    }

    @Override
    public String getEnvironmentName() {
        return this.environmentName;
    }

    @Override
    public long getHandle() {
        return this.handle;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public RCharacterStore getNames() {
        return this.namesAttribute;
    }

    @Override
    public String getName(int idx) {
        return this.namesAttribute.getChar(idx);
    }

    @Override
    public String getName(long idx) {
        return this.namesAttribute.getChar(idx);
    }

    @Override
    public RObject get(int idx) {
        return this.components[idx];
    }

    @Override
    public RObject get(long idx) {
        if (idx < 0L || idx >= Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.components[(int)idx];
    }

    @Override
    public RObject get(String name) {
        int idx = this.namesAttribute.indexOf(name, 0);
        if (idx >= 0) {
            return this.components[idx];
        }
        return null;
    }

    public RObject[] toArray() {
        RObject[] array = new RObject[this.length];
        System.arraycopy(this.components, 0, array, 0, this.length);
        return array;
    }

    @Override
    public RStore<?> getData() {
        return null;
    }

    public boolean set(int idx, RObject component) {
        this.components[idx] = component;
        return true;
    }

    public boolean set(String name, RObject component) {
        if (component == null) {
            throw new NullPointerException();
        }
        int idx = this.namesAttribute.indexOf(name, 0);
        if (idx >= 0) {
            this.components[idx] = component;
            return true;
        }
        return false;
    }

    public void insert(int idx, String name, RObject component) {
        if (component == null) {
            throw new NullPointerException();
        }
        int[] idxs = new int[]{idx};
        this.components = REnvironmentImpl.prepareInsert(this.components, this.length, idxs);
        ++this.length;
        if (name == null) {
            this.namesAttribute.insertNA(idxs);
        } else {
            this.namesAttribute.insertChar(idx, name);
        }
    }

    public void add(String name, RObject component) {
        this.insert(this.length, name, component);
    }

    public void remove(int idx) {
        int[] idxs = new int[]{idx};
        this.components = REnvironmentImpl.remove(this.components, this.length, idxs);
        --this.length;
        this.namesAttribute.remove(idxs);
    }

    public boolean containsName(String name) {
        return this.namesAttribute.indexOf(name) >= 0L;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RObject type=REnvironment, class=").append(this.getRClassName());
        sb.append("\n\tlength=").append(this.length);
        if (this.components != null) {
            sb.append("\n\tdata: ");
            int i = 0;
            while (i < this.length) {
                sb.append("\n$").append(this.namesAttribute.getChar(i)).append("\n");
                sb.append(this.components[i]);
                ++i;
            }
        } else {
            sb.append("\n<NODATA/>");
        }
        return sb.toString();
    }
}

