/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.statet.ecommons.io.TextContentDescriber;

public class RPkgDescriptionTextContentDescriber
extends TextContentDescriber {
    private static final QualifiedName[] SUPPORTED_OPTIONS = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};
    private static final String PACKAGE_FIELD = "Package:";
    private static final String ENCODING_FIELD = "Encoding:";

    public QualifiedName[] getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }

    public int describe(Reader contents, IContentDescription description) throws IOException {
        if (description != null && description.isRequested(IContentDescription.CHARSET)) {
            BufferedReader reader = new BufferedReader(contents);
            ParseResult result = this.parse(reader);
            if (result.isIndeterminate()) {
                return 1;
            }
            if (result.hasCharsetSpec()) {
                description.setProperty(IContentDescription.CHARSET, (Object)result.getCharsetName());
            }
        }
        return 2;
    }

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        byte[] bom = this.getByteOrderMark(contents);
        String baseEncoding = "ISO-8859-1";
        if (bom != null) {
            if (bom == IContentDescription.BOM_UTF_16BE) {
                baseEncoding = "UTF-16BE";
            } else if (bom == IContentDescription.BOM_UTF_16LE) {
                baseEncoding = "UTF-16LE";
            } else if (bom == IContentDescription.BOM_UTF_8) {
                baseEncoding = "UTF-8";
            }
            if (description != null && description.isRequested(IContentDescription.BYTE_ORDER_MARK)) {
                description.setProperty(IContentDescription.BYTE_ORDER_MARK, (Object)bom);
            }
        }
        if (description != null && description.isRequested(IContentDescription.CHARSET)) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(contents, baseEncoding));
            ParseResult result = this.parse(reader);
            if (result.isIndeterminate()) {
                return 1;
            }
            if (result.hasCharsetSpec()) {
                description.setProperty(IContentDescription.CHARSET, (Object)result.getCharsetName());
            }
        }
        return 2;
    }

    private ParseResult parse(BufferedReader reader) throws IOException {
        String line;
        ParseResult result = new ParseResult();
        while ((line = reader.readLine()) != null) {
            if (line.startsWith(PACKAGE_FIELD)) {
                if ((result.state & 1) == 0) {
                    result.state = 1;
                    continue;
                }
                result.state = 0x10000000;
                break;
            }
            if (!line.startsWith(ENCODING_FIELD)) continue;
            String value = line.substring(ENCODING_FIELD.length()).trim();
            if (result.encoding != null || value.isEmpty()) continue;
            result.encoding = value;
        }
        return result;
    }

    private static class ParseResult {
        public static final int PKG_FIELD = 1;
        public static final int ERROR = 0x10000000;
        private int state;
        private String encoding;

        public boolean isIndeterminate() {
            return this.state == 0x10000000 || this.state == 0 && this.encoding == null;
        }

        public boolean hasCharsetSpec() {
            return this.encoding != null;
        }

        public String getCharsetName() {
            String name = this.encoding;
            try {
                Charset charset = Charset.forName(this.encoding);
                name = charset.name();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return name;
        }
    }
}

