/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.builder;

import java.io.Serializable;
import java.util.List;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RLangElement;

@NonNullByDefault
public class ExportedRElement
implements RLangElement<RLangElement<?>>,
Serializable {
    private static final long serialVersionUID = -493469386405499748L;
    private RLangElement<?> parent;
    private int elementType;
    private RElementName elementName;
    private String elementId;
    private int sourceOffset;
    private int sourceLength;
    private int nameOffset;
    private int nameLength;

    public ExportedRElement(RLangElement<?> parent, RLangElement<?> sourceElement) {
        this.parent = parent;
        this.elementType = sourceElement.getElementType();
        this.elementName = RElementName.cloneName(sourceElement.getElementName(), false);
        this.elementId = sourceElement.getId();
        TextRegion sourceRange = sourceElement.getSourceRange();
        if (sourceRange != null) {
            this.sourceOffset = sourceRange.getStartOffset();
            this.sourceLength = sourceRange.getLength();
        } else {
            this.sourceOffset = -1;
        }
        sourceRange = sourceElement.getNameSourceRange();
        if (sourceRange != null) {
            this.nameOffset = sourceRange.getStartOffset();
            this.nameLength = sourceRange.getLength();
        } else {
            this.nameOffset = -1;
        }
    }

    public ExportedRElement() {
    }

    public String getModelTypeId() {
        return "R";
    }

    public String getId() {
        return this.elementId;
    }

    public int getElementType() {
        return this.elementType;
    }

    @Override
    public RElementName getElementName() {
        return this.elementName;
    }

    public boolean exists() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    @Override
    public RLangElement<?> getModelParent() {
        return this.parent;
    }

    @Override
    public boolean hasModelChildren(@Nullable LtkModelElementFilter<? super RLangElement<?>> filter) {
        return false;
    }

    @Override
    public List<? extends RLangElement<?>> getModelChildren(@Nullable LtkModelElementFilter<? super RLangElement<?>> filter) {
        return ImCollections.emptyList();
    }

    public SourceUnit getSourceUnit() {
        return this.parent.getSourceUnit();
    }

    public @Nullable TextRegion getSourceRange() {
        if (this.sourceOffset >= 0) {
            return new BasicTextRegion(this.sourceOffset, this.sourceOffset + this.sourceLength);
        }
        return null;
    }

    public @Nullable TextRegion getNameSourceRange() {
        if (this.nameOffset >= 0) {
            return new BasicTextRegion(this.nameOffset, this.nameOffset + this.nameLength);
        }
        return null;
    }

    public @Nullable TextRegion getDocumentationRange() {
        return null;
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        return null;
    }
}

