/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.edit;

import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.coordinate.PositionCoordinate;
import org.eclipse.statet.ecommons.waltable.layer.ILayer;
import org.eclipse.statet.ecommons.waltable.layer.event.ILayerEvent;
import org.eclipse.swt.widgets.Composite;

public class InlineCellEditEvent
implements ILayerEvent {
    private ILayer layer;
    private final PositionCoordinate cellCoordinate;
    private final Composite parent;
    private final IConfigRegistry configRegistry;
    private final Object initialValue;

    public InlineCellEditEvent(ILayer layer, PositionCoordinate cellCoordinate, Composite parent, IConfigRegistry configRegistry, Object initialValue) {
        this.layer = layer;
        this.cellCoordinate = cellCoordinate;
        this.parent = parent;
        this.configRegistry = configRegistry;
        this.initialValue = initialValue;
    }

    @Override
    public boolean convertToLocal(ILayer localLayer) {
        this.cellCoordinate.columnPosition = localLayer.getDim(Orientation.HORIZONTAL).underlyingToLocalPosition(this.layer.getDim(Orientation.HORIZONTAL), this.cellCoordinate.columnPosition);
        if (this.cellCoordinate.columnPosition < 0L || this.cellCoordinate.columnPosition >= localLayer.getColumnCount()) {
            return false;
        }
        this.cellCoordinate.rowPosition = localLayer.getDim(Orientation.VERTICAL).underlyingToLocalPosition(this.layer.getDim(Orientation.VERTICAL), this.cellCoordinate.rowPosition);
        if (this.cellCoordinate.rowPosition < 0L || this.cellCoordinate.rowPosition >= localLayer.getRowCount()) {
            return false;
        }
        this.layer = localLayer;
        return true;
    }

    public long getColumnPosition() {
        return this.cellCoordinate.columnPosition;
    }

    public long getRowPosition() {
        return this.cellCoordinate.rowPosition;
    }

    public Composite getParent() {
        return this.parent;
    }

    public IConfigRegistry getConfigRegistry() {
        return this.configRegistry;
    }

    public Object getInitialValue() {
        return this.initialValue;
    }

    @Override
    public InlineCellEditEvent cloneEvent() {
        return new InlineCellEditEvent(this.layer, new PositionCoordinate(this.cellCoordinate), this.parent, this.configRegistry, this.initialValue);
    }
}

