/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.refactoring;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.ltk.ui.refactoring.Messages;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.refactoring.core.CommonRefactoringFactory;
import org.eclipse.statet.ltk.refactoring.core.RefactoringAdapter;
import org.eclipse.statet.ltk.ui.refactoring.AbstractElementsHandler;
import org.eclipse.statet.ltk.ui.util.LTKSelectionUtils;
import org.eclipse.ui.statushandlers.StatusManager;

public class CopyElementsHandler
extends AbstractElementsHandler {
    public CopyElementsHandler(CommonRefactoringFactory refactoring) {
        super(refactoring);
    }

    public void setEnabled(Object context) {
        ISelection selection = WorkbenchUIUtils.getCurrentSelection((Object)context);
        if (selection != null) {
            this.setBaseEnabled(!selection.isEmpty());
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = WorkbenchUIUtils.getCurrentSelection((Object)event.getApplicationContext());
        if (selection == null || selection.isEmpty()) {
            return null;
        }
        SourceStructElement[] sourceElements = LTKSelectionUtils.getSelectedSourceStructElements(selection);
        if (sourceElements != null) {
            RefactoringAdapter adapter = this.refactoring.createAdapter((Object)sourceElements);
            if (adapter == null) {
                return null;
            }
            try {
                String code = adapter.getSourceCodeStringedTogether(sourceElements, null);
                this.copyToClipboard(event, code);
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, adapter.getPluginIdentifier(), -1, Messages.CopyElements_error_message, (Throwable)e), 3);
            }
        }
        return null;
    }
}

